/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.Map;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.NullabilityAnnotationStates;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt;
import kotlin.reflect.jvm.internal.impl.storage.LockBasedStorageManager;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNullable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NullabilityAnnotationStatesImpl<T>
implements NullabilityAnnotationStates<T> {
    @NotNull
    private final Map<FqName, T> states;
    @NotNull
    private final LockBasedStorageManager storageManager;
    @NotNull
    private final MemoizedFunctionToNullable<FqName, T> cache;

    public NullabilityAnnotationStatesImpl(@NotNull Map<FqName, ? extends T> states) {
        Intrinsics.checkNotNullParameter(states, "states");
        this.states = states;
        this.storageManager = new LockBasedStorageManager("Java nullability annotation states");
        MemoizedFunctionToNullable memoizedFunctionToNullable = this.storageManager.createMemoizedFunctionWithNullableValues(new Function1<FqName, T>(this){
            final /* synthetic */ NullabilityAnnotationStatesImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final T invoke(FqName it) {
                Intrinsics.checkNotNull(it);
                return FqNamesUtilKt.findValueForMostSpecificFqname(it, this.this$0.getStates());
            }
        });
        Intrinsics.checkNotNullExpressionValue(memoizedFunctionToNullable, "createMemoizedFunctionWithNullableValues(...)");
        this.cache = memoizedFunctionToNullable;
    }

    @NotNull
    public final Map<FqName, T> getStates() {
        return this.states;
    }

    @Override
    @Nullable
    public T get(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return (T)this.cache.invoke(fqName2);
    }
}

