/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.CallableReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.IllegalCallableAccessException;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import kotlin.reflect.jvm.internal.ReflectKCallable;
import kotlin.reflect.jvm.internal.ReflectKProperty;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.calls.Caller;
import kotlin.reflect.jvm.internal.calls.ValueClassAwareCallerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\b\u001a\u0004\u0018\u00010\u0005*\u0004\u0018\u00010\u00052\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002\u001a\u001d\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b*\u0006\u0012\u0002\b\u00030\u0002H\u0000\u00a2\u0006\u0002\u0010\f\u001aA\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u00022\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00102\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0000\u00a2\u0006\u0002\u0010\u0014\u001a3\u0010\u0015\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u00022\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0010H\u0000\u00a2\u0006\u0002\u0010\u0016\u001a\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\"\u001c\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u0006\u0012\u0002\b\u00030\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u001c\u0010\u001a\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0003\"\u001c\u0010\u001b\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0003\u00a8\u0006\u001c"}, d2={"isBound", "", "Lkotlin/reflect/jvm/internal/ReflectKCallable;", "(Lkotlin/reflect/jvm/internal/ReflectKCallable;)Z", "boundReceiver", "", "getBoundReceiver", "(Lkotlin/reflect/jvm/internal/ReflectKCallable;)Ljava/lang/Object;", "coerceToExpectedReceiverType", "callable", "computeAbsentArguments", "", "(Lkotlin/reflect/jvm/internal/ReflectKCallable;)[Ljava/lang/Object;", "callDefaultMethod", "R", "args", "", "Lkotlin/reflect/KParameter;", "continuationArgument", "Lkotlin/coroutines/Continuation;", "(Lkotlin/reflect/jvm/internal/ReflectKCallable;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "callAnnotationConstructor", "(Lkotlin/reflect/jvm/internal/ReflectKCallable;Ljava/util/Map;)Ljava/lang/Object;", "defaultEmptyArray", "type", "Lkotlin/reflect/KType;", "isConstructor", "isAnnotationConstructor", "kotlin-reflection"})
@SourceDebugExtension(value={"SMAP\nReflectKCallable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectKCallable.kt\nkotlin/reflect/jvm/internal/ReflectKCallableKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 util.kt\nkotlin/reflect/jvm/internal/UtilKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,198:1\n672#2,11:199\n1834#2,4:210\n1915#2,2:214\n1586#2:231\n1661#2,3:232\n286#3,5:216\n286#3,5:221\n286#3,5:226\n286#3,2:235\n288#3,3:239\n37#4,2:237\n*S KotlinDebug\n*F\n+ 1 ReflectKCallable.kt\nkotlin/reflect/jvm/internal/ReflectKCallableKt\n*L\n74#1:199,11\n84#1:210,4\n91#1:214,2\n166#1:231\n166#1:232,3\n114#1:216,5\n152#1:221,5\n160#1:226,5\n180#1:235,2\n180#1:239,3\n181#1:237,2\n*E\n"})
public final class ReflectKCallableKt {
    public static final boolean isBound(@NotNull ReflectKCallable<?> $this$isBound) {
        Intrinsics.checkNotNullParameter($this$isBound, (String)"<this>");
        return $this$isBound.getRawBoundReceiver() != CallableReference.NO_RECEIVER;
    }

    @Nullable
    public static final Object getBoundReceiver(@NotNull ReflectKCallable<?> $this$boundReceiver) {
        Intrinsics.checkNotNullParameter($this$boundReceiver, (String)"<this>");
        return ReflectKCallableKt.coerceToExpectedReceiverType($this$boundReceiver.getRawBoundReceiver(), $this$boundReceiver);
    }

    private static final Object coerceToExpectedReceiverType(Object $this$coerceToExpectedReceiverType, ReflectKCallable<?> callable) {
        Object v0;
        block4: {
            if (callable instanceof ReflectKProperty && ValueClassAwareCallerKt.isUnderlyingPropertyOfValueClass((ReflectKProperty)callable)) {
                return $this$coerceToExpectedReceiverType;
            }
            Iterable $this$singleOrNull$iv = callable.getAllParameters();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                KParameter it = (KParameter)element$iv;
                boolean bl = false;
                if (!(it.getKind() != KParameter.Kind.VALUE)) continue;
                if (found$iv) {
                    v0 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        KParameter kParameter = v0;
        Object expectedReceiverType = kParameter != null ? kParameter.getType() : null;
        Object object = expectedReceiverType;
        if (object == null || (object = ValueClassAwareCallerKt.toInlineClass((KType)object)) == null || (object = ValueClassAwareCallerKt.getInlineClassUnboxMethod(object, callable)) == null) {
            return $this$coerceToExpectedReceiverType;
        }
        Object unboxMethod = object;
        return ((Method)unboxMethod).invoke($this$coerceToExpectedReceiverType, new Object[0]);
    }

    @NotNull
    public static final Object[] computeAbsentArguments(@NotNull ReflectKCallable<?> $this$computeAbsentArguments) {
        int n;
        Intrinsics.checkNotNullParameter($this$computeAbsentArguments, (String)"<this>");
        List parameters = $this$computeAbsentArguments.getParameters();
        int parameterSize = parameters.size() + ($this$computeAbsentArguments.isSuspend() ? 1 : 0);
        Iterable $this$count$iv = parameters;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                KParameter it = (KParameter)element$iv;
                boolean bl = false;
                if (!(it.getKind() == KParameter.Kind.VALUE || it.getKind() == KParameter.Kind.CONTEXT) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int parametersWithAllocatedBitInMask = n;
        int maskSize = (parametersWithAllocatedBitInMask + 32 - 1) / 32;
        Object[] arguments = new Object[parameterSize + maskSize + 1];
        Iterable $this$forEach$iv = parameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KParameter parameter = (KParameter)element$iv;
            boolean bl = false;
            if (parameter.isOptional() && !UtilKt.isInlineClassType(parameter.getType())) {
                arguments[parameter.getIndex()] = UtilKt.defaultPrimitiveValue(ReflectJvmMapping.getJavaType(parameter.getType()));
                continue;
            }
            if (!parameter.isVararg()) continue;
            arguments[parameter.getIndex()] = ReflectKCallableKt.defaultEmptyArray(parameter.getType());
        }
        for (int i = 0; i < maskSize; ++i) {
            arguments[parameterSize + i] = 0;
        }
        return arguments;
    }

    public static final <R> R callDefaultMethod(@NotNull ReflectKCallable<? extends R> $this$callDefaultMethod, @NotNull Map<KParameter, ? extends Object> args, @Nullable Continuation<?> continuationArgument) {
        Object object;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter($this$callDefaultMethod, (String)"<this>");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        List parameters = $this$callDefaultMethod.getParameters();
        if (parameters.isEmpty()) {
            Object object2;
            boolean $i$f$reflectionCall = false;
            try {
                Object[] objectArray2;
                boolean bl = false;
                Caller<?> caller = $this$callDefaultMethod.getCaller();
                if ($this$callDefaultMethod.isSuspend()) {
                    Continuation[] continuationArray = new Continuation[]{continuationArgument};
                    objectArray2 = continuationArray;
                } else {
                    objectArray2 = new Continuation[]{};
                }
                object2 = caller.call(objectArray2);
            }
            catch (IllegalAccessException e$iv) {
                throw new IllegalCallableAccessException(e$iv);
            }
            return (R)object2;
        }
        int parameterSize = parameters.size() + ($this$callDefaultMethod.isSuspend() ? 1 : 0);
        Object[] $this$callDefaultMethod_u24lambda_u241 = objectArray = $this$callDefaultMethod.getAbsentArguments();
        boolean bl = false;
        if ($this$callDefaultMethod.isSuspend()) {
            $this$callDefaultMethod_u24lambda_u241[parameters.size()] = continuationArgument;
        }
        Object[] arguments = objectArray;
        int valueParameterIndex = 0;
        boolean anyOptional = false;
        for (KParameter parameter : parameters) {
            if (args.containsKey(parameter)) {
                arguments[parameter.getIndex()] = args.get(parameter);
            } else if (parameter.isOptional()) {
                int maskIndex = parameterSize + valueParameterIndex / 32;
                Object object3 = arguments[maskIndex];
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Int");
                arguments[maskIndex] = (Integer)object3 | 1 << valueParameterIndex % 32;
                anyOptional = true;
            } else if (!parameter.isVararg()) {
                throw new IllegalArgumentException("No argument provided for a required parameter: " + parameter);
            }
            if (parameter.getKind() != KParameter.Kind.VALUE && parameter.getKind() != KParameter.Kind.CONTEXT) continue;
            ++valueParameterIndex;
        }
        if (!anyOptional) {
            Object maskIndex;
            boolean $i$f$reflectionCall = false;
            try {
                boolean bl2 = false;
                Caller<?> caller = $this$callDefaultMethod.getCaller();
                Object[] objectArray3 = Arrays.copyOf(arguments, parameterSize);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"copyOf(...)");
                maskIndex = caller.call(objectArray3);
            }
            catch (IllegalAccessException e$iv) {
                throw new IllegalCallableAccessException(e$iv);
            }
            return (R)maskIndex;
        }
        Caller<?> caller = $this$callDefaultMethod.getDefaultCaller();
        if (caller == null) {
            throw new KotlinReflectionInternalError("This callable does not support a default call: " + $this$callDefaultMethod);
        }
        Caller<?> caller2 = caller;
        boolean $i$f$reflectionCall = false;
        try {
            boolean bl3 = false;
            object = caller2.call(arguments);
        }
        catch (IllegalAccessException e$iv) {
            throw new IllegalCallableAccessException(e$iv);
        }
        return (R)object;
    }

    /*
     * WARNING - void declaration
     */
    public static final <R> R callAnnotationConstructor(@NotNull ReflectKCallable<? extends R> $this$callAnnotationConstructor, @NotNull Map<KParameter, ? extends Object> args) {
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$callAnnotationConstructor, (String)"<this>");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Iterable $this$map$iv = $this$callAnnotationConstructor.getParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object2;
            void parameter;
            KParameter kParameter = (KParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (args.containsKey(parameter)) {
                object2 = args.get(parameter);
                if (object2 == null) {
                    throw new IllegalArgumentException("Annotation argument value cannot be null (" + parameter + ')');
                }
            } else if (parameter.isOptional()) {
                object2 = null;
            } else if (parameter.isVararg()) {
                object2 = ReflectKCallableKt.defaultEmptyArray(parameter.getType());
            } else {
                throw new IllegalArgumentException("No argument provided for a required parameter: " + parameter);
            }
            collection.add(object2);
        }
        List arguments = (List)destination$iv$iv;
        Caller<?> caller = $this$callAnnotationConstructor.getDefaultCaller();
        if (caller == null) {
            throw new KotlinReflectionInternalError("This callable does not support a default call: " + $this$callAnnotationConstructor);
        }
        Caller<?> caller2 = caller;
        boolean $i$f$reflectionCall = false;
        try {
            boolean bl = false;
            Collection $this$toTypedArray$iv = arguments;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = caller2.call(thisCollection$iv.toArray(new Object[0]));
        }
        catch (IllegalAccessException e$iv) {
            throw new IllegalCallableAccessException(e$iv);
        }
        return (R)object;
    }

    private static final Object defaultEmptyArray(KType type) {
        Class $this$defaultEmptyArray_u24lambda_u240 = JvmClassMappingKt.getJavaClass(KTypesJvm.getJvmErasure(type));
        boolean bl = false;
        if (!$this$defaultEmptyArray_u24lambda_u240.isArray()) {
            throw new KotlinReflectionInternalError("Cannot instantiate the default empty array of type " + $this$defaultEmptyArray_u24lambda_u240.getSimpleName() + ", because it is not an array type");
        }
        Object object = Array.newInstance($this$defaultEmptyArray_u24lambda_u240.getComponentType(), 0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return object;
    }

    public static final boolean isConstructor(@NotNull ReflectKCallable<?> $this$isConstructor) {
        Intrinsics.checkNotNullParameter($this$isConstructor, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isConstructor.getName(), (Object)"<init>");
    }

    public static final boolean isAnnotationConstructor(@NotNull ReflectKCallable<?> $this$isAnnotationConstructor) {
        Intrinsics.checkNotNullParameter($this$isAnnotationConstructor, (String)"<this>");
        return ReflectKCallableKt.isConstructor($this$isAnnotationConstructor) && $this$isAnnotationConstructor.getContainer().getJClass().isAnnotation();
    }
}

