/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.serialization.SerializerExtensionProtocol;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotatedCallableKind;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nAbstractAnnotationLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractAnnotationLoader.kt\norg/jetbrains/kotlin/serialization/deserialization/AbstractAnnotationLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1#2:144\n1586#3:145\n1661#3,3:146\n*S KotlinDebug\n*F\n+ 1 AbstractAnnotationLoader.kt\norg/jetbrains/kotlin/serialization/deserialization/AbstractAnnotationLoader\n*L\n141#1:145\n141#1:146,3\n*E\n"})
public abstract class AbstractAnnotationLoader<A>
implements AnnotationLoader<A> {
    @NotNull
    private final SerializerExtensionProtocol protocol;

    public AbstractAnnotationLoader(@NotNull SerializerExtensionProtocol protocol) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        this.protocol = protocol;
    }

    @NotNull
    protected final SerializerExtensionProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    @NotNull
    public List<A> loadClassAnnotations(@NotNull ProtoContainer.Class container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        List<ProtoBuf.Annotation> list = container.getClassProto().getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
        return this.loadAnnotations(list, container.getClassProto().getExtension(this.protocol.getClassAnnotation()), container.getNameResolver());
    }

    @Override
    @NotNull
    public List<A> loadCallableAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite proto, @NotNull AnnotatedCallableKind kind2) {
        List<A> list;
        block6: {
            block8: {
                MessageLite messageLite;
                block7: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
                        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
                        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
                        messageLite = proto;
                        if (!(messageLite instanceof ProtoBuf.Constructor)) break block5;
                        List<ProtoBuf.Annotation> list2 = ((ProtoBuf.Constructor)proto).getAnnotationList();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAnnotationList(...)");
                        list = this.loadAnnotations(list2, ((ProtoBuf.Constructor)proto).getExtension(this.protocol.getConstructorAnnotation()), container.getNameResolver());
                        break block6;
                    }
                    if (!(messageLite instanceof ProtoBuf.Function)) break block7;
                    List<ProtoBuf.Annotation> list3 = ((ProtoBuf.Function)proto).getAnnotationList();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"getAnnotationList(...)");
                    list = this.loadAnnotations(list3, ((ProtoBuf.Function)proto).getExtension(this.protocol.getFunctionAnnotation()), container.getNameResolver());
                    break block6;
                }
                if (!(messageLite instanceof ProtoBuf.Property)) break block8;
                switch (WhenMappings.$EnumSwitchMapping$0[kind2.ordinal()]) {
                    case 1: {
                        List<ProtoBuf.Annotation> list4 = ((ProtoBuf.Property)proto).getAnnotationList();
                        Intrinsics.checkNotNullExpressionValue(list4, (String)"getAnnotationList(...)");
                        list = this.loadAnnotations(list4, ((ProtoBuf.Property)proto).getExtension(this.protocol.getPropertyAnnotation()), container.getNameResolver());
                        break block6;
                    }
                    case 2: {
                        List<ProtoBuf.Annotation> list5 = ((ProtoBuf.Property)proto).getGetterAnnotationList();
                        Intrinsics.checkNotNullExpressionValue(list5, (String)"getGetterAnnotationList(...)");
                        list = this.loadAnnotations(list5, ((ProtoBuf.Property)proto).getExtension(this.protocol.getPropertyGetterAnnotation()), container.getNameResolver());
                        break block6;
                    }
                    case 3: {
                        List<ProtoBuf.Annotation> list6 = ((ProtoBuf.Property)proto).getSetterAnnotationList();
                        Intrinsics.checkNotNullExpressionValue(list6, (String)"getSetterAnnotationList(...)");
                        list = this.loadAnnotations(list6, ((ProtoBuf.Property)proto).getExtension(this.protocol.getPropertySetterAnnotation()), container.getNameResolver());
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported callable kind with property proto".toString());
                    }
                }
            }
            throw new IllegalStateException(("Unknown message: " + proto).toString());
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<A> loadPropertyBackingFieldAnnotations(@NotNull ProtoContainer container, @NotNull ProtoBuf.Property proto) {
        List list;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        AbstractAnnotationLoader abstractAnnotationLoader = this;
        List<ProtoBuf.Annotation> list2 = proto.getBackingFieldAnnotationList();
        List<ProtoBuf.Annotation> list3 = list2;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getBackingFieldAnnotationList(...)");
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, List<ProtoBuf.Annotation>> generatedExtension = this.protocol.getPropertyBackingFieldAnnotation();
        if (generatedExtension != null) {
            void it;
            GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, List<ProtoBuf.Annotation>> generatedExtension2 = generatedExtension;
            List<ProtoBuf.Annotation> list4 = list3;
            AbstractAnnotationLoader abstractAnnotationLoader2 = abstractAnnotationLoader;
            boolean bl = false;
            List list5 = (List)proto.getExtension(it);
            abstractAnnotationLoader = abstractAnnotationLoader2;
            list3 = list4;
            list = list5;
        } else {
            list = null;
        }
        return abstractAnnotationLoader.loadAnnotations(list3, list, container.getNameResolver());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<A> loadPropertyDelegateFieldAnnotations(@NotNull ProtoContainer container, @NotNull ProtoBuf.Property proto) {
        List list;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        AbstractAnnotationLoader abstractAnnotationLoader = this;
        List<ProtoBuf.Annotation> list2 = proto.getDelegateFieldAnnotationList();
        List<ProtoBuf.Annotation> list3 = list2;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getDelegateFieldAnnotationList(...)");
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, List<ProtoBuf.Annotation>> generatedExtension = this.protocol.getPropertyDelegatedFieldAnnotation();
        if (generatedExtension != null) {
            void it;
            GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, List<ProtoBuf.Annotation>> generatedExtension2 = generatedExtension;
            List<ProtoBuf.Annotation> list4 = list3;
            AbstractAnnotationLoader abstractAnnotationLoader2 = abstractAnnotationLoader;
            boolean bl = false;
            List list5 = (List)proto.getExtension(it);
            abstractAnnotationLoader = abstractAnnotationLoader2;
            list3 = list4;
            list = list5;
        } else {
            list = null;
        }
        return abstractAnnotationLoader.loadAnnotations(list3, list, container.getNameResolver());
    }

    @Override
    @NotNull
    public List<A> loadEnumEntryAnnotations(@NotNull ProtoContainer container, @NotNull ProtoBuf.EnumEntry proto) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        List<ProtoBuf.Annotation> list = proto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
        return this.loadAnnotations(list, proto.getExtension(this.protocol.getEnumEntryAnnotation()), container.getNameResolver());
    }

    @Override
    @NotNull
    public List<A> loadValueParameterAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite callableProto, @NotNull AnnotatedCallableKind kind2, int parameterIndex, @NotNull ProtoBuf.ValueParameter proto) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)callableProto, (String)"callableProto");
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        List<ProtoBuf.Annotation> list = proto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
        return this.loadAnnotations(list, proto.getExtension(this.protocol.getParameterAnnotation()), container.getNameResolver());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<A> loadExtensionReceiverParameterAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite proto, @NotNull AnnotatedCallableKind kind2) {
        List<A> list;
        block8: {
            block9: {
                MessageLite messageLite;
                block7: {
                    List list2;
                    Intrinsics.checkNotNullParameter((Object)container, (String)"container");
                    Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
                    Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
                    messageLite = proto;
                    if (!(messageLite instanceof ProtoBuf.Function)) break block7;
                    AbstractAnnotationLoader abstractAnnotationLoader = this;
                    List<ProtoBuf.Annotation> list3 = ((ProtoBuf.Function)proto).getExtensionReceiverAnnotationList();
                    List<ProtoBuf.Annotation> list4 = list3;
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"getExtensionReceiverAnnotationList(...)");
                    GeneratedMessageLite.GeneratedExtension<ProtoBuf.Function, List<ProtoBuf.Annotation>> generatedExtension = this.protocol.getFunctionExtensionReceiverAnnotation();
                    if (generatedExtension != null) {
                        void it;
                        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Function, List<ProtoBuf.Annotation>> generatedExtension2 = generatedExtension;
                        List<ProtoBuf.Annotation> list5 = list4;
                        AbstractAnnotationLoader abstractAnnotationLoader2 = abstractAnnotationLoader;
                        boolean bl = false;
                        List list6 = (List)((ProtoBuf.Function)proto).getExtension(it);
                        abstractAnnotationLoader = abstractAnnotationLoader2;
                        list4 = list5;
                        list2 = list6;
                    } else {
                        list2 = null;
                    }
                    list = abstractAnnotationLoader.loadAnnotations(list4, list2, container.getNameResolver());
                    break block8;
                }
                if (!(messageLite instanceof ProtoBuf.Property)) break block9;
                switch (WhenMappings.$EnumSwitchMapping$0[kind2.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        List list7;
                        AbstractAnnotationLoader abstractAnnotationLoader = this;
                        List<ProtoBuf.Annotation> list8 = ((ProtoBuf.Property)proto).getExtensionReceiverAnnotationList();
                        List<ProtoBuf.Annotation> list9 = list8;
                        Intrinsics.checkNotNullExpressionValue(list8, (String)"getExtensionReceiverAnnotationList(...)");
                        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, List<ProtoBuf.Annotation>> generatedExtension = this.protocol.getPropertyExtensionReceiverAnnotation();
                        if (generatedExtension != null) {
                            void it;
                            GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, List<ProtoBuf.Annotation>> generatedExtension3 = generatedExtension;
                            List<ProtoBuf.Annotation> list10 = list9;
                            AbstractAnnotationLoader abstractAnnotationLoader3 = abstractAnnotationLoader;
                            boolean bl = false;
                            List list11 = (List)((ProtoBuf.Property)proto).getExtension(it);
                            abstractAnnotationLoader = abstractAnnotationLoader3;
                            list9 = list10;
                            list7 = list11;
                        } else {
                            list7 = null;
                        }
                        list = abstractAnnotationLoader.loadAnnotations(list9, list7, container.getNameResolver());
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException(("Unsupported callable kind with property proto for receiver annotations: " + (Object)((Object)kind2)).toString());
                    }
                }
            }
            throw new IllegalStateException(("Unknown message: " + proto).toString());
        }
        return list;
    }

    @Override
    @NotNull
    public List<A> loadContextParameterAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite callableProto, @NotNull AnnotatedCallableKind kind2, int parameterIndex, @Nullable ProtoBuf.ValueParameter proto) {
        List<A> list;
        List<A> list2;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)callableProto, (String)"callableProto");
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        ProtoBuf.ValueParameter valueParameter = proto;
        if (valueParameter != null) {
            ProtoBuf.ValueParameter it = valueParameter;
            boolean bl = false;
            list2 = this.loadValueParameterAnnotations(container, callableProto, kind2, parameterIndex, it);
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<A> loadTypeAnnotations(@NotNull ProtoBuf.Type proto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        List<ProtoBuf.Annotation> list = proto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
        return this.loadAnnotations(list, proto.getExtension(this.protocol.getTypeAnnotation()), nameResolver);
    }

    @Override
    @NotNull
    public List<A> loadTypeParameterAnnotations(@NotNull ProtoBuf.TypeParameter proto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        List<ProtoBuf.Annotation> list = proto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
        return this.loadAnnotations(list, proto.getExtension(this.protocol.getTypeParameterAnnotation()), nameResolver);
    }

    /*
     * WARNING - void declaration
     */
    private final List<A> loadAnnotations(List<ProtoBuf.Annotation> commonMetadataSource, List<ProtoBuf.Annotation> extensionProtocolMetadataSource, NameResolver nameResolver) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list;
        Iterable iterable = commonMetadataSource;
        if (iterable.isEmpty()) {
            boolean bl = false;
            list = extensionProtocolMetadataSource;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
        } else {
            list = iterable;
        }
        iterable = list;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.loadAnnotation((ProtoBuf.Annotation)it, nameResolver));
        }
        return (List)destination$iv$iv;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotatedCallableKind.values().length];
            try {
                nArray[AnnotatedCallableKind.PROPERTY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotatedCallableKind.PROPERTY_GETTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotatedCallableKind.PROPERTY_SETTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

