/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.diagnostic;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationErrors;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationAnnotations;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\t"}, d2={"checkCompanionSerializerDependency", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkCompanionOfSerializableClass", "kotlinx-serialization-compiler-plugin.k1"})
@SourceDebugExtension(value={"SMAP\nSerializationPluginCompanionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializationPluginCompanionChecker.kt\norg/jetbrains/kotlinx/serialization/compiler/diagnostic/SerializationPluginCompanionCheckerKt\n+ 2 SerializationPluginDeclarationChecker.kt\norg/jetbrains/kotlinx/serialization/compiler/diagnostic/SerializationPluginDeclarationCheckerKt\n*L\n1#1,81:1\n754#2,2:82\n754#2,2:84\n*S KotlinDebug\n*F\n+ 1 SerializationPluginCompanionChecker.kt\norg/jetbrains/kotlinx/serialization/compiler/diagnostic/SerializationPluginCompanionCheckerKt\n*L\n22#1:82,2\n72#1:84,2\n*E\n"})
public final class SerializationPluginCompanionCheckerKt {
    public static final void checkCompanionSerializerDependency(@NotNull ClassDescriptor descriptor, @NotNull KtDeclaration declaration, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        ClassDescriptor classDescriptor = descriptor.getCompanionObjectDescriptor();
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor companionObjectDescriptor = classDescriptor;
        KotlinType kotlinType = KSerializationUtilKt.getSerializerForClass((DeclarationDescriptor)companionObjectDescriptor);
        if (kotlinType == null) {
            return;
        }
        KotlinType serializerForInCompanion = kotlinType;
        KtAnnotationEntry serializerAnnotationSource = KSerializationUtilKt.findAnnotationDeclaration((Annotated)companionObjectDescriptor, SerializationAnnotations.INSTANCE.getSerializerAnnotationFqName());
        KotlinType serializableWith = KSerializationUtilKt.getSerializableWith((DeclarationDescriptor)descriptor);
        if (KSerializationUtilKt.getHasSerializableOrMetaAnnotationWithoutArgs(descriptor)) {
            if (Intrinsics.areEqual((Object)serializerForInCompanion, (Object)descriptor.getDefaultType())) {
                ClassDescriptor $this$onSerializableOrMetaAnnotation$iv = descriptor;
                boolean $i$f$onSerializableOrMetaAnnotation = false;
                KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableOrMetaAnnotationDeclaration((Annotated)$this$onSerializableOrMetaAnnotation$iv);
                if (ktAnnotationEntry != null) {
                    KtAnnotationEntry it = ktAnnotationEntry;
                    boolean bl = false;
                    trace.report((Diagnostic)SerializationErrors.COMPANION_OBJECT_AS_CUSTOM_SERIALIZER_DEPRECATED.on((PsiElement)it, (Object)descriptor));
                }
            } else {
                KtAnnotationEntry ktAnnotationEntry = serializerAnnotationSource;
                trace.report((Diagnostic)SerializationErrors.COMPANION_OBJECT_SERIALIZER_INSIDE_OTHER_SERIALIZABLE_CLASS.on((PsiElement)(ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration), (Object)descriptor.getDefaultType(), (Object)serializerForInCompanion));
            }
        } else if (serializableWith != null) {
            if (!Intrinsics.areEqual((Object)serializableWith, (Object)companionObjectDescriptor.getDefaultType()) || !Intrinsics.areEqual((Object)serializerForInCompanion, (Object)descriptor.getDefaultType())) {
                KtAnnotationEntry ktAnnotationEntry = serializerAnnotationSource;
                trace.report((Diagnostic)SerializationErrors.COMPANION_OBJECT_SERIALIZER_INSIDE_OTHER_SERIALIZABLE_CLASS.on((PsiElement)(ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration), (Object)descriptor.getDefaultType(), (Object)serializerForInCompanion));
            }
        } else {
            KtAnnotationEntry ktAnnotationEntry = serializerAnnotationSource;
            trace.report((Diagnostic)SerializationErrors.COMPANION_OBJECT_SERIALIZER_INSIDE_NON_SERIALIZABLE_CLASS.on((PsiElement)(ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration), (Object)descriptor.getDefaultType(), (Object)serializerForInCompanion));
        }
    }

    public static final void checkCompanionOfSerializableClass(@NotNull ClassDescriptor descriptor, @NotNull BindingTrace trace) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            ClassDescriptor classDescriptor = descriptor.getCompanionObjectDescriptor();
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor companionObjectDescriptor = classDescriptor;
            if (!KSerializationUtilKt.getHasSerializableOrMetaAnnotation(descriptor)) {
                return;
            }
            if (!KSerializationUtilKt.getHasSerializableOrMetaAnnotation(companionObjectDescriptor)) {
                return;
            }
            KotlinType serializableArg = KSerializationUtilKt.getSerializableWith((DeclarationDescriptor)descriptor);
            KotlinType companionArg = KSerializationUtilKt.getSerializableWith((DeclarationDescriptor)companionObjectDescriptor);
            if (serializableArg != null && companionArg != null && Intrinsics.areEqual((Object)serializableArg, (Object)companionArg)) {
                return;
            }
            ClassDescriptor $this$onSerializableOrMetaAnnotation$iv = companionObjectDescriptor;
            boolean $i$f$onSerializableOrMetaAnnotation = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableOrMetaAnnotationDeclaration((Annotated)$this$onSerializableOrMetaAnnotation$iv);
            if (ktAnnotationEntry == null) break block4;
            KtAnnotationEntry it = ktAnnotationEntry;
            boolean bl = false;
            trace.report((Diagnostic)SerializationErrors.COMPANION_OBJECT_IS_SERIALIZABLE_INSIDE_SERIALIZABLE_CLASS.on((PsiElement)it, (Object)descriptor));
        }
    }
}

