@file:kotlin.jvm.JvmMultifileClass
@file:kotlin.jvm.JvmName("SetsKt")

package kotlin.collections

//
// NOTE THIS FILE IS AUTO-GENERATED by the GenerateStandardLib.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

import kotlin.comparisons.*

/**
 * Returns a set containing all elements of the original set except the given [element].
 * 
 * The returned set preserves the element iteration order of the original set.
 */
public header operator fun <T> Set<T>.minus(element: T): Set<T>

/**
 * Returns a set containing all elements of the original set except the elements contained in the given [elements] array.
 * 
 * The returned set preserves the element iteration order of the original set.
 */
public header operator fun <T> Set<T>.minus(elements: Array<out T>): Set<T>

/**
 * Returns a set containing all elements of the original set except the elements contained in the given [elements] collection.
 * 
 * The returned set preserves the element iteration order of the original set.
 */
public header operator fun <T> Set<T>.minus(elements: Iterable<T>): Set<T>

/**
 * Returns a set containing all elements of the original set except the elements contained in the given [elements] sequence.
 * 
 * The returned set preserves the element iteration order of the original set.
 */
public header operator fun <T> Set<T>.minus(elements: Sequence<T>): Set<T>

/**
 * Returns a set containing all elements of the original set except the given [element].
 * 
 * The returned set preserves the element iteration order of the original set.
 */
@kotlin.internal.InlineOnly
public header inline fun <T> Set<T>.minusElement(element: T): Set<T>

/**
 * Returns a set containing all elements of the original set and then the given [element] if it isn't already in this set.
 * 
 * The returned set preserves the element iteration order of the original set.
 */
public header operator fun <T> Set<T>.plus(element: T): Set<T>

/**
 * Returns a set containing all elements of the original set and the given [elements] array,
 * which aren't already in this set.
 * 
 * The returned set preserves the element iteration order of the original set.
 */
public header operator fun <T> Set<T>.plus(elements: Array<out T>): Set<T>

/**
 * Returns a set containing all elements of the original set and the given [elements] collection,
 * which aren't already in this set.
 * The returned set preserves the element iteration order of the original set.
 */
public header operator fun <T> Set<T>.plus(elements: Iterable<T>): Set<T>

/**
 * Returns a set containing all elements of the original set and the given [elements] sequence,
 * which aren't already in this set.
 * 
 * The returned set preserves the element iteration order of the original set.
 */
public header operator fun <T> Set<T>.plus(elements: Sequence<T>): Set<T>

/**
 * Returns a set containing all elements of the original set and then the given [element] if it isn't already in this set.
 * 
 * The returned set preserves the element iteration order of the original set.
 */
@kotlin.internal.InlineOnly
public header inline fun <T> Set<T>.plusElement(element: T): Set<T>

