/*
 * Decompiled with CFR 0.152.
 */
package kotlin.template;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import jet.JetObject;
import jet.Unit;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.template.TemplatePackage$src$Templates$43529fba;
import kotlin.template.ToStringFormatter;

@JetClass(signature="Lkotlin/template/ToStringFormatter;", abiVersion=6)
public class LocaleFormatter
extends ToStringFormatter
implements JetObject {
    private NumberFormat numberFormat;
    private DateFormat dateFormat;
    private final Locale locale;

    @Override
    @JetMethod(returnType="Ljava/lang/String;")
    public String toString() {
        return "LocaleFormatter{" + this.locale + "}";
    }

    @JetMethod(flags=1, propertyType="Ljava/text/NumberFormat;")
    public final NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    @JetMethod(flags=1, propertyType="Ljava/text/NumberFormat;")
    public final void setNumberFormat(@JetValueParameter(name="<set-?>", type="Ljava/text/NumberFormat;") NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    @JetMethod(flags=1, propertyType="Ljava/text/DateFormat;")
    public final DateFormat getDateFormat() {
        return this.dateFormat;
    }

    @JetMethod(flags=1, propertyType="Ljava/text/DateFormat;")
    public final void setDateFormat(@JetValueParameter(name="<set-?>", type="Ljava/text/DateFormat;") DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    @JetMethod(returnType="V")
    public void format(@JetValueParameter(name="out", type="Ljava/lang/Appendable;") Appendable out, @JetValueParameter(name="value", type="?Ljava/lang/Object;") Object value) {
        Unit unit;
        if (value instanceof Number) {
            this.format(out, this.format((Number)value));
        } else if (value instanceof Date) {
            this.format(out, this.format((Date)value));
            unit = Unit.VALUE;
        } else {
            super.format(out, value);
            unit = Unit.VALUE;
        }
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public final String format(@JetValueParameter(name="number", type="Ljava/lang/Number;") Number number) {
        String string = this.numberFormat.format(number);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public final String format(@JetValueParameter(name="date", type="Ljava/util/Date;") Date date) {
        String string = this.dateFormat.format(date);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @JetMethod(flags=17, propertyType="Ljava/util/Locale;")
    public final Locale getLocale() {
        return this.locale;
    }

    @JetConstructor
    public LocaleFormatter(@JetValueParameter(name="locale", hasDefaultValue=true, type="Ljava/util/Locale;") Locale locale) {
        this.locale = locale;
        NumberFormat numberFormat = NumberFormat.getInstance(this.locale);
        if (numberFormat == null) {
            Intrinsics.throwNpe();
        }
        this.numberFormat = numberFormat;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(DateFormat.DEFAULT, DateFormat.DEFAULT, this.locale);
        if (dateFormat == null) {
            Intrinsics.throwNpe();
        }
        this.dateFormat = dateFormat;
    }

    public /* synthetic */ LocaleFormatter(Locale locale, int n) {
        if ((n & 1) != 0) {
            locale = TemplatePackage$src$Templates$43529fba.getDefaultLocale();
        }
        this(locale);
    }

    public LocaleFormatter() {
        this(null, 1);
    }
}

