@file:kotlin.jvm.JvmMultifileClass
@file:kotlin.jvm.JvmName("MapsKt")

package kotlin

//
// NOTE THIS FILE IS AUTO-GENERATED by the GenerateStandardLib.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

import java.util.*

import java.util.Collections // TODO: it's temporary while we have java.util.Collections in js

/**
 * Returns a [List] containing all key-value pairs.
 */
public fun <K, V> Map<K, V>.toList(): List<Pair<K, V>> {
    val result = ArrayList<Pair<K, V>>(size())
    for (item in this)
        result.add(item.key to item.value)
    return result
}

/**
 * Returns a single list of all elements yielded from results of [transform] function being invoked on each element of original collection.
 */
public inline fun <K, V, R> Map<K, V>.flatMap(transform: (Map.Entry<K, V>) -> Iterable<R>): List<R> {
    return flatMapTo(ArrayList<R>(), transform)
}

/**
 * Appends all elements yielded from results of [transform] function being invoked on each element of original collection, to the given [destination].
 */
public inline fun <K, V, R, C : MutableCollection<in R>> Map<K, V>.flatMapTo(destination: C, transform: (Map.Entry<K, V>) -> Iterable<R>): C {
    for (element in this) {
        val list = transform(element)
        destination.addAll(list)
    }
    return destination
}

/**
 * Returns a list containing the results of applying the given [transform] function to each element of the original collection.
 */
public inline fun <K, V, R> Map<K, V>.map(transform: (Map.Entry<K, V>) -> R): List<R> {
    return mapTo(ArrayList<R>(size()), transform)
}

/**
 * Appends transformed elements and their indices of the original collection using the given [transform] function
 * to the given [destination].
 */
public inline fun <K, V, R, C : MutableCollection<in R>> Map<K, V>.mapIndexedTo(destination: C, transform: (Int, Map.Entry<K, V>) -> R): C {
    var index = 0
    for (item in this)
        destination.add(transform(index++, item))
    return destination
}

/**
 * Appends transformed elements of the original collection using the given [transform] function
 * to the given [destination].
 */
public inline fun <K, V, R, C : MutableCollection<in R>> Map<K, V>.mapTo(destination: C, transform: (Map.Entry<K, V>) -> R): C {
    for (item in this)
        destination.add(transform(item))
    return destination
}

/**
 * Returns `true` if all elements match the given [predicate].
 */
public inline fun <K, V> Map<K, V>.all(predicate: (Map.Entry<K, V>) -> Boolean): Boolean {
    for (element in this) if (!predicate(element)) return false
    return true
}

/**
 * Returns `true` if collection has at least one element.
 */
public fun <K, V> Map<K, V>.any(): Boolean {
    for (element in this) return true
    return false
}

/**
 * Returns `true` if at least one element matches the given [predicate].
 */
public inline fun <K, V> Map<K, V>.any(predicate: (Map.Entry<K, V>) -> Boolean): Boolean {
    for (element in this) if (predicate(element)) return true
    return false
}

/**
 * Returns the number of elements in this collection.
 */
public fun <K, V> Map<K, V>.count(): Int {
    return size()
}

/**
 * Returns the number of elements matching the given [predicate].
 */
public inline fun <K, V> Map<K, V>.count(predicate: (Map.Entry<K, V>) -> Boolean): Int {
    var count = 0
    for (element in this) if (predicate(element)) count++
    return count
}

/**
 * Performs the given [operation] on each element.
 */
public inline fun <K, V> Map<K, V>.forEach(operation: (Map.Entry<K, V>) -> Unit): Unit {
    for (element in this) operation(element)
}

/**
 * Returns the first element yielding the largest value of the given function or `null` if there are no elements.
 */
public inline fun <K, V, R : Comparable<R>> Map<K, V>.maxBy(f: (Map.Entry<K, V>) -> R): Map.Entry<K, V>? {
    val iterator = iterator()
    if (!iterator.hasNext()) return null
    var maxElem = iterator.next()
    var maxValue = f(maxElem)
    while (iterator.hasNext()) {
        val e = iterator.next()
        val v = f(e)
        if (maxValue < v) {
            maxElem = e
            maxValue = v
        }
    }
    return maxElem
}

/**
 * Returns the first element yielding the smallest value of the given function or `null` if there are no elements.
 */
public inline fun <K, V, R : Comparable<R>> Map<K, V>.minBy(f: (Map.Entry<K, V>) -> R): Map.Entry<K, V>? {
    val iterator = iterator()
    if (!iterator.hasNext()) return null
    var minElem = iterator.next()
    var minValue = f(minElem)
    while (iterator.hasNext()) {
        val e = iterator.next()
        val v = f(e)
        if (minValue > v) {
            minElem = e
            minValue = v
        }
    }
    return minElem
}

/**
 * Returns `true` if collection has no elements.
 */
public fun <K, V> Map<K, V>.none(): Boolean {
    for (element in this) return false
    return true
}

/**
 * Returns `true` if no elements match the given [predicate].
 */
public inline fun <K, V> Map<K, V>.none(predicate: (Map.Entry<K, V>) -> Boolean): Boolean {
    for (element in this) if (predicate(element)) return false
    return true
}

/**
 * Returns a sequence from the given collection.
 */
public fun <K, V> Map<K, V>.asSequence(): Sequence<Map.Entry<K, V>> {
    return object : Sequence<Map.Entry<K, V>> {
        override fun iterator(): Iterator<Map.Entry<K, V>> {
            return this@asSequence.iterator()
        }
    }
}

/**
 * Returns a sequence from the given collection
 */
@Deprecated("Use asSequence() instead", ReplaceWith("asSequence()"))
public fun <K, V> Map<K, V>.sequence(): Sequence<Map.Entry<K, V>> {
    return asSequence()
}

