/*
 * Decompiled with CFR 0.152.
 */
package kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jet.Function0;
import jet.Function1;
import jet.Function2;
import jet.KotlinPackageFragment;
import jet.Unit;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexIterator;
import kotlin.KotlinPackage$groupByTo$list$8;
import kotlin.KotlinPackage$sortBy$sortBy$8;
import kotlin.KotlinPackage-IterablesSpecial-2aa30a87;
import kotlin.KotlinPackage-Maps-d342c8;
import kotlin.KotlinPackage-OrderingJVM-625d3d22;
import kotlin.Pair;

@KotlinPackageFragment(abiVersion=11)
public final class KotlinPackage-_Iterables-4b9c149f {
    public static final <T> boolean all(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (((Boolean)predicate.invoke(element)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static final <T> boolean any(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (!((Boolean)predicate.invoke(element)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static final <T> int count(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        int count = 0;
        for (T element : $receiver) {
            Object object2;
            if (((Boolean)predicate.invoke(element)).booleanValue()) {
                object2 = count;
                ++count;
                continue;
            }
            object2 = Unit.VALUE;
        }
        return count;
    }

    public static final <T> T find(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (!((Boolean)predicate.invoke(element)).booleanValue()) continue;
            return element;
        }
        return null;
    }

    public static final <T, C extends Collection<? super T>> C filterTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            Object object2 = (Boolean)predicate.invoke(element) != false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    public static final <T, C extends Collection<? super T>> C filterNotTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            Object object2 = (Boolean)predicate.invoke(element) == false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    public static final <T, C extends Collection<? super T>> C filterNotNullTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") C result) {
        for (T element : $receiver) {
            boolean bl = true;
            if (element == null) {
                bl = false;
            }
            Object object2 = bl ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    public static final <T> Pair<List<? extends T>, List<? extends T>> partition(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        ArrayList<T> first = new ArrayList<T>();
        ArrayList<T> second = new ArrayList<T>();
        for (T element : $receiver) {
            boolean bl = (Boolean)predicate.invoke(element) != false ? first.add(element) : second.add(element);
        }
        return new Pair<List<? extends T>, List<? extends T>>(first, second);
    }

    public static final <T, R, C extends Collection<? super R>> C mapTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="transform") Function1<? super T, ? extends R> transform) {
        for (T item : $receiver) {
            result.add((Object)transform.invoke(item));
        }
        return result;
    }

    public static final <T, R, C extends Collection<? super R>> C flatMapTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="transform") Function1<? super T, ? extends Iterable<? extends R>> transform) {
        for (T element : $receiver) {
            Iterable list2 = (Iterable)transform.invoke(element);
            for (Object r : list2) {
                result.add(r);
            }
        }
        return result;
    }

    public static final <T> void forEach(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="operation") Function1<? super T, ? extends Unit> operation) {
        for (T element : $receiver) {
            operation.invoke(element);
        }
    }

    public static final <T, R> R fold(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="initial") R initial, @JetValueParameter(name="operation") Function2<? super R, ? super T, ? extends R> operation) {
        Object answer = initial;
        for (T element : $receiver) {
            answer = operation.invoke(answer, element);
        }
        return answer;
    }

    public static final <T> T reduce(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="operation") Function2<? super T, ? super T, ? extends T> operation) {
        Iterator<T> iterator2 = $receiver.iterator();
        if (!iterator2.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        Object result = iterator2.next();
        while (iterator2.hasNext()) {
            result = operation.invoke(result, iterator2.next());
        }
        return result;
    }

    public static final <T, K> Map<K, List<? extends T>> groupBy(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="toKey") Function1<? super T, ? extends K> toKey) {
        return KotlinPackage-_Iterables-4b9c149f.groupByTo($receiver, new HashMap(), toKey);
    }

    public static final <T, K> Map<K, List<T>> groupByTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") Map<K, List<T>> result, @JetValueParameter(name="toKey") Function1<? super T, ? extends K> toKey) {
        for (T element : $receiver) {
            Object key = toKey.invoke(element);
            List<T> list2 = KotlinPackage-Maps-d342c8.getOrPut(result, key, (Function0)KotlinPackage$groupByTo$list$8.instance$);
            list2.add(element);
        }
        return result;
    }

    public static final <T> List<T> drop(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="n") int n) {
        return KotlinPackage-_Iterables-4b9c149f.dropWhile($receiver, KotlinPackage-IterablesSpecial-2aa30a87.countTo(n));
    }

    public static final <T> List<T> dropWhile(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_Iterables-4b9c149f.dropWhileTo($receiver, (List)new ArrayList(), predicate);
    }

    public static final <T, L extends List<? super T>> L dropWhileTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") L result, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        int start = 1;
        for (T element : $receiver) {
            Object object2;
            if (!(start != 0 ? (Boolean)predicate.invoke(element) : false)) {
                start = 0;
                object2 = result.add(element);
                continue;
            }
            object2 = Unit.VALUE;
        }
        return result;
    }

    public static final <T, C extends Collection<? super T>> C takeWhileTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (!((Boolean)predicate.invoke(element)).booleanValue()) break;
            result.add(element);
        }
        return result;
    }

    public static final <T, C extends Collection<? super T>> C toCollection(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") C result) {
        for (T element : $receiver) {
            result.add(element);
        }
        return result;
    }

    public static final <T> List<T> reverse(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        ArrayList list2 = (ArrayList)KotlinPackage-_Iterables-4b9c149f.toCollection($receiver, (Collection)new ArrayList());
        Collections.reverse(list2);
        return list2;
    }

    public static final <T> LinkedList<T> toLinkedList(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return (LinkedList)KotlinPackage-_Iterables-4b9c149f.toCollection($receiver, (Collection)new LinkedList());
    }

    public static final <T> List<T> toList(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return (ArrayList)KotlinPackage-_Iterables-4b9c149f.toCollection($receiver, (Collection)new ArrayList());
    }

    public static final <T> Set<T> toSet(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return (LinkedHashSet)KotlinPackage-_Iterables-4b9c149f.toCollection($receiver, (Collection)new LinkedHashSet());
    }

    public static final <T> SortedSet<T> toSortedSet(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return (TreeSet)KotlinPackage-_Iterables-4b9c149f.toCollection($receiver, (Collection)new TreeSet());
    }

    public static final <T> Iterator<Pair<? extends Integer, ? extends T>> withIndices(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return new IndexIterator<T>($receiver.iterator());
    }

    public static final <T, R extends Comparable<? super R>> List<T> sortBy(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="f") Function1<? super T, ? extends R> f) {
        ArrayList sortedList = (ArrayList)KotlinPackage-_Iterables-4b9c149f.toCollection($receiver, (Collection)new ArrayList());
        Comparator sortBy2 = KotlinPackage-OrderingJVM-625d3d22.comparator((Function2)new KotlinPackage$sortBy$sortBy$8(f));
        Collections.sort(sortedList, sortBy2);
        return sortedList;
    }

    public static final <T> void appendString(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="buffer") Appendable buffer, @JetValueParameter(name="separator") String separator, @JetValueParameter(name="prefix") String prefix, @JetValueParameter(name="postfix") String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") String truncated) {
        buffer.append(prefix);
        int count = 0;
        for (T element : $receiver) {
            if (++count > 1) {
                buffer.append(separator);
            }
            boolean bl = !(limit < 0) ? count <= limit : true;
            if (!bl) break;
            boolean bl2 = true;
            if (element != null) {
                bl2 = false;
            }
            String text = bl2 ? "null" : String.valueOf(element);
            buffer.append(text);
        }
        boolean bl = limit >= 0 ? count > limit : false;
        if (bl) {
            buffer.append(truncated);
        }
        buffer.append(postfix);
    }

    public static /* synthetic */ void appendString$default(Iterable iterable, Appendable appendable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 2) != 0) {
            string = ", ";
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            string4 = "...";
        }
        KotlinPackage-_Iterables-4b9c149f.appendString(iterable, appendable, string, string2, string3, n, string4);
    }

    public static final <T> String makeString(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="separator") String separator, @JetValueParameter(name="prefix") String prefix, @JetValueParameter(name="postfix") String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") String truncated) {
        StringBuilder buffer = new StringBuilder();
        KotlinPackage-_Iterables-4b9c149f.appendString($receiver, buffer, separator, prefix, postfix, limit, truncated);
        return buffer.toString();
    }

    public static /* synthetic */ String makeString$default(Iterable iterable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 1) != 0) {
            string = ", ";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "...";
        }
        return KotlinPackage-_Iterables-4b9c149f.makeString(iterable, string, string2, string3, n, string4);
    }
}

