package kotlin

/**
 * Defines names for Unicode symbols used in proper Typography.
 */
public object Typography {
    /** The character &#x22; */
    public val quote: Char = '\u0022'
    /** The character &#x26; */
    public val amp: Char = '\u0026'
    /** The character &#x3C; */
    public val less: Char = '\u003C'
    /** The character &#x3E; */
    public val greater: Char = '\u003E'
    /** The non-breaking space character */
    public val nbsp: Char = '\u00A0'
    /** The character &#xD7; */
    public val times: Char = '\u00D7'
    /** The character &#xA2; */
    public val cent: Char = '\u00A2'
    /** The character &#xA3; */
    public val pound: Char = '\u00A3'
    /** The character &#xA7; */
    public val section: Char = '\u00A7'
    /** The character &#xA9; */
    public val copyright: Char = '\u00A9'
    /** The character &#xAB; */
    public val leftGuillemete: Char = '\u00AB'
    /** The character &#xBB; */
    public val rightGuillemete: Char = '\u00BB'
    /** The character &#xAE; */
    public val registered: Char = '\u00AE'
    /** The character &#xB0; */
    public val degree: Char = '\u00B0'
    /** The character &#xB1; */
    public val plusMinus: Char = '\u00B1'
    /** The character &#xB6; */
    public val paragraph: Char = '\u00B6'
    /** The character &#xB7; */
    public val middleDot: Char = '\u00B7'
    /** The character &#xBD; */
    public val half: Char = '\u00BD'
    /** The character &#x2013; */
    public val ndash: Char = '\u2013'
    /** The character &#x2014; */
    public val mdash: Char = '\u2014'
    /** The character &#x2018; */
    public val leftSingleQuote: Char = '\u2018'
    /** The character &#x2019; */
    public val rightSingleQuote: Char = '\u2019'
    /** The character &#x201A; */
    public val lowSingleQuote: Char = '\u201A'
    /** The character &#x201C; */
    public val leftDoubleQuote: Char = '\u201C'
    /** The character &#x201D; */
    public val rightDoubleQuote: Char = '\u201D'
    /** The character &#x201E; */
    public val lowDoubleQuote: Char = '\u201E'
    /** The character &#x2020; */
    public val dagger: Char = '\u2020'
    /** The character &#x2021; */
    public val doubleDagger: Char = '\u2021'
    /** The character &#x2022; */
    public val bullet: Char = '\u2022'
    /** The character &#x2026; */
    public val ellipsis: Char = '\u2026'
    /** The character &#x2032; */
    public val prime: Char = '\u2032'
    /** The character &#x2033; */
    public val doublePrime: Char = '\u2033'
    /** The character &#x20AC; */
    public val euro: Char = '\u20AC'
    /** The character &#x2122; */
    public val tm: Char = '\u2122'
    /** The character &#x2248; */
    public val almostEqual: Char = '\u2248'
    /** The character &#x2260; */
    public val notEqual: Char = '\u2260'
    /** The character &#x2264; */
    public val lessOrEqual: Char = '\u2264'
    /** The character &#x2265; */
    public val greaterOrEqual: Char = '\u2265'
}