/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tooling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tooling.KotlinToolingMetadata;
import org.jetbrains.kotlin.tooling.KotlinToolingMetadataParsingResult;
import org.jetbrains.kotlin.tooling.SchemaVersion;
import org.jetbrains.kotlin.tooling.SchemaVersionKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0004\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0002H\u0002\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0002H\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0002*\u00020\nH\u0000\u001a\f\u0010\u0014\u001a\u00020\u0002*\u00020\u0015H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0002*\u00020\u0013H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0002*\u00020\rH\u0002\u001a\f\u0010\u0014\u001a\u00020\u0002*\u00020\u0016H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0002*\u00020\u000fH\u0002\u001a\f\u0010\u0014\u001a\u00020\u0002*\u00020\u0017H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0002*\u00020\u0018H\u0002\u001a\n\u0010\u0019\u001a\u00020\u0004*\u00020\n\u001a\f\u0010\u001a\u001a\u00020\u0017*\u00020\u0002H\u0002\u001a\f\u0010\u001b\u001a\u00020\n*\u00020\u0002H\u0002\u001a\f\u0010\u001c\u001a\u00020\u0018*\u00020\u0002H\u0002\u001a\f\u0010\u001d\u001a\u00020\u0015*\u00020\u0002H\u0002\u001a\f\u0010\u001e\u001a\u00020\u0016*\u00020\u0002H\u0002\u001a\f\u0010\u001f\u001a\u00020\u0013*\u00020\u0002H\u0002\u00a8\u0006 "}, d2={"getOrThrow", "Lcom/google/gson/JsonElement;", "Lcom/google/gson/JsonObject;", "key", "", "parseJson", "Lorg/jetbrains/kotlin/tooling/KotlinToolingMetadataParsingResult;", "Lorg/jetbrains/kotlin/tooling/KotlinToolingMetadata$Companion;", "json", "parseJsonOrThrow", "Lorg/jetbrains/kotlin/tooling/KotlinToolingMetadata;", "value", "toAndroidExtrasOrThrow", "Lorg/jetbrains/kotlin/tooling/KotlinToolingMetadata$ProjectTargetMetadata$AndroidExtras;", "toJsExtrasOrThrow", "Lorg/jetbrains/kotlin/tooling/KotlinToolingMetadata$ProjectTargetMetadata$JsExtras;", "toJsonArray", "Lcom/google/gson/JsonArray;", "", "Lorg/jetbrains/kotlin/tooling/KotlinToolingMetadata$ProjectTargetMetadata;", "toJsonObject", "Lorg/jetbrains/kotlin/tooling/KotlinToolingMetadata$ProjectSettings;", "Lorg/jetbrains/kotlin/tooling/KotlinToolingMetadata$ProjectTargetMetadata$Extras;", "Lorg/jetbrains/kotlin/tooling/KotlinToolingMetadata$ProjectTargetMetadata$JvmExtras;", "Lorg/jetbrains/kotlin/tooling/KotlinToolingMetadata$ProjectTargetMetadata$NativeExtras;", "toJsonString", "toJvmExtrasOrThrow", "toKotlinToolingMetadataOrThrow", "toNativeExtrasOrThrow", "toProjectSettingsOrThrow", "toTargetMetadataExtrasOrThrow", "toTargetMetadataOrThrow", "kotlin-tooling-metadata"})
public final class JsonConversionKt {
    @NotNull
    public static final String toJsonString(@NotNull KotlinToolingMetadata $this$toJsonString) {
        Intrinsics.checkNotNullParameter((Object)$this$toJsonString, (String)"<this>");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String string = gson.toJson((JsonElement)JsonConversionKt.toJsonObject($this$toJsonString));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(toJsonObject())");
        return string;
    }

    @NotNull
    public static final JsonObject toJsonObject(@NotNull KotlinToolingMetadata $this$toJsonObject) {
        Intrinsics.checkNotNullParameter((Object)$this$toJsonObject, (String)"<this>");
        JsonObject jsonObject = new JsonObject();
        boolean bl = false;
        boolean bl2 = false;
        JsonObject $this$toJsonObject_u24lambda_u2d0 = jsonObject;
        boolean bl3 = false;
        $this$toJsonObject_u24lambda_u2d0.addProperty("schemaVersion", $this$toJsonObject.getSchemaVersion());
        $this$toJsonObject_u24lambda_u2d0.addProperty("buildSystem", $this$toJsonObject.getBuildSystem());
        $this$toJsonObject_u24lambda_u2d0.addProperty("buildSystemVersion", $this$toJsonObject.getBuildSystemVersion());
        $this$toJsonObject_u24lambda_u2d0.addProperty("buildPlugin", $this$toJsonObject.getBuildPlugin());
        $this$toJsonObject_u24lambda_u2d0.addProperty("buildPluginVersion", $this$toJsonObject.getBuildPluginVersion());
        $this$toJsonObject_u24lambda_u2d0.add("projectSettings", (JsonElement)JsonConversionKt.toJsonObject($this$toJsonObject.getProjectSettings()));
        $this$toJsonObject_u24lambda_u2d0.add("projectTargets", (JsonElement)JsonConversionKt.toJsonArray($this$toJsonObject.getProjectTargets()));
        return jsonObject;
    }

    private static final JsonObject toJsonObject(KotlinToolingMetadata.ProjectSettings $this$toJsonObject) {
        JsonObject jsonObject = new JsonObject();
        boolean bl = false;
        boolean bl2 = false;
        JsonObject $this$toJsonObject_u24lambda_u2d1 = jsonObject;
        boolean bl3 = false;
        $this$toJsonObject_u24lambda_u2d1.addProperty("isHmppEnabled", Boolean.valueOf($this$toJsonObject.isHmppEnabled()));
        $this$toJsonObject_u24lambda_u2d1.addProperty("isCompatibilityMetadataVariantEnabled", Boolean.valueOf($this$toJsonObject.isCompatibilityMetadataVariantEnabled()));
        return jsonObject;
    }

    private static final JsonArray toJsonArray(List<KotlinToolingMetadata.ProjectTargetMetadata> $this$toJsonArray) {
        JsonArray jsonArray = new JsonArray();
        boolean bl = false;
        boolean bl2 = false;
        JsonArray $this$toJsonArray_u24lambda_u2d3 = jsonArray;
        boolean bl3 = false;
        Iterable $this$forEach$iv = $this$toJsonArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinToolingMetadata.ProjectTargetMetadata targetMetadata = (KotlinToolingMetadata.ProjectTargetMetadata)element$iv;
            boolean bl4 = false;
            $this$toJsonArray_u24lambda_u2d3.add((JsonElement)JsonConversionKt.toJsonObject(targetMetadata));
        }
        return jsonArray;
    }

    private static final JsonObject toJsonObject(KotlinToolingMetadata.ProjectTargetMetadata $this$toJsonObject) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = new JsonObject();
        boolean bl = false;
        boolean bl2 = false;
        JsonObject $this$toJsonObject_u24lambda_u2d6 = jsonObject2;
        boolean bl3 = false;
        $this$toJsonObject_u24lambda_u2d6.addProperty("target", $this$toJsonObject.getTarget());
        $this$toJsonObject_u24lambda_u2d6.addProperty("platformType", $this$toJsonObject.getPlatformType());
        JsonObject jsonObject3 = JsonConversionKt.toJsonObject($this$toJsonObject.getExtras());
        boolean bl4 = false;
        boolean bl5 = false;
        JsonObject it = jsonObject3;
        boolean bl6 = false;
        Object object = jsonObject = it.size() > 0 ? jsonObject3 : null;
        if (jsonObject != null) {
            jsonObject3 = jsonObject;
            bl4 = false;
            bl5 = false;
            JsonObject extrasJsonObject = jsonObject3;
            boolean bl7 = false;
            $this$toJsonObject_u24lambda_u2d6.add("extras", (JsonElement)extrasJsonObject);
        }
        return jsonObject2;
    }

    private static final JsonObject toJsonObject(KotlinToolingMetadata.ProjectTargetMetadata.Extras $this$toJsonObject) {
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        JsonObject jsonObject = new JsonObject();
        boolean bl3 = false;
        boolean bl4 = false;
        JsonObject $this$toJsonObject_u24lambda_u2d11 = jsonObject;
        boolean bl5 = false;
        Object object2 = $this$toJsonObject.getJvm();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl6 = false;
            $this$toJsonObject_u24lambda_u2d11.add("jvm", (JsonElement)JsonConversionKt.toJsonObject((KotlinToolingMetadata.ProjectTargetMetadata.JvmExtras)it));
        }
        object2 = $this$toJsonObject.getAndroid();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl7 = false;
            $this$toJsonObject_u24lambda_u2d11.add("android", (JsonElement)JsonConversionKt.toJsonObject((KotlinToolingMetadata.ProjectTargetMetadata.AndroidExtras)it));
        }
        object2 = $this$toJsonObject.getJs();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl8 = false;
            $this$toJsonObject_u24lambda_u2d11.add("js", (JsonElement)JsonConversionKt.toJsonObject((KotlinToolingMetadata.ProjectTargetMetadata.JsExtras)it));
        }
        object2 = $this$toJsonObject.getNative();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl9 = false;
            $this$toJsonObject_u24lambda_u2d11.add("native", (JsonElement)JsonConversionKt.toJsonObject((KotlinToolingMetadata.ProjectTargetMetadata.NativeExtras)it));
        }
        return jsonObject;
    }

    private static final JsonObject toJsonObject(KotlinToolingMetadata.ProjectTargetMetadata.JvmExtras $this$toJsonObject) {
        JsonObject jsonObject = new JsonObject();
        boolean bl = false;
        boolean bl2 = false;
        JsonObject $this$toJsonObject_u24lambda_u2d13 = jsonObject;
        boolean bl3 = false;
        String string = $this$toJsonObject.getJvmTarget();
        if (string != null) {
            String string2 = string;
            boolean bl4 = false;
            boolean bl5 = false;
            String it = string2;
            boolean bl6 = false;
            $this$toJsonObject_u24lambda_u2d13.addProperty("jvmTarget", it);
        }
        $this$toJsonObject_u24lambda_u2d13.addProperty("withJavaEnabled", Boolean.valueOf($this$toJsonObject.getWithJavaEnabled()));
        return jsonObject;
    }

    private static final JsonObject toJsonObject(KotlinToolingMetadata.ProjectTargetMetadata.JsExtras $this$toJsonObject) {
        JsonObject jsonObject = new JsonObject();
        boolean bl = false;
        boolean bl2 = false;
        JsonObject $this$toJsonObject_u24lambda_u2d14 = jsonObject;
        boolean bl3 = false;
        $this$toJsonObject_u24lambda_u2d14.addProperty("isBrowserConfigured", Boolean.valueOf($this$toJsonObject.isBrowserConfigured()));
        $this$toJsonObject_u24lambda_u2d14.addProperty("isNodejsConfigured", Boolean.valueOf($this$toJsonObject.isNodejsConfigured()));
        return jsonObject;
    }

    private static final JsonObject toJsonObject(KotlinToolingMetadata.ProjectTargetMetadata.NativeExtras $this$toJsonObject) {
        JsonObject jsonObject = new JsonObject();
        boolean bl = false;
        boolean bl2 = false;
        JsonObject $this$toJsonObject_u24lambda_u2d15 = jsonObject;
        boolean bl3 = false;
        $this$toJsonObject_u24lambda_u2d15.addProperty("konanTarget", $this$toJsonObject.getKonanTarget());
        $this$toJsonObject_u24lambda_u2d15.addProperty("konanVersion", $this$toJsonObject.getKonanVersion());
        $this$toJsonObject_u24lambda_u2d15.addProperty("konanAbiVersion", $this$toJsonObject.getKonanAbiVersion());
        return jsonObject;
    }

    private static final JsonObject toJsonObject(KotlinToolingMetadata.ProjectTargetMetadata.AndroidExtras $this$toJsonObject) {
        JsonObject jsonObject = new JsonObject();
        boolean bl = false;
        boolean bl2 = false;
        JsonObject $this$toJsonObject_u24lambda_u2d16 = jsonObject;
        boolean bl3 = false;
        $this$toJsonObject_u24lambda_u2d16.addProperty("sourceCompatibility", $this$toJsonObject.getSourceCompatibility());
        $this$toJsonObject_u24lambda_u2d16.addProperty("targetCompatibility", $this$toJsonObject.getTargetCompatibility());
        return jsonObject;
    }

    @NotNull
    public static final KotlinToolingMetadataParsingResult parseJson(@NotNull KotlinToolingMetadata.Companion $this$parseJson, @NotNull String json) {
        KotlinToolingMetadataParsingResult kotlinToolingMetadataParsingResult;
        Object it;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)$this$parseJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            object2 = JsonParser.parseString((String)json);
        }
        catch (JsonParseException e) {
            return new KotlinToolingMetadataParsingResult.Failure(Intrinsics.stringPlus((String)"Invalid json: ", (Object)e.getMessage()));
        }
        JsonElement jsonElement = object2;
        if (!(jsonElement instanceof JsonObject)) {
            return new KotlinToolingMetadataParsingResult.Failure(Intrinsics.stringPlus((String)"Expected JsonObject. Found ", (Object)json.getClass().getCanonicalName()));
        }
        object2 = $this$parseJson;
        boolean bl = false;
        try {
            object = Result.Companion;
            Object $this$parseJson_u24lambda_u2d17 = object2;
            boolean bl2 = false;
            $this$parseJson_u24lambda_u2d17 = JsonConversionKt.toKotlinToolingMetadataOrThrow((JsonObject)jsonElement);
            bl2 = false;
            object = Result.constructor-impl((Object)$this$parseJson_u24lambda_u2d17);
        }
        catch (Throwable $this$parseJson_u24lambda_u2d17) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$parseJson_u24lambda_u2d17));
        }
        object2 = object;
        bl = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            it = (KotlinToolingMetadata)object2;
            boolean bl5 = false;
            kotlinToolingMetadataParsingResult = new KotlinToolingMetadataParsingResult.Success((KotlinToolingMetadata)it);
        } else {
            it = throwable;
            boolean bl6 = false;
            kotlinToolingMetadataParsingResult = new KotlinToolingMetadataParsingResult.Failure(Intrinsics.stringPlus((String)"Failed parsing JsonObject: ", (Object)((Throwable)it).getMessage()));
        }
        return kotlinToolingMetadataParsingResult;
    }

    @NotNull
    public static final KotlinToolingMetadata parseJsonOrThrow(@NotNull KotlinToolingMetadata.Companion $this$parseJsonOrThrow, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$parseJsonOrThrow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        KotlinToolingMetadataParsingResult result = JsonConversionKt.parseJson($this$parseJsonOrThrow, value);
        if (!(result instanceof KotlinToolingMetadataParsingResult.Success)) {
            if (result instanceof KotlinToolingMetadataParsingResult.Failure) {
                throw new IllegalArgumentException(((KotlinToolingMetadataParsingResult.Failure)result).getReason());
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((KotlinToolingMetadataParsingResult.Success)result).getValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinToolingMetadata toKotlinToolingMetadataOrThrow(JsonObject $this$toKotlinToolingMetadataOrThrow) {
        Collection<KotlinToolingMetadata.ProjectTargetMetadata> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = JsonConversionKt.getOrThrow($this$toKotlinToolingMetadataOrThrow, "schemaVersion").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrThrow(\"schemaVersion\").asString");
        SchemaVersion schemaVersion = SchemaVersionKt.parseStringOrThrow(SchemaVersion.Companion, (String)object);
        if (!SchemaVersionKt.isCompatible(SchemaVersion.Companion.getCurrent(), schemaVersion)) {
            throw new IllegalArgumentException("Incompatible schemaVersion='" + schemaVersion + "' found. Current schemaVersion='" + SchemaVersion.Companion.getCurrent() + '\'');
        }
        String string = schemaVersion.toString();
        object = JsonConversionKt.getOrThrow($this$toKotlinToolingMetadataOrThrow, "buildSystem").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrThrow(\"buildSystem\").asString");
        String string2 = object;
        object = JsonConversionKt.getOrThrow($this$toKotlinToolingMetadataOrThrow, "buildSystemVersion").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrThrow(\"buildSystemVersion\").asString");
        String string3 = object;
        object = JsonConversionKt.getOrThrow($this$toKotlinToolingMetadataOrThrow, "buildPlugin").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrThrow(\"buildPlugin\").asString");
        String string4 = object;
        object = JsonConversionKt.getOrThrow($this$toKotlinToolingMetadataOrThrow, "buildPluginVersion").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrThrow(\"buildPluginVersion\").asString");
        String string5 = object;
        object = JsonConversionKt.getOrThrow($this$toKotlinToolingMetadataOrThrow, "projectSettings").getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrThrow(\"projectSettings\").asJsonObject");
        KotlinToolingMetadata.ProjectSettings projectSettings = JsonConversionKt.toProjectSettingsOrThrow((JsonObject)object);
        object = JsonConversionKt.getOrThrow($this$toKotlinToolingMetadataOrThrow, "projectTargets").getAsJsonArray();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrThrow(\"projectTargets\").asJsonArray");
        object = (Iterable)object;
        KotlinToolingMetadata.ProjectSettings projectSettings2 = projectSettings;
        String string6 = string5;
        String string7 = string4;
        String string8 = string3;
        String string9 = string2;
        String string10 = string;
        boolean $i$f$map = false;
        void var4_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsonObject jsonObject = it.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"it.asJsonObject");
            KotlinToolingMetadata.ProjectTargetMetadata projectTargetMetadata = JsonConversionKt.toTargetMetadataOrThrow(jsonObject);
            collection.add(projectTargetMetadata);
        }
        Collection<KotlinToolingMetadata.ProjectTargetMetadata> collection2 = collection = (List)destination$iv$iv;
        KotlinToolingMetadata.ProjectSettings projectSettings3 = projectSettings2;
        String string11 = string6;
        String string12 = string7;
        String string13 = string8;
        String string14 = string9;
        String string15 = string10;
        return new KotlinToolingMetadata(string15, string14, string13, string12, string11, projectSettings3, (List<KotlinToolingMetadata.ProjectTargetMetadata>)collection2);
    }

    private static final KotlinToolingMetadata.ProjectSettings toProjectSettingsOrThrow(JsonObject $this$toProjectSettingsOrThrow) {
        return new KotlinToolingMetadata.ProjectSettings(JsonConversionKt.getOrThrow($this$toProjectSettingsOrThrow, "isHmppEnabled").getAsBoolean(), JsonConversionKt.getOrThrow($this$toProjectSettingsOrThrow, "isCompatibilityMetadataVariantEnabled").getAsBoolean());
    }

    private static final KotlinToolingMetadata.ProjectTargetMetadata toTargetMetadataOrThrow(JsonObject $this$toTargetMetadataOrThrow) {
        String string = JsonConversionKt.getOrThrow($this$toTargetMetadataOrThrow, "target").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOrThrow(\"target\").asString");
        String string2 = string;
        string = JsonConversionKt.getOrThrow($this$toTargetMetadataOrThrow, "platformType").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOrThrow(\"platformType\").asString");
        String string3 = string;
        JsonElement jsonElement = $this$toTargetMetadataOrThrow.get("extras");
        string = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
        return new KotlinToolingMetadata.ProjectTargetMetadata(string2, string3, string == null ? new KotlinToolingMetadata.ProjectTargetMetadata.Extras(null, null, null, null, 15, null) : JsonConversionKt.toTargetMetadataExtrasOrThrow((JsonObject)string));
    }

    private static final KotlinToolingMetadata.ProjectTargetMetadata.Extras toTargetMetadataExtrasOrThrow(JsonObject $this$toTargetMetadataExtrasOrThrow) {
        JsonObject jsonObject;
        JsonElement jsonElement = $this$toTargetMetadataExtrasOrThrow.get("jvm");
        KotlinToolingMetadata.ProjectTargetMetadata.JvmExtras jvmExtras = jsonElement == null ? null : ((jsonObject = jsonElement.getAsJsonObject()) == null ? null : JsonConversionKt.toJvmExtrasOrThrow(jsonObject));
        jsonElement = $this$toTargetMetadataExtrasOrThrow.get("android");
        KotlinToolingMetadata.ProjectTargetMetadata.AndroidExtras androidExtras = jsonElement == null ? null : ((jsonObject = jsonElement.getAsJsonObject()) == null ? null : JsonConversionKt.toAndroidExtrasOrThrow(jsonObject));
        jsonElement = $this$toTargetMetadataExtrasOrThrow.get("js");
        KotlinToolingMetadata.ProjectTargetMetadata.JsExtras jsExtras = jsonElement == null ? null : ((jsonObject = jsonElement.getAsJsonObject()) == null ? null : JsonConversionKt.toJsExtrasOrThrow(jsonObject));
        jsonElement = $this$toTargetMetadataExtrasOrThrow.get("native");
        return new KotlinToolingMetadata.ProjectTargetMetadata.Extras(jvmExtras, androidExtras, jsExtras, jsonElement == null ? null : ((jsonObject = jsonElement.getAsJsonObject()) == null ? null : JsonConversionKt.toNativeExtrasOrThrow(jsonObject)));
    }

    private static final KotlinToolingMetadata.ProjectTargetMetadata.JvmExtras toJvmExtrasOrThrow(JsonObject $this$toJvmExtrasOrThrow) {
        JsonElement jsonElement = $this$toJvmExtrasOrThrow.get("jvmTarget");
        return new KotlinToolingMetadata.ProjectTargetMetadata.JvmExtras(jsonElement == null ? null : jsonElement.getAsString(), JsonConversionKt.getOrThrow($this$toJvmExtrasOrThrow, "withJavaEnabled").getAsBoolean());
    }

    private static final KotlinToolingMetadata.ProjectTargetMetadata.JsExtras toJsExtrasOrThrow(JsonObject $this$toJsExtrasOrThrow) {
        return new KotlinToolingMetadata.ProjectTargetMetadata.JsExtras(JsonConversionKt.getOrThrow($this$toJsExtrasOrThrow, "isBrowserConfigured").getAsBoolean(), JsonConversionKt.getOrThrow($this$toJsExtrasOrThrow, "isNodejsConfigured").getAsBoolean());
    }

    private static final KotlinToolingMetadata.ProjectTargetMetadata.NativeExtras toNativeExtrasOrThrow(JsonObject $this$toNativeExtrasOrThrow) {
        String string = JsonConversionKt.getOrThrow($this$toNativeExtrasOrThrow, "konanTarget").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOrThrow(\"konanTarget\").asString");
        String string2 = string;
        string = JsonConversionKt.getOrThrow($this$toNativeExtrasOrThrow, "konanVersion").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOrThrow(\"konanVersion\").asString");
        String string3 = string;
        string = JsonConversionKt.getOrThrow($this$toNativeExtrasOrThrow, "konanAbiVersion").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOrThrow(\"konanAbiVersion\").asString");
        return new KotlinToolingMetadata.ProjectTargetMetadata.NativeExtras(string2, string3, string);
    }

    private static final KotlinToolingMetadata.ProjectTargetMetadata.AndroidExtras toAndroidExtrasOrThrow(JsonObject $this$toAndroidExtrasOrThrow) {
        String string = JsonConversionKt.getOrThrow($this$toAndroidExtrasOrThrow, "sourceCompatibility").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOrThrow(\"sourceCompatibility\").asString");
        String string2 = string;
        string = JsonConversionKt.getOrThrow($this$toAndroidExtrasOrThrow, "targetCompatibility").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOrThrow(\"targetCompatibility\").asString");
        return new KotlinToolingMetadata.ProjectTargetMetadata.AndroidExtras(string2, string);
    }

    private static final JsonElement getOrThrow(JsonObject $this$getOrThrow, String key) {
        JsonElement jsonElement = $this$getOrThrow.get(key);
        if (jsonElement == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Missing key: ", (Object)key));
        }
        return jsonElement;
    }
}

