/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.KotlinLibrarySearchPathResolver;
import org.jetbrains.kotlin.library.LenientUnresolvedLibrary;
import org.jetbrains.kotlin.library.RequiredUnresolvedLibrary;
import org.jetbrains.kotlin.library.SearchPathResolver;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.library.UnresolvedLibraryKt;
import org.jetbrains.kotlin.library.impl.KotlinLibraryImplKt;
import org.jetbrains.kotlin.util.Logger;
import org.jetbrains.kotlin.util.UtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\"\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001YBE\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ&\u0010:\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\u000bH\u0016J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00100?2\u0006\u0010@\u001a\u00020\u0006H\u0002J\u0012\u0010A\u001a\u0004\u0018\u00010\u00102\u0006\u0010B\u001a\u00020\u0010H\u0002J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000?2\u0006\u0010D\u001a\u00020\u0010H\u0002J\u001e\u0010E\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010F\u001a\u00020\u00102\u0006\u0010G\u001a\u00020\u000bH&J\u001d\u0010H\u001a\u00020\u000b2\u0006\u0010B\u001a\u00028\u00002\u0006\u0010I\u001a\u00020/H\u0016\u00a2\u0006\u0002\u0010JJ\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00100?2\u0006\u0010L\u001a\u00020\u0006H\u0016J\u0015\u0010M\u001a\u00028\u00002\u0006\u0010L\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010NJ\u001f\u0010M\u001a\u0004\u0018\u00018\u00002\u0006\u0010I\u001a\u00020O2\u0006\u0010P\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010QJ\u001d\u0010M\u001a\u00028\u00002\u0006\u0010I\u001a\u00020R2\u0006\u0010P\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010SJ\u001f\u0010T\u001a\u0004\u0018\u00018\u00002\u0006\u0010I\u001a\u00020/2\u0006\u0010P\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010UJ\u0012\u0010V\u001a\u0004\u0018\u00010\u00102\u0006\u0010W\u001a\u00020\u0006H\u0002J\u0018\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00100?*\b\u0012\u0004\u0012\u00020\u00100?H\u0002R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0017\u0010\u0015R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0012R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR!\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0019\u001a\u0004\b\"\u0010#R\u0013\u0010%\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001fR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R!\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u0019\u001a\u0004\b+\u0010\u0015R>\u0010-\u001a2\u0012\u0004\u0012\u00020/\u0012\u000e\u0012\f00R\b\u0012\u0004\u0012\u00028\u00000\u00000.j\u0018\u0012\u0004\u0012\u00020/\u0012\u000e\u0012\f00R\b\u0012\u0004\u0012\u00028\u00000\u0000`1X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u00102\u001a\b\u0012\u0004\u0012\u00020\u00100\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u0019\u001a\u0004\b3\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0018\u00107\u001a\u00020\u0010*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u00a8\u0006Z"}, d2={"Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver;", "L", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/SearchPathResolver;", "repositories", "", "", "directLibs", "distributionKlib", "localKotlinDir", "skipCurrentDir", "", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "(Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;ZLorg/jetbrains/kotlin/util/Logger;)V", "currentDirHead", "Lorg/jetbrains/kotlin/konan/file/File;", "getCurrentDirHead", "()Lorg/jetbrains/kotlin/konan/file/File;", "defaultRoots", "getDefaultRoots", "()Ljava/util/List;", "directLibraries", "getDirectLibraries", "directLibraries$delegate", "Lkotlin/Lazy;", "distHead", "getDistHead", "distPlatformHead", "getDistPlatformHead", "getDistributionKlib", "()Ljava/lang/String;", "files", "", "getFiles", "()Ljava/util/Set;", "files$delegate", "localHead", "getLocalHead", "getLocalKotlinDir", "getLogger", "()Lorg/jetbrains/kotlin/util/Logger;", "repoRoots", "getRepoRoots", "repoRoots$delegate", "resolvedLibraries", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver$ResolvedLibrary;", "Lkotlin/collections/HashMap;", "searchRoots", "getSearchRoots", "searchRoots$delegate", "getSkipCurrentDir", "()Z", "klib", "getKlib", "(Lorg/jetbrains/kotlin/konan/file/File;)Lorg/jetbrains/kotlin/konan/file/File;", "defaultLinks", "noStdLib", "noDefaultLibs", "noEndorsedLibs", "directLibsSequence", "Lkotlin/sequences/Sequence;", "givenName", "found", "candidate", "getDefaultLibrariesFromDir", "directory", "libraryComponentBuilder", "file", "isDefault", "libraryMatch", "unresolved", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;Lorg/jetbrains/kotlin/library/UnresolvedLibrary;)Z", "resolutionSequence", "givenPath", "resolve", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/LenientUnresolvedLibrary;", "isDefaultLink", "(Lorg/jetbrains/kotlin/library/LenientUnresolvedLibrary;Z)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/RequiredUnresolvedLibrary;", "(Lorg/jetbrains/kotlin/library/RequiredUnresolvedLibrary;Z)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "resolveOrNull", "(Lorg/jetbrains/kotlin/library/UnresolvedLibrary;Z)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "validFileOrNull", "path", "filterOutPre_1_4_libraries", "ResolvedLibrary", "kotlin-util-klib"})
public abstract class KotlinLibrarySearchPathResolver<L extends KotlinLibrary>
implements SearchPathResolver<L> {
    @Nullable
    private final String distributionKlib;
    @Nullable
    private final String localKotlinDir;
    private final boolean skipCurrentDir;
    @NotNull
    private final Logger logger;
    @Nullable
    private final File distPlatformHead;
    @NotNull
    private final Lazy repoRoots$delegate;
    @NotNull
    private final Lazy directLibraries$delegate;
    @NotNull
    private final Lazy searchRoots$delegate;
    @NotNull
    private final Lazy files$delegate;
    @NotNull
    private final HashMap<UnresolvedLibrary, ResolvedLibrary> resolvedLibraries;

    public KotlinLibrarySearchPathResolver(@NotNull List<String> repositories, @NotNull List<String> directLibs, @Nullable String distributionKlib, @Nullable String localKotlinDir, boolean skipCurrentDir, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter(directLibs, (String)"directLibs");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.distributionKlib = distributionKlib;
        this.localKotlinDir = localKotlinDir;
        this.skipCurrentDir = skipCurrentDir;
        this.logger = logger;
        this.repoRoots$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends File>>(repositories){
            final /* synthetic */ List<String> $repositories;
            {
                this.$repositories = $repositories;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<File> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$repositories;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    File file2 = new File((String)it);
                    collection.add(file2);
                }
                return (List)destination$iv$iv;
            }
        }));
        this.directLibraries$delegate = LazyKt.lazy((Function0)new Function0<List<? extends L>>(directLibs, this){
            final /* synthetic */ List<String> $directLibs;
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            {
                this.$directLibs = $directLibs;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<L> invoke() {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Iterable iterable = this.$directLibs;
                KotlinLibrarySearchPathResolver<L> kotlinLibrarySearchPathResolver = this.this$0;
                boolean $i$f$mapNotNull = false;
                void var4_4 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    File file2;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (KotlinLibrarySearchPathResolver.access$found(kotlinLibrarySearchPathResolver, new File(it)) == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    File it$iv$iv = file2;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                kotlinLibrarySearchPathResolver = this.this$0;
                boolean $i$f$flatMap = false;
                $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    File it = (File)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = kotlinLibrarySearchPathResolver.libraryComponentBuilder(it, false);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        });
        this.searchRoots$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends File>>(this){
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<File> invoke() {
                Object[] objectArray = new File[]{this.this$0.getLocalHead(), this.this$0.getDistHead(), this.this$0.getDistPlatformHead()};
                return CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.this$0.getCurrentDirHead()), (Iterable)KotlinLibrarySearchPathResolver.access$getRepoRoots(this.this$0)), (Iterable)CollectionsKt.listOf((Object[])objectArray)));
            }
        }));
        this.files$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<String> invoke() {
                void $this$mapTo$iv$iv;
                Iterable list$iv$iv;
                File it;
                Iterable $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = this.this$0.getSearchRoots();
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (File)element$iv$iv;
                    boolean bl = false;
                    list$iv$iv = it.getListFilesOrEmpty();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$flatMapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    list$iv$iv = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string2 = it.getAbsolutePath();
                    collection.add(string2);
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
        }));
        this.resolvedLibraries = new HashMap();
    }

    @Nullable
    public final String getDistributionKlib() {
        return this.distributionKlib;
    }

    @Nullable
    public final String getLocalKotlinDir() {
        return this.localKotlinDir;
    }

    public final boolean getSkipCurrentDir() {
        return this.skipCurrentDir;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final File getLocalHead() {
        File file2;
        String string2 = this.localKotlinDir;
        return string2 == null ? null : ((file2 = FileKt.File((String)string2)) == null ? null : this.getKlib(file2));
    }

    @Nullable
    public final File getDistHead() {
        File file2;
        String string2 = this.distributionKlib;
        return string2 == null ? null : ((file2 = FileKt.File((String)string2)) == null ? null : file2.child("common"));
    }

    @Nullable
    public File getDistPlatformHead() {
        return this.distPlatformHead;
    }

    @Nullable
    public final File getCurrentDirHead() {
        return !this.skipCurrentDir ? File.Companion.getUserDir() : null;
    }

    private final List<File> getRepoRoots() {
        Lazy lazy = this.repoRoots$delegate;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public abstract List<L> libraryComponentBuilder(@NotNull File var1, boolean var2);

    private final List<KotlinLibrary> getDirectLibraries() {
        Lazy lazy = this.directLibraries$delegate;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public List<File> getSearchRoots() {
        Lazy lazy = this.searchRoots$delegate;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    private final Set<String> getFiles() {
        Lazy lazy = this.files$delegate;
        boolean bl = false;
        return (Set)lazy.getValue();
    }

    private final File found(File candidate) {
        File noSuffix = new File(UtilKt.removeSuffixIfPresent((String)candidate.getPath(), (String)".klib"));
        File withSuffix = new File(UtilKt.suffixIfNot((String)candidate.getPath(), (String)".klib"));
        return KotlinLibrarySearchPathResolver.found$check(this, withSuffix) ? withSuffix : (KotlinLibrarySearchPathResolver.found$check(this, noSuffix) ? noSuffix : null);
    }

    private final File validFileOrNull(String path) {
        Object object;
        try {
            object = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(path)");
            object = new File((Path)object);
        }
        catch (InvalidPathException _) {
            object = null;
        }
        return object;
    }

    private final Sequence<File> directLibsSequence(String givenName) {
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getDirectLibraries()), (Function1)((Function1)new Function1<KotlinLibrary, Boolean>(givenName){
            final /* synthetic */ String $givenName;
            {
                this.$givenName = $givenName;
                super(1);
            }

            public final boolean invoke(@NotNull KotlinLibrary it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)KotlinLibraryKt.getUniqueName(it), (Object)this.$givenName);
            }
        })), (Function1)directLibsSequence.2.INSTANCE);
    }

    @Override
    @NotNull
    public Sequence<File> resolutionSequence(@NotNull String givenPath) {
        Sequence sequence2;
        Intrinsics.checkNotNullParameter((Object)givenPath, (String)"givenPath");
        File given = this.validFileOrNull(givenPath);
        if (given == null) {
            sequence2 = this.directLibsSequence(givenPath);
        } else if (given.isAbsolute()) {
            Object[] objectArray = new File[]{this.found(given)};
            sequence2 = SequencesKt.sequenceOf((Object[])objectArray);
        } else {
            Sequence repoLibs2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.getSearchRoots()), (Function1)((Function1)new Function1<File, File>(this, given){
                final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
                final /* synthetic */ File $given;
                {
                    this.this$0 = $receiver;
                    this.$given = $given;
                    super(1);
                }

                @Nullable
                public final File invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return KotlinLibrarySearchPathResolver.access$found(this.this$0, new File(it, this.$given));
                }
            }));
            sequence2 = SequencesKt.plus(this.directLibsSequence(givenPath), (Sequence)repoLibs2);
        }
        Sequence sequence3 = sequence2;
        return SequencesKt.filterNotNull(sequence3);
    }

    private final Sequence<File> filterOutPre_1_4_libraries(Sequence<File> $this$filterOutPre_1_4_libraries) {
        return SequencesKt.filter($this$filterOutPre_1_4_libraries, (Function1)((Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull File it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (KotlinLibraryImplKt.isPre_1_4_Library(it)) {
                    this.this$0.getLogger().warning("Skipping \"" + it + "\" as it is a pre 1.4 library");
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        }));
    }

    private final L resolveOrNull(UnresolvedLibrary unresolved, boolean isDefaultLink) {
        Object object;
        Map $this$getOrPut$iv = this.resolvedLibraries;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(unresolved);
        if (value$iv == null) {
            Object object2;
            boolean bl = false;
            String givenPath = unresolved.getPath();
            try {
                object2 = SequencesKt.firstOrNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap(this.filterOutPre_1_4_libraries(this.resolutionSequence(givenPath)), (Function1)new Function1<File, Sequence<? extends L>>(this, isDefaultLink){
                    final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
                    final /* synthetic */ boolean $isDefaultLink;
                    {
                        this.this$0 = $receiver;
                        this.$isDefaultLink = $isDefaultLink;
                        super(1);
                    }

                    @NotNull
                    public final Sequence<L> invoke(@NotNull File it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return CollectionsKt.asSequence((Iterable)this.this$0.libraryComponentBuilder(it, this.$isDefaultLink));
                    }
                }), (Function1)new Function1<L, L>(this, unresolved){
                    final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
                    final /* synthetic */ UnresolvedLibrary $unresolved;
                    {
                        this.this$0 = $receiver;
                        this.$unresolved = $unresolved;
                        super(1);
                    }

                    @Nullable
                    public final L invoke(@NotNull L it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        L l = it;
                        KotlinLibrarySearchPathResolver<L> kotlinLibrarySearchPathResolver = this.this$0;
                        UnresolvedLibrary unresolvedLibrary = this.$unresolved;
                        boolean bl = false;
                        boolean bl2 = false;
                        L it2 = l;
                        boolean bl3 = false;
                        return (L)(kotlinLibrarySearchPathResolver.libraryMatch(it2, unresolvedLibrary) ? l : null);
                    }
                })));
                boolean bl2 = false;
                boolean bl3 = false;
                KotlinLibrary p0 = (KotlinLibrary)object2;
                boolean bl4 = false;
                object2 = new ResolvedLibrary(this, p0);
            }
            catch (Throwable e) {
                this.getLogger().error(Intrinsics.stringPlus((String)"Failed to resolve Kotlin library: ", (Object)givenPath));
                throw e;
            }
            Object answer$iv = object2;
            $this$getOrPut$iv.put(unresolved, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((ResolvedLibrary)object).getLibrary();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public L resolve(@NotNull LenientUnresolvedLibrary unresolved, boolean isDefaultLink) {
        Intrinsics.checkNotNullParameter((Object)unresolved, (String)"unresolved");
        L l = this.resolveOrNull(unresolved, isDefaultLink);
        boolean bl = false;
        boolean bl2 = false;
        L resolvedLibrary = l;
        boolean bl3 = false;
        if (resolvedLibrary == null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.getSearchRoots();
            StringBuilder stringBuilder = new StringBuilder().append("Could not find \"").append(unresolved.getPath()).append("\" in ");
            Logger logger = this.getLogger();
            boolean $i$f$map = false;
            void var12_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                String string2 = it.getAbsolutePath();
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            logger.warning(stringBuilder.append(collection).toString());
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public L resolve(@NotNull RequiredUnresolvedLibrary unresolved, boolean isDefaultLink) {
        Intrinsics.checkNotNullParameter((Object)unresolved, (String)"unresolved");
        L l = this.resolveOrNull(unresolved, isDefaultLink);
        if (l == null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.getSearchRoots();
            StringBuilder stringBuilder = new StringBuilder().append("Could not find \"").append(unresolved.getPath()).append("\" in ");
            Logger logger = this.getLogger();
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.getAbsolutePath();
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            logger.fatal(stringBuilder.append(collection).toString());
            throw null;
        }
        return l;
    }

    @Override
    public boolean libraryMatch(@NotNull L candidate, @NotNull UnresolvedLibrary unresolved) {
        Intrinsics.checkNotNullParameter(candidate, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)unresolved, (String)"unresolved");
        return true;
    }

    @Override
    @NotNull
    public L resolve(@NotNull String givenPath) {
        Intrinsics.checkNotNullParameter((Object)givenPath, (String)"givenPath");
        return this.resolve(UnresolvedLibraryKt.UnresolvedLibrary(givenPath, null), false);
    }

    private final File getKlib(File $this$klib) {
        return new File($this$klib, "klib");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getDefaultRoots() {
        void $this$filterTo$iv$iv;
        Object[] objectArray = new File[]{this.getDistHead(), this.getDistPlatformHead()};
        Iterable $this$filter$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.getExists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Sequence<L> getDefaultLibrariesFromDir(File directory) {
        return directory.getExists() ? SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)directory.getListFiles()), (Function1)getDefaultLibrariesFromDir.1.INSTANCE), (Function1)getDefaultLibrariesFromDir.2.INSTANCE), (Function1)getDefaultLibrariesFromDir.3.INSTANCE), (Function1)new Function1<RequiredUnresolvedLibrary, L>(this){
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final L invoke(@NotNull RequiredUnresolvedLibrary it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.resolve(it, true);
            }
        }) : SequencesKt.emptySequence();
    }

    @Override
    @NotNull
    public List<L> defaultLinks(boolean noStdLib, boolean noDefaultLibs, boolean noEndorsedLibs) {
        File file2;
        File it;
        boolean bl;
        boolean bl2;
        File file3;
        File file4;
        boolean bl3 = false;
        List result = new ArrayList();
        if (!noStdLib) {
            result.add(this.resolve(UnresolvedLibraryKt.UnresolvedLibrary("stdlib", null), true));
        }
        if (!noEndorsedLibs && (file4 = this.getDistHead()) != null) {
            file3 = file4;
            bl2 = false;
            bl = false;
            it = file3;
            boolean bl4 = false;
            CollectionsKt.addAll((Collection)result, this.getDefaultLibrariesFromDir(it));
        }
        if (!noDefaultLibs && (file2 = this.getDistPlatformHead()) != null) {
            file3 = file2;
            bl2 = false;
            bl = false;
            it = file3;
            boolean bl5 = false;
            CollectionsKt.addAll((Collection)result, this.getDefaultLibrariesFromDir(it));
        }
        return result;
    }

    @Override
    public boolean isProvidedByDefault(@NotNull UnresolvedLibrary unresolved) {
        return SearchPathResolver.DefaultImpls.isProvidedByDefault(this, unresolved);
    }

    private static final boolean found$check(KotlinLibrarySearchPathResolver<L> this$0, File file2) {
        return super.getFiles().contains(file2.getAbsolutePath()) || file2.getExists();
    }

    public static final /* synthetic */ File access$found(KotlinLibrarySearchPathResolver $this, File candidate) {
        return $this.found(candidate);
    }

    public static final /* synthetic */ List access$getRepoRoots(KotlinLibrarySearchPathResolver $this) {
        return $this.getRepoRoots();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0003R\u0015\u0010\u0002\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver$ResolvedLibrary;", "", "library", "(Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver;Lorg/jetbrains/kotlin/library/KotlinLibrary;)V", "getLibrary", "()Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "kotlin-util-klib"})
    private static final class ResolvedLibrary {
        @Nullable
        private final L library;
        final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;

        public ResolvedLibrary(L library) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this.this$0 = this$0;
            this.library = library;
        }

        @Nullable
        public final L getLibrary() {
            return this.library;
        }
    }
}

