/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.io.DataOutput;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.SerializedDeclaration;
import org.jetbrains.kotlin.library.impl.IrDataWriter;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/library/impl/IrDeclarationWriter;", "Lorg/jetbrains/kotlin/library/impl/IrDataWriter;", "declarations", "", "Lorg/jetbrains/kotlin/library/SerializedDeclaration;", "(Ljava/util/List;)V", "writeData", "", "dataOutput", "Ljava/io/DataOutput;", "Companion", "kotlin-util-klib"})
public final class IrDeclarationWriter
extends IrDataWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<SerializedDeclaration> declarations;
    private static final int SINGLE_INDEX_RECORD_SIZE = 12;
    private static final int INDEX_HEADER_SIZE = 4;

    public IrDeclarationWriter(@NotNull List<SerializedDeclaration> declarations) {
        Intrinsics.checkNotNullParameter(declarations, (String)"declarations");
        super(null);
        this.declarations = declarations;
    }

    @Override
    protected void writeData(@NotNull DataOutput dataOutput) {
        Intrinsics.checkNotNullParameter((Object)dataOutput, (String)"dataOutput");
        dataOutput.writeInt(this.declarations.size());
        int dataOffset = 4 + 12 * this.declarations.size();
        for (SerializedDeclaration d : this.declarations) {
            dataOutput.writeInt(d.getId());
            dataOutput.writeInt(dataOffset);
            dataOutput.writeInt(d.getSize());
            dataOffset += d.getSize();
        }
        for (SerializedDeclaration d : this.declarations) {
            dataOutput.write(d.getBytes());
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/library/impl/IrDeclarationWriter$Companion;", "", "()V", "INDEX_HEADER_SIZE", "", "SINGLE_INDEX_RECORD_SIZE", "kotlin-util-klib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

