/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.benchmark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.benchmark.BenchmarkReportFormatter;
import kotlinx.benchmark.CommonBenchmarkAnnotationsKt;
import kotlinx.benchmark.ReportBenchmarkResult;
import kotlinx.benchmark.ReportBenchmarksStatisticsKt;
import kotlinx.benchmark.UtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u001e\u0010\u000b\u001a\u00020\f*\u00060\rj\u0002`\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002J&\u0010\u0011\u001a\u00020\f*\u00060\rj\u0002`\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0012\u001a\u00020\nH\u0002J\f\u0010\u0013\u001a\u00020\u0003*\u00020\u0003H\u0002J\f\u0010\u0014\u001a\u00020\u0003*\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lkotlinx/benchmark/CsvBenchmarkReportFormatter;", "Lkotlinx/benchmark/BenchmarkReportFormatter;", "delimiter", "", "(Ljava/lang/String;)V", "getDelimiter", "()Ljava/lang/String;", "format", "results", "", "Lkotlinx/benchmark/ReportBenchmarkResult;", "appendHeader", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "params", "", "appendResult", "result", "escape", "quote", "kotlinx-benchmark-runtime"})
@SourceDebugExtension(value={"SMAP\nBenchmarkReportFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BenchmarkReportFormatter.kt\nkotlinx/benchmark/CsvBenchmarkReportFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1360#2:224\n1446#2,5:225\n1855#2,2:230\n1855#2,2:232\n1855#2,2:234\n*S KotlinDebug\n*F\n+ 1 BenchmarkReportFormatter.kt\nkotlinx/benchmark/CsvBenchmarkReportFormatter\n*L\n116#1:224\n116#1:225,5\n118#1:230,2\n131#1:232,2\n146#1:234,2\n*E\n"})
final class CsvBenchmarkReportFormatter
extends BenchmarkReportFormatter {
    @NotNull
    private final String delimiter;

    public CsvBenchmarkReportFormatter(@NotNull String delimiter) {
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        super(null);
        this.delimiter = delimiter;
    }

    @NotNull
    public final String getDelimiter() {
        return this.delimiter;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String format(@NotNull Collection<ReportBenchmarkResult> results) {
        void $this$flatMapTo$iv$iv;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(results, (String)"results");
        StringBuilder $this$format_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$flatMap$iv = results;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ReportBenchmarkResult it = (ReportBenchmarkResult)element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = it.getParams().keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set allParams = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.appendHeader($this$format_u24lambda_u242, allParams);
        Iterable $this$forEach$iv = results;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReportBenchmarkResult it = (ReportBenchmarkResult)element$iv;
            boolean bl3 = false;
            this.appendResult($this$format_u24lambda_u242, allParams, it);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void appendHeader(StringBuilder $this$appendHeader, Set<String> params) {
        $this$appendHeader.append(this.quote("Benchmark")).append(this.delimiter);
        $this$appendHeader.append(this.quote("Mode")).append(this.delimiter);
        $this$appendHeader.append(this.quote("Threads")).append(this.delimiter);
        $this$appendHeader.append(this.quote("Samples")).append(this.delimiter);
        $this$appendHeader.append(this.quote("Score")).append(this.delimiter);
        $this$appendHeader.append(this.quote("Score Error (99.9%)")).append(this.delimiter);
        $this$appendHeader.append(this.quote("Unit"));
        Iterable $this$forEach$iv = params;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            $this$appendHeader.append(this.delimiter);
            $this$appendHeader.append("Param: " + this.escape(it));
        }
        $this$appendHeader.append("\r\n");
    }

    private final void appendResult(StringBuilder $this$appendResult, Set<String> params, ReportBenchmarkResult result) {
        $this$appendResult.append(this.quote(this.escape(result.getBenchmark().getName()))).append(this.delimiter);
        $this$appendResult.append(this.quote(CommonBenchmarkAnnotationsKt.toText(result.getConfig().getMode()))).append(this.delimiter);
        $this$appendResult.append(1).append(this.delimiter);
        $this$appendResult.append(result.getValues().length).append(this.delimiter);
        $this$appendResult.append(UtilsKt.format(result.getScore(), 6, false)).append(this.delimiter);
        $this$appendResult.append(UtilsKt.format(result.getError(), 6, false)).append(this.delimiter);
        $this$appendResult.append(this.quote(ReportBenchmarksStatisticsKt.unitText(result.getConfig().getMode(), result.getConfig().getOutputTimeUnit())));
        Iterable $this$forEach$iv = params;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String param;
            String it = (String)element$iv;
            boolean bl = false;
            $this$appendResult.append(this.delimiter);
            if (result.getParams().get(it) == null) continue;
            boolean bl2 = false;
            $this$appendResult.append(this.quote(this.escape(param)));
        }
        $this$appendResult.append("\r\n");
    }

    private final String escape(String $this$escape) {
        return StringsKt.replace$default((String)$this$escape, (String)"\"", (String)"\"\"", (boolean)false, (int)4, null);
    }

    private final String quote(String $this$quote) {
        return '\"' + $this$quote + '\"';
    }
}

