/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.benchmark;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.benchmark.BenchmarkConfigurationKt;
import kotlinx.benchmark.CommonBenchmarkAnnotationsKt;
import kotlinx.benchmark.RunnerConfiguration;
import kotlinx.benchmark.RunnerConfigurationKt;
import kotlinx.benchmark.SuiteDescriptor;
import kotlinx.benchmark.internal.KotlinxBenchmarkRuntimeInternalApi;
import org.jetbrains.annotations.NotNull;
import org.openjdk.jmh.annotations.Mode;

@KotlinxBenchmarkRuntimeInternalApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'BY\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u0012\n\u0010\n\u001a\u00060\bj\u0002`\t\u0012\n\u0010\u000b\u001a\u00060\fj\u0002`\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012B\u001d\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0017J\b\u0010&\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\n\u001a\u00060\bj\u0002`\t\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b \u0010\u001eR\u0017\u0010\u000b\u001a\u00060\fj\u0002`\r\u00a2\u0006\n\n\u0002\u0010#\u001a\u0004\b!\u0010\"R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006("}, d2={"Lkotlinx/benchmark/BenchmarkConfiguration;", "", "iterations", "", "warmups", "iterationTime", "", "iterationTimeUnit", "Ljava/util/concurrent/TimeUnit;", "Lkotlinx/benchmark/BenchmarkTimeUnit;", "outputTimeUnit", "mode", "Lorg/openjdk/jmh/annotations/Mode;", "Lkotlinx/benchmark/Mode;", "advanced", "", "", "<init>", "(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/TimeUnit;Lorg/openjdk/jmh/annotations/Mode;Ljava/util/Map;)V", "runner", "Lkotlinx/benchmark/RunnerConfiguration;", "suite", "Lkotlinx/benchmark/SuiteDescriptor;", "(Lkotlinx/benchmark/RunnerConfiguration;Lkotlinx/benchmark/SuiteDescriptor;)V", "getIterations", "()I", "getWarmups", "getIterationTime", "()J", "getIterationTimeUnit", "()Ljava/util/concurrent/TimeUnit;", "Ljava/util/concurrent/TimeUnit;", "getOutputTimeUnit", "getMode", "()Lorg/openjdk/jmh/annotations/Mode;", "Lorg/openjdk/jmh/annotations/Mode;", "getAdvanced", "()Ljava/util/Map;", "toString", "Companion", "kotlinx-benchmark-runtime"})
public final class BenchmarkConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int iterations;
    private final int warmups;
    private final long iterationTime;
    @NotNull
    private final TimeUnit iterationTimeUnit;
    @NotNull
    private final TimeUnit outputTimeUnit;
    @NotNull
    private final Mode mode;
    @NotNull
    private final Map<String, String> advanced;

    private BenchmarkConfiguration(int iterations, int warmups, long iterationTime, TimeUnit iterationTimeUnit, TimeUnit outputTimeUnit, Mode mode, Map<String, String> advanced) {
        this.iterations = iterations;
        this.warmups = warmups;
        this.iterationTime = iterationTime;
        this.iterationTimeUnit = iterationTimeUnit;
        this.outputTimeUnit = outputTimeUnit;
        this.mode = mode;
        this.advanced = advanced;
    }

    public final int getIterations() {
        return this.iterations;
    }

    public final int getWarmups() {
        return this.warmups;
    }

    public final long getIterationTime() {
        return this.iterationTime;
    }

    @NotNull
    public final TimeUnit getIterationTimeUnit() {
        return this.iterationTimeUnit;
    }

    @NotNull
    public final TimeUnit getOutputTimeUnit() {
        return this.outputTimeUnit;
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    @NotNull
    public final Map<String, String> getAdvanced() {
        return this.advanced;
    }

    public BenchmarkConfiguration(@NotNull RunnerConfiguration runner, @NotNull SuiteDescriptor<?> suite) {
        Mode mode;
        TimeUnit timeUnit;
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        Intrinsics.checkNotNullParameter(suite, (String)"suite");
        Integer n = runner.getIterations();
        int n2 = n != null ? n.intValue() : suite.getIterations();
        Integer n3 = runner.getWarmups();
        int n4 = n3 != null ? n3.intValue() : suite.getWarmups();
        Long l = runner.getIterationTime();
        long l2 = l != null ? l.longValue() : suite.getIterationTime().getValue();
        TimeUnit timeUnit2 = runner.getIterationTimeUnit();
        if (timeUnit2 == null) {
            timeUnit2 = suite.getIterationTime().getTimeUnit();
        }
        if ((timeUnit = runner.getOutputTimeUnit()) == null) {
            timeUnit = suite.getOutputTimeUnit();
        }
        if ((mode = runner.getMode()) == null) {
            mode = suite.getMode();
        }
        this(n2, n4, l2, timeUnit2, timeUnit, mode, runner.getAdvanced());
    }

    @NotNull
    public String toString() {
        return "iterations=" + this.iterations + ", warmups=" + this.warmups + ", iterationTime=" + this.iterationTime + ", iterationTimeUnit=" + CommonBenchmarkAnnotationsKt.toText(this.iterationTimeUnit) + ", outputTimeUnit=" + CommonBenchmarkAnnotationsKt.toText(this.outputTimeUnit) + ", mode=" + CommonBenchmarkAnnotationsKt.toText(this.mode) + CollectionsKt.joinToString$default((Iterable)this.advanced.entrySet(), (CharSequence)", ", (CharSequence)", ", null, (int)0, null, BenchmarkConfiguration::toString$lambda$0, (int)28, null);
    }

    private static final CharSequence toString$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "advanced:" + (String)it.getKey() + '=' + (String)it.getValue();
    }

    public /* synthetic */ BenchmarkConfiguration(int iterations, int warmups, long iterationTime, TimeUnit iterationTimeUnit, TimeUnit outputTimeUnit, Mode mode, Map advanced, DefaultConstructorMarker $constructor_marker) {
        this(iterations, warmups, iterationTime, iterationTimeUnit, outputTimeUnit, mode, advanced);
    }

    @KotlinxBenchmarkRuntimeInternalApi
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lkotlinx/benchmark/BenchmarkConfiguration$Companion;", "", "<init>", "()V", "parse", "Lkotlinx/benchmark/BenchmarkConfiguration;", "description", "", "kotlinx-benchmark-runtime"})
    @SourceDebugExtension(value={"SMAP\nBenchmarkConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BenchmarkConfiguration.kt\nkotlinx/benchmark/BenchmarkConfiguration$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n535#2:70\n520#2,6:71\n1187#3,2:77\n1261#3,2:79\n1264#3:82\n1#4:81\n*S KotlinDebug\n*F\n+ 1 BenchmarkConfiguration.kt\nkotlinx/benchmark/BenchmarkConfiguration$Companion\n*L\n39#1:70\n39#1:71,6\n41#1:77,2\n41#1:79,2\n41#1:82\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BenchmarkConfiguration parse(@NotNull String description) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Map<String, String> parameters;
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Map<String, String> map = parameters = BenchmarkConfigurationKt.parseMap(description);
            boolean $i$f$filter = false;
            void var6_5 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)((String)it.getKey()), (String)"advanced:", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv.entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                String advancedKey = StringsKt.substringAfter$default((String)((String)it.getKey()), (String)":", null, (int)2, null);
                if (!(((CharSequence)advancedKey).length() > 0)) {
                    boolean bl2 = false;
                    String string = "Invalid advanced key - should not be empty";
                    throw new IllegalStateException(string.toString());
                }
                Pair pair = TuplesKt.to((Object)advancedKey, it.getValue());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map advanced = destination$iv$iv2;
            return new BenchmarkConfiguration(Integer.parseInt(kotlinx.benchmark.BenchmarkConfiguration$Companion.parse$getParameterValue(parameters, "iterations")), Integer.parseInt(kotlinx.benchmark.BenchmarkConfiguration$Companion.parse$getParameterValue(parameters, "warmups")), Long.parseLong(kotlinx.benchmark.BenchmarkConfiguration$Companion.parse$getParameterValue(parameters, "iterationTime")), RunnerConfigurationKt.parseTimeUnit(kotlinx.benchmark.BenchmarkConfiguration$Companion.parse$getParameterValue(parameters, "iterationTimeUnit")), RunnerConfigurationKt.parseTimeUnit(kotlinx.benchmark.BenchmarkConfiguration$Companion.parse$getParameterValue(parameters, "outputTimeUnit")), CommonBenchmarkAnnotationsKt.toMode(kotlinx.benchmark.BenchmarkConfiguration$Companion.parse$getParameterValue(parameters, "mode")), advanced, null);
        }

        private static final String parse$getParameterValue(Map<String, String> parameters, String key) {
            String string = parameters.get(key);
            if (string == null) {
                throw new NoSuchElementException("Parameter `" + key + "` is required.");
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

