/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.ContextAwareKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.ProtoNumber;
import kotlinx.serialization.protobuf.ProtoOneOf;
import kotlinx.serialization.protobuf.ProtoPacked;
import kotlinx.serialization.protobuf.ProtoType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a2\u0010\u0000\u001a\u00060\u0001j\u0002`\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u0080\u0088\u0004\u001a\u001e\u0010\u0019\u001a\u00060\u0001j\u0002`\u0007*\u00060\u0001j\u0002`\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0080\u0080\u0004\u001a\u001a\u0010\u001a\u001a\u00060\u0001j\u0002`\u0007*\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0003H\u0080\u0080\u0004\u001a\"\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\fH\u0080\u0080\u0004\u001a\"\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0014H\u0082\u0080\u0004\u001a\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140$*\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0080\u0080\u0004\u001a \u0010'\u001a\u0004\u0018\u00010\u0014*\u00020\u00142\u0006\u0010%\u001a\u00020&2\u0006\u0010\b\u001a\u00020\u0003H\u0080\u0080\u0004\"\u000f\u0010\u0002\u001a\u00020\u0003X\u0080\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0004\u001a\u00020\u0001X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0005\u001a\u00020\u0001X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0006\u001a\u00020\u0001X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\b\u001a\u00020\u0003*\u00060\u0001j\u0002`\u00078\u00c0\u0002X\u0080\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u001d\u0010\u0010\u001a\u00020\n*\u00060\u0001j\u0002`\u00078@X\u0080\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0019\u0010\u0013\u001a\u00020\f*\u00020\u00148@X\u0080\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\"\u001d\u0010\u0016\u001a\u00020\f*\u00060\u0001j\u0002`\u00078@X\u0080\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u001d\u0010\u0018\u001a\u00020\f*\u00060\u0001j\u0002`\u00078@X\u0080\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017*\f\b\u0000\u0010\u0000\"\u00020\u00012\u00020\u0001\u00a8\u0006("}, d2={"ProtoDesc", "", "ID_HOLDER_ONE_OF", "", "ONEOFMASK", "INTTYPEMASK", "PACKEDMASK", "Lkotlinx/serialization/protobuf/internal/ProtoDesc;", "protoId", "type", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "packed", "", "oneOf", "getProtoId", "(J)I", "integerType", "getIntegerType", "(J)Lkotlinx/serialization/protobuf/ProtoIntegerType;", "isPackable", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Z", "isPacked", "(J)Z", "isOneOf", "overrideId", "extractParameters", "index", "extractProtoId", "descriptor", "zeroBasedDefault", "checkFieldNumber", "", "fieldNumber", "propertyIndex", "getAllOneOfSerializerOfField", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getActualOneOfSerializer", "kotlinx-serialization-protobuf"})
@SourceDebugExtension(value={"SMAP\nHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n56#1,3:173\n61#1:182\n2802#2:176\n2792#2,3:178\n1#3:177\n1#3:181\n*S KotlinDebug\n*F\n+ 1 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n*L\n114#1:173,3\n170#1:182\n159#1:176\n160#1:178,3\n159#1:177\n*E\n"})
public final class HelpersKt {
    public static final int ID_HOLDER_ONE_OF = -2;
    private static final long ONEOFMASK = 0x1000000000L;
    private static final long INTTYPEMASK = 0x600000000L;
    private static final long PACKEDMASK = 0x100000000L;

    public static final long ProtoDesc(int protoId, @NotNull ProtoIntegerType type, boolean packed, boolean oneOf) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        boolean $i$f$ProtoDesc = false;
        long packedBits = packed ? 0x100000000L : 0L;
        long oneOfBits = oneOf ? 0x1000000000L : 0L;
        return packedBits | oneOfBits | type.getSignature$kotlinx_serialization_protobuf() | (long)protoId;
    }

    public static /* synthetic */ long ProtoDesc$default(int protoId, ProtoIntegerType type, boolean packed, boolean oneOf, int n, Object object) {
        if ((n & 4) != 0) {
            packed = false;
        }
        if ((n & 8) != 0) {
            oneOf = false;
        }
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        boolean $i$f$ProtoDesc = false;
        long packedBits = packed ? 0x100000000L : 0L;
        long oneOfBits = oneOf ? 0x1000000000L : 0L;
        return packedBits | oneOfBits | type.getSignature$kotlinx_serialization_protobuf() | (long)protoId;
    }

    public static final int getProtoId(long $this$protoId) {
        boolean $i$f$getProtoId = false;
        return (int)($this$protoId & Integer.MAX_VALUE);
    }

    @NotNull
    public static final ProtoIntegerType getIntegerType(long $this$integerType) {
        long l = $this$integerType & 0x600000000L;
        return l == ProtoIntegerType.DEFAULT.getSignature$kotlinx_serialization_protobuf() ? ProtoIntegerType.DEFAULT : (l == ProtoIntegerType.SIGNED.getSignature$kotlinx_serialization_protobuf() ? ProtoIntegerType.SIGNED : ProtoIntegerType.FIXED);
    }

    public static final boolean isPackable(@NotNull SerialDescriptor $this$isPackable) {
        Intrinsics.checkNotNullParameter((Object)$this$isPackable, (String)"<this>");
        SerialKind serialKind = $this$isPackable.getKind();
        return !Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.STRING.INSTANCE) && serialKind instanceof PrimitiveKind;
    }

    public static final boolean isPacked(long $this$isPacked) {
        return ($this$isPacked & 0x100000000L) != 0L;
    }

    public static final boolean isOneOf(long $this$isOneOf) {
        return ($this$isOneOf & 0x1000000000L) != 0L;
    }

    public static final long overrideId(long $this$overrideId, int protoId) {
        return $this$overrideId & 0xFFFFFFF00000000L | (long)protoId;
    }

    /*
     * WARNING - void declaration
     */
    public static final long extractParameters(@NotNull SerialDescriptor $this$extractParameters, int index) {
        void protoId$iv;
        void type$iv;
        void packed$iv;
        int i;
        Intrinsics.checkNotNullParameter((Object)$this$extractParameters, (String)"<this>");
        List annotations = $this$extractParameters.getElementAnnotations(index);
        int protoId = index + 1;
        ProtoIntegerType format = ProtoIntegerType.DEFAULT;
        boolean protoPacked = false;
        boolean isOneOf = false;
        int n = ((Collection)annotations).size();
        for (i = 0; i < n; ++i) {
            Annotation annotation = (Annotation)annotations.get(i);
            if (annotation instanceof ProtoNumber) {
                protoId = ((ProtoNumber)annotation).number();
                HelpersKt.checkFieldNumber(protoId, i, $this$extractParameters);
                continue;
            }
            if (annotation instanceof ProtoType) {
                format = ((ProtoType)annotation).type();
                continue;
            }
            if (annotation instanceof ProtoPacked) {
                protoPacked = true;
                continue;
            }
            if (!(annotation instanceof ProtoOneOf)) continue;
            isOneOf = true;
        }
        if (isOneOf) {
            protoId = index + 1;
        }
        i = protoId;
        ProtoIntegerType protoIntegerType = format;
        boolean annotation = protoPacked;
        boolean oneOf$iv = isOneOf;
        boolean $i$f$ProtoDesc = false;
        long packedBits$iv = packed$iv != false ? 0x100000000L : 0L;
        long oneOfBits$iv = oneOf$iv ? 0x1000000000L : 0L;
        return packedBits$iv | oneOfBits$iv | type$iv.getSignature$kotlinx_serialization_protobuf() | (long)protoId$iv;
    }

    public static final int extractProtoId(@NotNull SerialDescriptor descriptor, int index, boolean zeroBasedDefault) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        List annotations = descriptor.getElementAnnotations(index);
        int result = zeroBasedDefault ? index : index + 1;
        int n = ((Collection)annotations).size();
        for (int i = 0; i < n; ++i) {
            Annotation annotation = (Annotation)annotations.get(i);
            if (annotation instanceof ProtoOneOf) {
                return -2;
            }
            if (!(annotation instanceof ProtoNumber)) continue;
            result = ((ProtoNumber)annotation).number();
            if (zeroBasedDefault) continue;
            HelpersKt.checkFieldNumber(result, i, descriptor);
        }
        return result;
    }

    private static final void checkFieldNumber(int fieldNumber, int propertyIndex, SerialDescriptor descriptor) {
        if (fieldNumber <= 0) {
            throw new SerializationException(fieldNumber + " is not allowed in ProtoNumber for property '" + descriptor.getElementName(propertyIndex) + "' of '" + descriptor.getSerialName() + "', because protobuf supports field numbers in range 1..2147483647");
        }
    }

    @NotNull
    public static final List<SerialDescriptor> getAllOneOfSerializerOfField(@NotNull SerialDescriptor $this$getAllOneOfSerializerOfField, @NotNull SerializersModule serializersModule) {
        Iterable iterable;
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$getAllOneOfSerializerOfField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        SerialKind serialKind = $this$getAllOneOfSerializerOfField.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.OPEN.INSTANCE)) {
            list = ContextAwareKt.getPolymorphicDescriptors((SerializersModule)serializersModule, (SerialDescriptor)$this$getAllOneOfSerializerOfField);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.SEALED.INSTANCE)) {
            list = CollectionsKt.toList((Iterable)SerialDescriptorKt.getElementDescriptors((SerialDescriptor)$this$getAllOneOfSerializerOfField.getElementDescriptor(1)));
        } else {
            throw new IllegalArgumentException("Class " + $this$getAllOneOfSerializerOfField.getSerialName() + " should be abstract or sealed or interface to be used as @ProtoOneOf property.");
        }
        Iterable $this$onEach$iv = list;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u240$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u240$iv) {
            boolean bl2;
            SerialDescriptor desc;
            block8: {
                desc = (SerialDescriptor)element$iv;
                boolean bl3 = false;
                Iterable $this$none$iv = desc.getElementAnnotations(0);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        Annotation anno = (Annotation)element$iv2;
                        boolean bl4 = false;
                        if (!(anno instanceof ProtoNumber)) continue;
                        bl2 = false;
                        break block8;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            throw new IllegalArgumentException(desc.getSerialName() + " implementing oneOf type " + $this$getAllOneOfSerializerOfField.getSerialName() + " should have @ProtoNumber annotation in its single property.");
        }
        return (List)iterable;
    }

    @Nullable
    public static final SerialDescriptor getActualOneOfSerializer(@NotNull SerialDescriptor $this$getActualOneOfSerializer, @NotNull SerializersModule serializersModule, int protoId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getActualOneOfSerializer, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
            Iterable iterable = HelpersKt.getAllOneOfSerializerOfField($this$getActualOneOfSerializer, serializersModule);
            for (Object t : iterable) {
                SerialDescriptor it = (SerialDescriptor)t;
                boolean bl = false;
                long $this$protoId$iv = HelpersKt.extractParameters(it, 0);
                boolean $i$f$getProtoId = false;
                if (!((int)($this$protoId$iv & Integer.MAX_VALUE) == protoId)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

