/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeSources {
    private File directory;
    private List<String> fileNames = new ArrayList<String>(0);
    private boolean dependencyAnalysisParticipation = true;
    private List<String> includes;
    private List<String> excludes;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public List<String> getFileNames() {
        return this.fileNames;
    }

    public void setFileNames(List<String> fileNames) {
        if (fileNames == null) {
            this.fileNames = new ArrayList<String>(0);
        }
        this.fileNames = fileNames;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void addInclude(String include) {
        if (this.includes == null) {
            this.includes = new ArrayList<String>(1);
        }
        this.includes.add(include);
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public boolean getDependencyAnalysisParticipation() {
        return this.dependencyAnalysisParticipation;
    }

    public void setDependencyAnalysisParticipation(boolean flag) {
        this.dependencyAnalysisParticipation = flag;
    }

    public List<File> getFiles() {
        String[] filePaths = EMPTY_STRING_ARRAY;
        if (this.includes != null || this.excludes != null) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.directory);
            if (this.includes != null && !this.includes.isEmpty()) {
                scanner.setIncludes(this.includes.toArray(EMPTY_STRING_ARRAY));
            } else {
                scanner.setIncludes(null);
            }
            if (this.excludes != null && !this.excludes.isEmpty()) {
                scanner.setExcludes(this.excludes.toArray(EMPTY_STRING_ARRAY));
            } else {
                scanner.setExcludes(null);
            }
            scanner.scan();
            filePaths = scanner.getIncludedFiles();
        }
        ArrayList<File> files = new ArrayList<File>(filePaths.length + this.fileNames.size());
        for (int i = 0; i < filePaths.length; ++i) {
            files.add(new File(this.directory, filePaths[i]));
        }
        for (String fileName : this.fileNames) {
            File file = new File(this.directory, fileName);
            boolean found = false;
            for (int k = 0; k < filePaths.length; ++k) {
                if (!((File)files.get(k)).equals(file)) continue;
                found = true;
                break;
            }
            if (found) continue;
            files.add(file);
        }
        return files;
    }

    public static List<File> getAllSourceFiles(List<NativeSources> sources) {
        if (sources == null || sources.isEmpty()) {
            return new ArrayList<File>(0);
        }
        ArrayList<File> sourceFiles = new ArrayList<File>();
        for (NativeSources source : sources) {
            sourceFiles.addAll(source.getFiles());
        }
        return sourceFiles;
    }

    public static List<File> getIncludePaths(List<NativeSources> sources) {
        if (sources == null || sources.isEmpty()) {
            return new ArrayList<File>(0);
        }
        ArrayList<File> list = new ArrayList<File>();
        for (NativeSources source : sources) {
            if (!source.getDependencyAnalysisParticipation()) continue;
            list.add(source.getDirectory());
        }
        return list;
    }

    public static List<File> getSystemIncludePaths(List<NativeSources> sources) {
        if (sources == null || sources.isEmpty()) {
            return new ArrayList<File>(0);
        }
        ArrayList<File> list = new ArrayList<File>();
        for (NativeSources source : sources) {
            if (source.getDependencyAnalysisParticipation()) continue;
            list.add(source.getDirectory());
        }
        return list;
    }
}

