/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.codehaus.mojo.natives.Dependency;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.parser.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceDependencyAnalyzer {
    public static boolean isStaled(File source, File dest, Parser parser, List<File> includePaths) throws NativeBuildException {
        if (!source.exists()) {
            throw new NativeBuildException(source.getPath() + " not found.");
        }
        if (!dest.exists() || dest.lastModified() < source.lastModified()) {
            return true;
        }
        Dependency dependency = new Dependency(null, source, parser, includePaths);
        try {
            dependency.analyze();
        }
        catch (IOException ioe) {
            throw new NativeBuildException("Error analysing " + source.getPath() + ". Reason: " + ioe.getMessage());
        }
        return dest.lastModified() < dependency.getCompositeLastModified();
    }
}

