/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.linker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codehaus.mojo.natives.AbstractExecutor;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.linker.Linker;
import org.codehaus.mojo.natives.linker.LinkerConfiguration;
import org.codehaus.mojo.natives.util.CommandLineUtil;
import org.codehaus.mojo.natives.util.EnvUtil;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinker
extends AbstractExecutor
implements Linker {
    protected abstract Commandline createLinkerCommandLine(List<File> var1, LinkerConfiguration var2) throws NativeBuildException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File link(LinkerConfiguration config, List<File> compilerOutputFiles) throws NativeBuildException, IOException {
        Properties currentObjectFiles = new Properties();
        for (File compilerOutputFile : compilerOutputFiles) {
            currentObjectFiles.setProperty(compilerOutputFile.getName(), "" + compilerOutputFile.lastModified());
        }
        boolean hasNewer = false;
        File tsFile = new File(config.getOutputDirectory(), "." + config.getOutputFileName() + ".ts");
        if (tsFile.exists()) {
            Properties oldObjectFiles = new Properties();
            FileInputStream is = null;
            try {
                is = new FileInputStream(tsFile);
                oldObjectFiles.load(is);
            }
            catch (IOException e) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                is = null;
                tsFile.delete();
                hasNewer = true;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            if (!hasNewer) {
                Set<Map.Entry<Object, Object>> entries = currentObjectFiles.entrySet();
                for (Map.Entry<Object, Object> entry : entries) {
                    String key = (String)entry.getKey();
                    long currentLastModif = Long.valueOf((String)entry.getValue());
                    String oldLastModifValue = oldObjectFiles.getProperty(key);
                    if (oldLastModifValue == null) {
                        hasNewer = true;
                    } else {
                        long oldLastModif = Long.valueOf(oldLastModifValue);
                        if (currentLastModif <= oldLastModif) continue;
                        hasNewer = true;
                    }
                    break;
                }
            }
        } else {
            hasNewer = true;
        }
        if (hasNewer) {
            Commandline cl = this.createLinkerCommandLine(compilerOutputFiles, config);
            EnvUtil.setupCommandlineEnv(cl, config.getEnvFactoryName());
            EnvUtil.setupCommandlineEnv(cl, config.getSystemProperties());
            CommandLineUtil.execute(cl, this.getLogger());
            currentObjectFiles.store(new FileOutputStream(tsFile), "Timestamp values of object files on last linking");
        } else {
            this.getLogger().debug(config.getOutputFile() + " is up to date.");
        }
        return config.getOutputFile();
    }
}

