/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.linker;

import java.io.File;
import java.util.List;
import org.codehaus.mojo.natives.linker.AbstractLinker;
import org.codehaus.mojo.natives.linker.LinkerConfiguration;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveLinker
extends AbstractLinker {
    public static final String EXECUTABLE = "ar";

    @Override
    protected Commandline createLinkerCommandLine(List<File> objectFiles, LinkerConfiguration config) {
        Commandline cl = new Commandline();
        cl.setWorkingDirectory(config.getWorkingDirectory().getPath());
        String executable = EXECUTABLE;
        if (config.getExecutable() != null && config.getExecutable().trim().length() != 0) {
            executable = config.getExecutable();
        }
        cl.setExecutable(executable);
        for (String option : config.getStartOptions()) {
            cl.createArgument().setValue(option);
        }
        cl.createArgument().setFile(config.getOutputFile());
        for (File objectFile : objectFiles) {
            cl.createArgument().setValue(objectFile.getPath());
        }
        return cl;
    }
}

