/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.mojo.natives.EnvFactory;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvUtil {
    public static String getEnv(String envKey) {
        return EnvUtil.getEnv(envKey, "");
    }

    public static String getEnv(String envKey, String defaultValue) {
        return EnvUtil.getEnv(envKey, null, defaultValue);
    }

    public static String getEnv(String envKey, String alternateSystemProperty, String defaultValue) {
        String envValue;
        block4: {
            envValue = null;
            try {
                envValue = System.getenv(envKey);
                if (envValue == null && alternateSystemProperty != null) {
                    envValue = System.getProperty(alternateSystemProperty);
                }
            }
            catch (Error e) {
                if (alternateSystemProperty == null) break block4;
                envValue = EnvUtil.getProperty(alternateSystemProperty);
            }
        }
        if (envValue == null) {
            envValue = defaultValue;
        }
        return envValue;
    }

    private static String getProperty(String key) {
        if (key != null) {
            return System.getProperty(key);
        }
        return null;
    }

    public static void setupCommandlineEnv(Commandline cl, String envFactoryName) throws NativeBuildException {
        if (envFactoryName != null && envFactoryName.trim().length() != 0) {
            try {
                EnvFactory fact = (EnvFactory)Class.forName(envFactoryName).newInstance();
                Map envs = fact.getEnvironmentVariables();
                for (String key : envs.keySet()) {
                    cl.addEnvironment(key, (String)envs.get(key));
                }
            }
            catch (Exception e) {
                throw new NativeBuildException(" Unable to instantiate " + envFactoryName, e);
            }
        }
    }

    public static void setupCommandlineEnv(Commandline cl, Map<String, String> systemProperties) throws NativeBuildException {
        if (systemProperties != null && !systemProperties.isEmpty()) {
            Map<String, String> map = systemProperties;
            if (cl.getCurrentEnvironment() == null) {
                map = new HashMap<String, String>(System.getenv());
                map.putAll(systemProperties);
            }
            Set<Map.Entry<String, String>> entries = map.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                cl.addEnvironment(entry.getKey(), entry.getValue());
            }
        }
    }
}

