/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.jade.plugins.common.ant;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.jfrog.jade.plugins.common.ant.AntBuildListener;
import org.jfrog.jade.plugins.common.ant.Maven2AntManager;
import org.jfrog.jade.plugins.common.injectable.MvnInjectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Maven2AntManagerDefaultImpl
implements Maven2AntManager {
    private Map<MavenProject, Project> mvn2antMap = new HashMap<MavenProject, Project>();

    @Override
    public Project getAntProject(MvnInjectable injectable) {
        if (injectable == null) {
            throw new IllegalArgumentException("Injectable cannot be null.");
        }
        MavenProject mvnProject = injectable.getProject();
        if (mvnProject == null) {
            throw new IllegalArgumentException("Maven project cannot be null.");
        }
        Project result = this.mvn2antMap.get(injectable.getProject());
        if (result == null) {
            result = this.newAntProject(injectable);
            this.mvn2antMap.put(mvnProject, result);
        }
        return result;
    }

    protected Project newAntProject(MvnInjectable injectable) {
        Project antProject = new Project();
        antProject.addBuildListener((BuildListener)new AntBuildListener(injectable.getLog()));
        MavenProject mvnProject = injectable.getProject();
        if (mvnProject == null) {
            throw new IllegalArgumentException("Maven project cannot be null.");
        }
        antProject.setBaseDir(mvnProject.getBasedir());
        antProject.init();
        return antProject;
    }

    @Override
    public void fillPathFromPaths(Path path, Collection<String> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        for (String location : elements) {
            path.createPathElement().setPath(location);
        }
    }

    @Override
    public void fillPathFromLocations(Path path, Collection<File> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        for (File location : elements) {
            path.createPathElement().setLocation(location);
        }
    }

    @Override
    public void fillPathFromArtifacts(Path path, Collection<Artifact> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        for (Artifact artifact : elements) {
            File file = artifact.getFile();
            if (file == null) continue;
            path.createPathElement().setLocation(file);
        }
    }
}

