/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.jade.plugins.common.injectable;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jfrog.jade.plugins.common.ant.Maven2AntManager;
import org.jfrog.jade.plugins.common.ant.Maven2AntManagerDefaultImpl;
import org.jfrog.jade.plugins.common.injectable.MvnInjectable;
import org.jfrog.jade.plugins.common.naming.ProjectNameProvider;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MvnInjectableSupport
implements MvnInjectable {
    @MojoComponent
    private MavenProjectHelper projectHelper;
    @MojoComponent
    private ArtifactResolver artifactResolver;
    @MojoComponent
    private ArtifactFactory artifactFactory;
    @MojoParameter(expression="${project}", required=true, readonly=true, description="The Maven Project")
    private MavenProject project;
    @MojoParameter(expression="${localRepository}")
    private ArtifactRepository localRepository;
    @MojoParameter(expression="${plugin.artifacts}")
    private List<Artifact> pluginArtifacts;
    private Log log;
    @MojoComponent(roleHint="ant")
    private Maven2AntManager maven2AntManager;
    @MojoComponent(roleHint="name")
    private ProjectNameProvider nameProvider;

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public void setProjectHelper(MavenProjectHelper projectHelper) {
        this.projectHelper = projectHelper;
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    @Override
    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    @Override
    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    @Override
    public Maven2AntManager getMaven2AntManager() {
        if (this.maven2AntManager == null) {
            this.maven2AntManager = new Maven2AntManagerDefaultImpl();
        }
        return this.maven2AntManager;
    }

    public void setMaven2AntManager(Maven2AntManager maven2AntManager) {
        this.maven2AntManager = maven2AntManager;
    }

    @Override
    public ProjectNameProvider getNameProvider() {
        return this.nameProvider;
    }

    public void setNameProvider(ProjectNameProvider nameProvider) {
        this.nameProvider = nameProvider;
    }

    @Override
    public List<Artifact> getPluginArtifacts() {
        return this.pluginArtifacts;
    }

    public void setPluginArtifacts(List<Artifact> pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
    }

    @Override
    public void updateFromMvnInjectable(MvnInjectable injectable) {
        this.setProject(injectable.getProject());
        this.setProjectHelper(injectable.getProjectHelper());
        this.setLog(injectable.getLog());
        this.setArtifactFactory(injectable.getArtifactFactory());
        this.setArtifactResolver(injectable.getArtifactResolver());
        this.setLocalRepository(injectable.getLocalRepository());
        this.setMaven2AntManager(injectable.getMaven2AntManager());
        this.setNameProvider(injectable.getNameProvider());
        this.setPluginArtifacts(injectable.getPluginArtifacts());
    }

    public Project getAntProject() {
        return this.getMaven2AntManager().getAntProject(this);
    }

    public void resolveArtifacts(Collection<Artifact> artifacts) throws ArtifactNotFoundException, ArtifactResolutionException {
        for (Artifact artifact : artifacts) {
            this.getArtifactResolver().resolve(artifact, this.getProject().getRemoteArtifactRepositories(), this.getLocalRepository());
        }
    }

    public Path resolveAndGetAntPath(Collection<Artifact> artifacts) throws ArtifactNotFoundException, ArtifactResolutionException {
        Project antProject = this.getAntProject();
        Path path = new Path(antProject);
        this.resolveArtifacts(artifacts);
        this.getMaven2AntManager().fillPathFromArtifacts(path, artifacts);
        return path;
    }

    public void createFolder(File destDir) throws MojoExecutionException {
        if (!destDir.exists()) {
            this.getLog().info((CharSequence)("Creating folder " + destDir));
            if (!destDir.mkdirs()) {
                throw new MojoExecutionException("Cannot create directory " + destDir);
            }
        } else if (!destDir.isDirectory()) {
            throw new MojoExecutionException("Path " + destDir + " is not a directory");
        }
    }

    protected void fillPluginSettings(List<Plugin> buildPlugins, String pluginArtifactId, Object toFill, Class pluginClass) {
        if (toFill == null) {
            throw new RuntimeException("Cannot fill data to empty class");
        }
        if (pluginClass == null) {
            pluginClass = toFill.getClass();
        }
        HashMap<String, String> optionNameValues = new HashMap<String, String>();
        for (Plugin plugin : buildPlugins) {
            if (!plugin.getArtifactId().equals(pluginArtifactId)) continue;
            Xpp3Dom o = (Xpp3Dom)plugin.getConfiguration();
            if (o == null) break;
            Xpp3Dom[] doms = o.getChildren();
            for (int i = 0; i < doms.length; ++i) {
                Xpp3Dom dom = doms[i];
                if (dom.getChildCount() != 0) continue;
                optionNameValues.put(dom.getName(), dom.getValue());
            }
        }
        this.fillDeclaredFields(pluginClass, toFill, optionNameValues);
    }

    private void fillDeclaredFields(Class pluginClass, Object toFill, Map<String, String> optionNameValues) {
        Field[] declaredFields = pluginClass.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            MojoParameter mojoParamAnno;
            Field declaredField = declaredFields[i];
            String fieldName = declaredField.getName();
            if (!declaredField.isAnnotationPresent(MojoParameter.class)) continue;
            String value = optionNameValues.get(fieldName);
            if (value == null && (value = (mojoParamAnno = declaredField.getAnnotation(MojoParameter.class)).defaultValue()) != null && value.trim().length() == 0) {
                value = null;
            }
            if (value == null) continue;
            declaredField.setAccessible(true);
            try {
                Class<?> type = declaredField.getType();
                if (type == Integer.TYPE || type == Integer.class) {
                    declaredField.set(toFill, new Integer(value));
                    continue;
                }
                if (type == Boolean.TYPE || type == Boolean.class) {
                    declaredField.set(toFill, new Boolean(value));
                    continue;
                }
                if (type == String.class) {
                    declaredField.set(toFill, value);
                    continue;
                }
                this.getLog().warn((CharSequence)("MojoParameter type " + type + " in field " + declaredField + " not supported on Anno Mojo Fill"));
                continue;
            }
            catch (IllegalAccessException e) {
                this.getLog().error((Throwable)e);
            }
        }
        Class superclass = pluginClass.getSuperclass();
        if (superclass != Object.class) {
            this.fillDeclaredFields(superclass, toFill, optionNameValues);
        }
    }

    protected String getFailSafeScope(Artifact artifact) {
        String scope = artifact.getScope();
        if (scope == null || scope.length() == 0) {
            scope = "runtime";
        }
        return scope;
    }
}

