/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.jade.plugins.common.naming;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.jfrog.jade.plugins.common.naming.GroupDefinition;
import org.jfrog.jade.plugins.common.naming.ProjectNameProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectNameProviderImpl
implements ProjectNameProvider {
    private boolean initialized = false;
    private Set<GroupDefinition> groupDefinitions = new HashSet<GroupDefinition>();

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public Set<GroupDefinition> getGroupDefinitions() {
        return this.groupDefinitions;
    }

    @Override
    public void setGroupDefinitions(Set<GroupDefinition> groupDefinitions) {
        this.groupDefinitions = groupDefinitions;
    }

    @Override
    public String getProjectName(MavenProject project) {
        String artifactId = project.getArtifactId();
        String groupId = project.getGroupId();
        return this.getProjectName(groupId, artifactId);
    }

    @Override
    public String getProjectName(Artifact artifact) {
        String artifactId = artifact.getArtifactId();
        String groupId = artifact.getGroupId();
        return this.getProjectName(groupId, artifactId);
    }

    @Override
    public String getProjectName(Dependency dependency) {
        String artifactId = dependency.getArtifactId();
        String groupId = dependency.getGroupId();
        return this.getProjectName(groupId, artifactId);
    }

    private String getProjectName(String groupId, String artifactId) {
        if (!this.hasGroupDefinitions()) {
            return artifactId;
        }
        StringBuffer result = new StringBuffer(artifactId);
        String groupName = this.getGroupName(groupId);
        if (groupName != null) {
            result.insert(0, '-');
            result.insert(0, groupName);
        }
        return result.toString();
    }

    @Override
    public String getGroupName(String groupId) {
        String bestMatch = null;
        int priority = 0;
        for (GroupDefinition groupDefinition : this.groupDefinitions) {
            int groupDefPriority;
            String groupName = groupDefinition.getName(groupId);
            if (groupName == null || (groupDefPriority = groupDefinition.getPriority()) <= priority) continue;
            bestMatch = groupName;
            priority = groupDefPriority;
        }
        return bestMatch;
    }

    @Override
    public boolean hasGroupDefinitions() {
        return this.groupDefinitions != null && !this.groupDefinitions.isEmpty();
    }
}

