/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.maven.annomojo.extractor;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.tools.apt.Main;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;
import org.jfrog.maven.annomojo.extractor.Maven20Helper;
import org.jfrog.maven.annomojo.extractor.MavenHelper;
import org.jfrog.maven.annomojo.extractor.MojoApf;
import org.jfrog.maven.annomojo.extractor.MojoDescriptorTls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnoMojoDescriptorExtractor
extends AbstractLogEnabled
implements MojoDescriptorExtractor,
Contextualizable {
    protected PlexusContainer container;
    private MavenHelper helper;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
        try {
            this.helper = new Maven20Helper(this.container);
        }
        catch (ComponentLookupException e) {
            throw new ContextException("Failed to configure the extractor Maven helper.", (Throwable)e);
        }
    }

    public List<MojoDescriptor> execute(PluginToolsRequest pluginToolsRequest) throws ExtractionException, InvalidPluginDescriptorException {
        List<MojoDescriptor> list = this.execute(pluginToolsRequest.getProject(), pluginToolsRequest.getPluginDescriptor());
        return list;
    }

    public List<MojoDescriptor> execute(MavenProject project, PluginDescriptor pluginDescriptor) throws InvalidPluginDescriptorException {
        URL[] urls;
        List compileClasspathElements;
        List sourceRoots = project.getCompileSourceRoots();
        HashSet<String> sourcePathElements = new HashSet<String>();
        String srcRoot = null;
        try {
            Iterator i$ = sourceRoots.iterator();
            while (i$.hasNext()) {
                String sourceRoot;
                srcRoot = sourceRoot = (String)i$.next();
                List files = FileUtils.getFiles((File)new File(srcRoot), (String)"**/*.java", null, (boolean)true);
                for (File file : files) {
                    String path = file.getPath();
                    sourcePathElements.add(path);
                }
            }
        }
        catch (Exception e) {
            throw new InvalidPluginDescriptorException("Failed to get source files from " + srcRoot, (Throwable)e);
        }
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("-nocompile");
        argsList.add("-cp");
        StringBuilder cp = new StringBuilder();
        try {
            compileClasspathElements = project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new InvalidPluginDescriptorException("Failed to get compileClasspathElements.", (Throwable)e);
        }
        for (String ccpe : compileClasspathElements) {
            this.appendToPath(cp, ccpe);
        }
        this.resolveDependencies(project, cp);
        for (URL url : urls = ((URLClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getURLs()) {
            String path;
            try {
                path = url.getPath();
            }
            catch (Exception e) {
                throw new InvalidPluginDescriptorException("Failed to get classpath files from " + url, (Throwable)e);
            }
            this.appendToPath(cp, path);
        }
        String classpath = cp.toString();
        this.debug("cl=" + classpath);
        argsList.add(classpath);
        argsList.addAll(sourcePathElements);
        String[] args = argsList.toArray(new String[argsList.size()]);
        ArrayList<MojoDescriptor> descriptors = new ArrayList<MojoDescriptor>();
        MojoDescriptorTls.setDescriptors(descriptors);
        try {
            Main.process((AnnotationProcessorFactory)new MojoApf(pluginDescriptor), (PrintWriter)new PrintWriter(System.out), (String[])args);
        }
        catch (Throwable t) {
            throw new InvalidPluginDescriptorException("Failed to extract plugin descriptor.", t);
        }
        return MojoDescriptorTls.getDescriptors();
    }

    private void debug(String msg) {
        Logger log = this.getLogger();
        if (log != null) {
            log.debug(msg);
        } else {
            System.out.println(msg);
        }
    }

    private void appendToPath(StringBuilder cp, String path) {
        if (path != null && path.length() > 0) {
            cp.append(path);
            cp.append(File.pathSeparator);
        }
    }

    private void resolveDependencies(MavenProject project, StringBuilder cp) throws InvalidPluginDescriptorException {
        ArtifactMetadataSource artifactMetadataSource;
        ArtifactFactory artifactFactory;
        ArtifactRepository localRepository;
        ArtifactResolver resolver;
        if (this.container == null) {
            return;
        }
        try {
            resolver = (ArtifactResolver)this.container.lookup(ArtifactResolver.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new InvalidPluginDescriptorException("Failed to get the ArtifactResolver.", (Throwable)e);
        }
        try {
            localRepository = this.helper.getLocalRepository();
        }
        catch (Exception e) {
            throw new InvalidPluginDescriptorException("Failed to get the local repository.", (Throwable)e);
        }
        try {
            artifactFactory = (ArtifactFactory)this.container.lookup(ArtifactFactory.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new InvalidPluginDescriptorException("Failed to locate the artifact factory.", (Throwable)e);
        }
        try {
            artifactMetadataSource = (ArtifactMetadataSource)this.container.lookup(ArtifactMetadataSource.ROLE, "maven");
        }
        catch (ComponentLookupException e) {
            throw new InvalidPluginDescriptorException("Failed to locate the Artifact Metadata Source.", (Throwable)e);
        }
        ArtifactFilter filter = new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                String scope = artifact.getScope();
                return AnnoMojoDescriptorExtractor.this.filterFromScope(scope);
            }
        };
        HashSet<Artifact> toResolve = new HashSet<Artifact>();
        List dependencies = project.getDependencies();
        for (Dependency dependency : dependencies) {
            String scope = dependency.getScope();
            if (!this.filterFromScope(scope)) continue;
            Artifact artifact = artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), scope, dependency.getType());
            toResolve.add(artifact);
        }
        Map<String, Artifact> managedVersions = this.createManagedVersionMap(project, artifactFactory);
        try {
            ArtifactResolutionResult result = resolver.resolveTransitively(toResolve, project.getArtifact(), managedVersions, localRepository, project.getRemoteArtifactRepositories(), artifactMetadataSource, filter);
            Set artifacts = result.getArtifacts();
            for (Artifact artifact : artifacts) {
                File file = artifact.getFile();
                this.appendToPath(cp, file.getCanonicalPath());
            }
        }
        catch (Exception e) {
            throw new InvalidPluginDescriptorException("Failed to resolve transitively artifacts: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean filterFromScope(String scope) {
        return scope == null || !scope.equals("system") && !scope.equals("test") && !scope.equals("runtime");
    }

    private Map<String, Artifact> createManagedVersionMap(MavenProject project, ArtifactFactory artifactFactory) throws InvalidPluginDescriptorException {
        Map<String, Artifact> map;
        DependencyManagement dependencyManagement = project.getDependencyManagement();
        String projectId = project.getId();
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            for (Dependency d : dependencyManagement.getDependencies()) {
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new InvalidPluginDescriptorException("Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "' in project " + projectId + " : " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            map = Collections.emptyMap();
        }
        return map;
    }
}

