/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.maven.annomojo.extractor;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.RuntimeInfo;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jfrog.maven.annomojo.extractor.MavenHelper;

public class Maven20Helper
implements MavenHelper {
    private static final String userHome = System.getProperty("user.home");
    private static final File userMavenConfigurationHome = new File(userHome, ".m2");
    private static final String mavenHome = System.getProperty("maven.home");
    private static final File defaultUserSettingsFile = new File(userMavenConfigurationHome, "settings.xml");
    private static final File defaultGlobalSettingsFile = new File(mavenHome, "conf/settings.xml");
    private static final String ALT_USER_SETTINGS_XML_LOCATION = "org.apache.maven.user-settings";
    private static final String ALT_GLOBAL_SETTINGS_XML_LOCATION = "org.apache.maven.global-settings";
    String ALT_LOCAL_REPOSITORY_LOCATION = "maven.repo.local";
    File defaultUserLocalRepository = new File(userMavenConfigurationHome, "repository");
    private ArtifactRepositoryLayout repositoryLayout;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private MavenSettingsBuilder settingsBuilder;

    Maven20Helper(PlexusContainer container) throws ComponentLookupException {
        this.repositoryLayout = (ArtifactRepositoryLayout)container.lookup(ArtifactRepositoryLayout.ROLE);
        this.artifactRepositoryFactory = (ArtifactRepositoryFactory)container.lookup(ArtifactRepositoryFactory.ROLE);
        this.settingsBuilder = (MavenSettingsBuilder)container.lookup(MavenSettingsBuilder.ROLE);
    }

    public ArtifactRepository createLocalRepository(File directory) {
        String localRepositoryUrl = directory.getAbsolutePath();
        if (!localRepositoryUrl.startsWith("file:")) {
            localRepositoryUrl = "file://" + localRepositoryUrl;
        }
        return this.createRepository("local", localRepositoryUrl, false, true, "warn");
    }

    public ArtifactRepository createRepository(String repositoryId, String repositoryUrl, boolean offline, boolean updateSnapshots, String globalChecksumPolicy) {
        DefaultArtifactRepository localRepository = new DefaultArtifactRepository(repositoryId, repositoryUrl, this.repositoryLayout);
        boolean snapshotPolicySet = false;
        if (offline) {
            snapshotPolicySet = true;
        }
        if (!snapshotPolicySet && updateSnapshots) {
            this.artifactRepositoryFactory.setGlobalUpdatePolicy("always");
        }
        this.artifactRepositoryFactory.setGlobalChecksumPolicy(globalChecksumPolicy);
        return localRepository;
    }

    public Settings buildSettings(File userSettingsPath, File globalSettingsPath, boolean interactive, boolean offline, boolean usePluginRegistry, Boolean pluginUpdateOverride) throws Exception {
        Settings settings = this.buildSettings(userSettingsPath, globalSettingsPath, pluginUpdateOverride);
        if (offline) {
            settings.setOffline(true);
        }
        settings.setInteractiveMode(interactive);
        settings.setUsePluginRegistry(usePluginRegistry);
        return settings;
    }

    public Settings buildSettings(File userSettingsPath, File globalSettingsPath, Boolean pluginUpdateOverride) throws Exception {
        Settings settings;
        try {
            settings = this.settingsBuilder.buildSettings(userSettingsPath);
        }
        catch (IOException e) {
            throw new Exception("Error reading settings file", e);
        }
        catch (XmlPullParserException e) {
            throw new Exception(e.getMessage() + e.getDetail() + e.getLineNumber() + e.getColumnNumber());
        }
        RuntimeInfo runtimeInfo = new RuntimeInfo(settings);
        runtimeInfo.setPluginUpdateOverride(pluginUpdateOverride);
        settings.setRuntimeInfo(runtimeInfo);
        return settings;
    }

    public File getUserSettingsPath(String optionalSettingsPath) {
        File userSettingsPath = new File(System.getProperty(ALT_USER_SETTINGS_XML_LOCATION) + "");
        if (!userSettingsPath.exists()) {
            File optionalSettingsPathFile;
            userSettingsPath = optionalSettingsPath != null ? ((optionalSettingsPathFile = new File(optionalSettingsPath)).exists() ? optionalSettingsPathFile : defaultUserSettingsFile) : defaultUserSettingsFile;
        }
        return userSettingsPath;
    }

    public File getGlobalSettingsPath() {
        File globalSettingsFile = new File(System.getProperty(ALT_GLOBAL_SETTINGS_XML_LOCATION) + "");
        if (!globalSettingsFile.exists()) {
            globalSettingsFile = defaultGlobalSettingsFile;
        }
        return globalSettingsFile;
    }

    public String getLocalRepositoryPath(Settings settings) {
        String localRepositoryPath = System.getProperty(this.ALT_LOCAL_REPOSITORY_LOCATION);
        if (localRepositoryPath == null) {
            localRepositoryPath = settings.getLocalRepository();
        }
        if (localRepositoryPath == null) {
            localRepositoryPath = this.defaultUserLocalRepository.getAbsolutePath();
        }
        return localRepositoryPath;
    }

    public String getLocalRepositoryPath() throws Exception {
        return this.getLocalRepositoryPath(this.buildSettings(this.getUserSettingsPath(null), this.getGlobalSettingsPath(), false, true, false, Boolean.FALSE));
    }

    public ArtifactRepository getLocalRepository() throws Exception {
        return this.createLocalRepository(new File(this.getLocalRepositoryPath()));
    }
}

