/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.maven.plugins.jnlp;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;

public class ExclusionsFilter {
    private final List<String> excludePatterns;

    public ExclusionsFilter(List<String> excludes) {
        this.excludePatterns = excludes;
    }

    public boolean isExcluded(Artifact artifact) {
        if (this.excludePatterns == null || this.excludePatterns.isEmpty()) {
            return false;
        }
        for (String pattern : this.excludePatterns) {
            String[] excludePatternTokens = pattern.split(":");
            if (!this.matches(artifact, excludePatternTokens = StringUtils.stripAll((String[])excludePatternTokens))) continue;
            return true;
        }
        return false;
    }

    protected boolean matches(Artifact artifact, String[] pattern) {
        boolean result = false;
        if (pattern.length > 0) {
            boolean bl = result = pattern[0].equals("*") || artifact.getGroupId().equals(pattern[0]);
        }
        if (result && pattern.length > 1) {
            boolean bl = result = pattern[1].equals("*") || artifact.getArtifactId().equals(pattern[1]);
        }
        if (result && pattern.length > 2) {
            result = pattern[2].equals("*") || artifact.getVersion().equals(pattern[2]);
        }
        return result;
    }
}

