/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.maven.plugins.jnlp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class VelocityGenerator {
    private final String templateFilePath;
    private final File targetFile;
    private final Map<String, Object> context;
    private VelocityEngine velocityEngine;
    private File templateDirectory;

    public VelocityGenerator(String templateFilePath, File targetFile, Map<String, Object> context) {
        this.templateFilePath = templateFilePath;
        this.targetFile = targetFile;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException {
        Template template = this.getJnlpTemplate();
        FileWriter fos = new FileWriter(this.targetFile);
        try {
            VelocityContext context = this.createVelocityContext();
            template.merge((Context)context, (Writer)fos);
        }
        finally {
            fos.close();
        }
    }

    public void initialize() {
        Properties props = new Properties();
        props.setProperty("resource.loader", "file, class");
        props.setProperty("class.resource.loader.class", ClasspathResourceLoader.class.getName());
        if (this.templateDirectory != null) {
            props.setProperty("file.resource.loader.path", this.templateDirectory.getAbsolutePath());
        }
        try {
            this.velocityEngine = new VelocityEngine(props);
            this.velocityEngine.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private VelocityContext createVelocityContext() {
        return new VelocityContext(this.context);
    }

    private Template getJnlpTemplate() throws IOException {
        try {
            return this.velocityEngine.getTemplate(this.templateFilePath);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void setTemplateDirectory(File templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    public static class Builder {
        private final String templateFilePath;
        private final File targetFile;
        private Map<String, Object> context;
        private File templateDirectory;

        public Builder(String templateFilePath, File targetFile) {
            this.templateFilePath = templateFilePath;
            this.targetFile = targetFile;
        }

        public VelocityGenerator build() {
            VelocityGenerator generator = new VelocityGenerator(this.templateFilePath, this.targetFile, this.context);
            generator.setTemplateDirectory(this.templateDirectory);
            generator.initialize();
            return generator;
        }

        public Builder setContext(Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public Builder setTemplateDirectory(File templateDirectory) {
            this.templateDirectory = templateDirectory;
            return this;
        }
    }
}

