/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.io;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.jgrapht.Graph;
import org.jgrapht.io.AbstractBaseExporter;
import org.jgrapht.io.Attribute;
import org.jgrapht.io.AttributeType;
import org.jgrapht.io.ComponentAttributeProvider;
import org.jgrapht.io.ComponentNameProvider;
import org.jgrapht.io.EmptyComponentAttributeProvider;
import org.jgrapht.io.ExportException;
import org.jgrapht.io.GraphExporter;
import org.jgrapht.io.IntegerComponentNameProvider;

@Deprecated
public class JSONExporter<V, E>
extends AbstractBaseExporter<V, E>
implements GraphExporter<V, E> {
    private static final String CREATOR = "JGraphT JSON Exporter";
    private static final String VERSION = "1";
    private ComponentAttributeProvider<V> vertexAttributeProvider;
    private ComponentAttributeProvider<E> edgeAttributeProvider;

    public JSONExporter() {
        this(new IntegerComponentNameProvider());
    }

    public JSONExporter(ComponentNameProvider<V> vertexIDProvider) {
        this(vertexIDProvider, new EmptyComponentAttributeProvider(), new IntegerComponentNameProvider(), new EmptyComponentAttributeProvider());
    }

    public JSONExporter(ComponentNameProvider<V> vertexIDProvider, ComponentAttributeProvider<V> vertexAttributeProvider, ComponentNameProvider<E> edgeIDProvider, ComponentAttributeProvider<E> edgeAttributeProvider) {
        super(vertexIDProvider, edgeIDProvider);
        this.vertexAttributeProvider = Objects.requireNonNull(vertexAttributeProvider);
        this.edgeAttributeProvider = Objects.requireNonNull(edgeAttributeProvider);
    }

    @Override
    public void exportGraph(Graph<V, E> g, Writer writer) throws ExportException {
        this.export(g, writer);
    }

    private void export(Graph<V, E> g, Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        out.print('{');
        out.print(this.quoted("creator"));
        out.print(':');
        out.print(this.quoted(CREATOR));
        out.print(',');
        out.print(this.quoted("version"));
        out.print(':');
        out.print(this.quoted(VERSION));
        out.print(',');
        out.print(this.quoted("nodes"));
        out.print(':');
        out.print('[');
        boolean printComma = false;
        for (Object v : g.vertexSet()) {
            if (!printComma) {
                printComma = true;
            } else {
                out.print(',');
            }
            this.exportVertex(out, g, v);
        }
        out.print("]");
        out.print(',');
        out.print(this.quoted("edges"));
        out.print(':');
        out.print('[');
        printComma = false;
        for (Object e : g.edgeSet()) {
            if (!printComma) {
                printComma = true;
            } else {
                out.print(',');
            }
            this.exportEdge(out, g, e);
        }
        out.print("]");
        out.print('}');
        out.flush();
    }

    private void exportVertex(PrintWriter out, Graph<V, E> g, V v) {
        String vertexId = this.vertexIDProvider.getName(v);
        out.print('{');
        out.print(this.quoted("id"));
        out.print(':');
        out.print(this.quoted(vertexId));
        this.exportVertexAttributes(out, g, v);
        out.print('}');
    }

    private void exportEdge(PrintWriter out, Graph<V, E> g, E e) {
        String edgeId;
        Object source = g.getEdgeSource(e);
        String sourceId = this.vertexIDProvider.getName(source);
        Object target = g.getEdgeTarget(e);
        String targetId = this.vertexIDProvider.getName(target);
        out.print('{');
        boolean hasId = false;
        if (this.edgeIDProvider != null && (edgeId = this.edgeIDProvider.getName(e)) != null) {
            out.print(this.quoted("id"));
            out.print(':');
            out.print(this.quoted(edgeId));
            hasId = true;
        }
        if (hasId) {
            out.print(',');
        }
        out.print(this.quoted("source"));
        out.print(':');
        out.print(this.quoted(sourceId));
        out.print(',');
        out.print(this.quoted("target"));
        out.print(':');
        out.print(this.quoted(targetId));
        this.exportEdgeAttributes(out, g, e);
        out.print('}');
    }

    private void exportVertexAttributes(PrintWriter out, Graph<V, E> g, V v) {
        this.vertexAttributeProvider.getComponentAttributes(v).entrySet().stream().filter(e -> !((String)e.getKey()).equals("id")).forEach(entry -> {
            out.print(",");
            out.print(this.quoted((String)entry.getKey()));
            out.print(":");
            this.outputValue(out, (Attribute)entry.getValue());
        });
    }

    private void exportEdgeAttributes(PrintWriter out, Graph<V, E> g, E e) {
        HashSet<String> forbidden = new HashSet<String>(Arrays.asList("id", "source", "target"));
        this.edgeAttributeProvider.getComponentAttributes(e).entrySet().stream().filter(entry -> !forbidden.contains(entry.getKey())).forEach(entry -> {
            out.print(",");
            out.print(this.quoted((String)entry.getKey()));
            out.print(":");
            this.outputValue(out, (Attribute)entry.getValue());
        });
    }

    private void outputValue(PrintWriter out, Attribute value) {
        AttributeType type = value.getType();
        if (type.equals((Object)AttributeType.BOOLEAN)) {
            boolean booleanValue = Boolean.parseBoolean(value.getValue());
            out.print(booleanValue ? "true" : "false");
        } else if (type.equals((Object)AttributeType.INT)) {
            out.print(Integer.parseInt(value.getValue()));
        } else if (type.equals((Object)AttributeType.LONG)) {
            out.print(Long.parseLong(value.getValue()));
        } else if (type.equals((Object)AttributeType.FLOAT)) {
            float floatValue = Float.parseFloat(value.getValue());
            if (!Float.isFinite(floatValue)) {
                throw new IllegalArgumentException("Infinity and NaN not allowed in JSON");
            }
            out.print(floatValue);
        } else if (type.equals((Object)AttributeType.DOUBLE)) {
            double doubleValue = Double.parseDouble(value.getValue());
            if (!Double.isFinite(doubleValue)) {
                throw new IllegalArgumentException("Infinity and NaN not allowed in JSON");
            }
            out.print(doubleValue);
        } else {
            out.print(this.quoted(value.toString()));
        }
    }

    private String quoted(String s) {
        return "\"" + StringEscapeUtils.escapeJson((String)s) + "\"";
    }
}

