/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware;

import java.util.Map;
import java.util.Set;
import org.jutils.jhardware.info.HardwareFactory;
import org.jutils.jhardware.info.InfoType;
import org.jutils.jhardware.model.BiosInfo;
import org.jutils.jhardware.model.DisplayInfo;
import org.jutils.jhardware.model.GraphicsCardInfo;
import org.jutils.jhardware.model.MemoryInfo;
import org.jutils.jhardware.model.MotherboardInfo;
import org.jutils.jhardware.model.NetworkInfo;
import org.jutils.jhardware.model.OSInfo;
import org.jutils.jhardware.model.ProcessorInfo;

public class HardwareInfo {
    private HardwareInfo() {
    }

    public static ProcessorInfo getProcessorInfo() {
        return (ProcessorInfo)HardwareFactory.get(InfoType.PROCESSOR).getInfo();
    }

    public static MemoryInfo getMemoryInfo() {
        return (MemoryInfo)HardwareFactory.get(InfoType.MEMORY).getInfo();
    }

    public static BiosInfo getBiosInfo() {
        return (BiosInfo)HardwareFactory.get(InfoType.BIOS).getInfo();
    }

    public static MotherboardInfo getMotherboardInfo() {
        return (MotherboardInfo)HardwareFactory.get(InfoType.MOTHERBOARD).getInfo();
    }

    public static OSInfo getOSInfo() {
        return (OSInfo)HardwareFactory.get(InfoType.OS).getInfo();
    }

    public static NetworkInfo getNetworkInfo() {
        return (NetworkInfo)HardwareFactory.get(InfoType.NETWORK).getInfo();
    }

    public static DisplayInfo getDisplayInfo() {
        return (DisplayInfo)HardwareFactory.get(InfoType.DISPLAY).getInfo();
    }

    public static GraphicsCardInfo getGraphicsCardInfo() {
        return (GraphicsCardInfo)HardwareFactory.get(InfoType.GRAPHICSCARD).getInfo();
    }

    public static void main(String[] args) {
        ProcessorInfo info = HardwareInfo.getProcessorInfo();
        System.out.println("Cache size: " + info.getCacheSize());
        System.out.println("Family: " + info.getFamily());
        System.out.println("Speed (Mhz): " + info.getMhz());
        System.out.println("Model: " + info.getModel());
        System.out.println("Model name: " + info.getModelName());
        System.out.println("Number of cores: " + info.getNumCores());
        System.out.println("Stepping: " + info.getStepping());
        System.out.println("Temperature: " + info.getTemperature());
        System.out.println("Vendor Id: " + info.getVendorId());
        Set<Map.Entry<String, String>> fullInfos = info.getFullInfo().entrySet();
        fullInfos.stream().forEach(fullInfo -> System.out.println((String)fullInfo.getKey() + ": " + (String)fullInfo.getValue()));
    }
}

