/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.os.unix;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.jutils.jhardware.info.os.AbstractOSInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

public final class UnixOSInfo
extends AbstractOSInfo {
    private static final String OS_RELEASE = "/etc/os-release";
    private static final String LINE_BREAK_REGEX = "\\r?\\n";

    private static String getOSLsbReleaseData() {
        String fullData = "";
        fullData = fullData + HardwareInfoUtils.executeCommand("lsb_release", "-a");
        return fullData;
    }

    private static String getOSStartTimeData() {
        String fullData = "";
        fullData = fullData + HardwareInfoUtils.executeCommand("last", "-x");
        return fullData;
    }

    private static String getOSReleaseData() {
        StringBuilder buffer = new StringBuilder();
        try (Stream<String> streamProcessorInfo = HardwareInfoUtils.readFile(OS_RELEASE);){
            streamProcessorInfo.forEach(line -> buffer.append((String)line).append("\r\n"));
        }
        return buffer.toString();
    }

    @Override
    protected Map<String, String> parseInfo() {
        String[] dataStringLines;
        HashMap<String, String> osDataMap = new HashMap<String, String>();
        String lsbRelease = UnixOSInfo.getOSLsbReleaseData();
        for (String dataLine : dataStringLines = lsbRelease.split(LINE_BREAK_REGEX)) {
            String[] dataStringInfo = dataLine.split(":");
            osDataMap.put(dataStringInfo[0].trim(), dataStringInfo.length == 2 ? dataStringInfo[1].trim() : "");
        }
        String osRelease = UnixOSInfo.getOSReleaseData();
        for (String dataLine : dataStringLines = osRelease.split(LINE_BREAK_REGEX)) {
            String[] dataStringInfo = dataLine.split("=");
            osDataMap.put(HardwareInfoUtils.toCamelCase("OS_" + dataStringInfo[0].trim()), dataStringInfo.length == 2 ? dataStringInfo[1].trim().replaceAll("\"", "") : "");
        }
        String startTimeFullData = UnixOSInfo.getOSStartTimeData();
        for (String dataLine : dataStringLines = startTimeFullData.split(LINE_BREAK_REGEX)) {
            if (!dataLine.startsWith("reboot")) continue;
            osDataMap.put("LastBootTime", UnixOSInfo.normalizeBootUpDate(dataLine.substring(39, 55)));
            break;
        }
        osDataMap.put("Manufacturer", (String)osDataMap.get("Distributor ID"));
        osDataMap.put("Name", (String)osDataMap.get("Description"));
        osDataMap.put("Version", (String)osDataMap.get("Release"));
        return osDataMap;
    }

    private static String normalizeBootUpDate(String rawBootUpdate) {
        Date returnedDate;
        SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd kk:mm yyyy", Locale.ENGLISH);
        try {
            returnedDate = df.parse(rawBootUpdate + " " + Calendar.getInstance().get(1));
        }
        catch (ParseException pe) {
            return rawBootUpdate;
        }
        return returnedDate.toString();
    }
}

