/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.processor.windows;

import com.profesorfalken.wmi4java.WMI4Java;
import com.profesorfalken.wmi4java.WMIClass;
import java.util.Map;
import org.jutils.jhardware.info.processor.AbstractProcessorInfo;
import org.jutils.jhardware.util.TemperatureUtils;

public final class WindowsProcessorInfo
extends AbstractProcessorInfo {
    @Override
    protected Map<String, String> parseInfo() {
        Map processorDataMap = WMI4Java.get().VBSEngine().getWMIObject(WMIClass.WIN32_PROCESSOR);
        String lineInfos = (String)processorDataMap.get("Description");
        String[] infos = lineInfos.split("\\s+");
        processorDataMap.put("cpu family", infos[2]);
        processorDataMap.put("model", infos[4]);
        processorDataMap.put("stepping", infos[6]);
        processorDataMap.put("model name", processorDataMap.get("Name"));
        processorDataMap.put("cpu MHz", processorDataMap.get("MaxClockSpeed"));
        processorDataMap.put("vendor_id", processorDataMap.get("Manufacturer"));
        processorDataMap.put("cpu cores", processorDataMap.get("NumberOfCores"));
        processorDataMap.put("temperature", TemperatureUtils.getCpuTemperatureForWindows());
        return processorDataMap;
    }
}

