/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.util.ArrayList;
import org.jibx.binding.model.AttributeBase;
import org.jibx.binding.model.ClassUtils;
import org.jibx.binding.model.CollectionElement;
import org.jibx.binding.model.ContainerElementBase;
import org.jibx.binding.model.IClass;
import org.jibx.binding.model.IClassItem;
import org.jibx.binding.model.ValidationContext;
import org.jibx.binding.util.StringArray;
import org.jibx.runtime.EnumSet;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.ITrackSourceImpl;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class PropertyAttributes
extends AttributeBase
implements ITrackSourceImpl {
    public static final StringArray s_allowedAttributes = new StringArray(new String[]{"field", "get-method", "set-method", "test-method", "type", "usage"});
    private static final String[] TEST_METHOD_SIGNATURES = new String[]{"(Lorg/jibx/runtime/IMarshallingContext;)Z", "()Z"};
    private static final String[] GET_METHOD_SIGNATURES = new String[]{"(Lorg/jibx/runtime/IMarshallingContext;)", "()"};
    public static final int REQUIRED_USAGE = 0;
    public static final int OPTIONAL_USAGE = 1;
    public static final int OPTIONAL_IN_USAGE = 2;
    public static final int OPTIONAL_OUT_USAGE = 3;
    private static final EnumSet s_usageEnum = new EnumSet(0, new String[]{"required", "optional", "opt-in", "opt-out"});
    private int m_usage;
    private String m_usageName = s_usageEnum.getName(0);
    private String m_declaredType;
    private String m_fieldName;
    private String m_testName;
    private String m_getName;
    private String m_setName;
    private IClass m_getType;
    private IClass m_setType;
    private IClass m_type;
    private IClassItem m_fieldItem;
    private IClassItem m_testItem;
    private IClassItem m_getItem;
    private IClassItem m_setItem;
    private boolean m_isImplicit;
    private /* synthetic */ String jibx_sourceDocument;
    private /* synthetic */ int jibx_sourceLine;
    private /* synthetic */ int jibx_sourceColumn;
    public static final String JiBX_bindingList = "|org.jibx.binding.model.JiBX_bindingFactory|";

    public String getUsageName() {
        return s_usageEnum.getName(this.m_usage);
    }

    public int getUsage() {
        return this.m_usage;
    }

    public void setUsageName(String name) {
        this.m_usageName = name;
    }

    public boolean hasProperty() {
        return !this.m_isImplicit && this.m_type != null;
    }

    public String getDeclaredType() {
        return this.m_declaredType;
    }

    public void setDeclaredType(String type) {
        this.m_declaredType = type;
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    public IClassItem getField() {
        return this.m_fieldItem;
    }

    public void setFieldName(String field) {
        this.m_fieldName = field;
    }

    public String getTestName() {
        return this.m_testName;
    }

    public IClassItem getTest() {
        return this.m_testItem;
    }

    public void setTestName(String test) {
        this.m_testName = test;
    }

    public String getGetName() {
        return this.m_getName;
    }

    public IClassItem getGet() {
        return this.m_getItem;
    }

    public IClass getGetType() {
        return this.m_getType;
    }

    public void setGetName(String get) {
        this.m_getName = get;
    }

    public String getSetName() {
        return this.m_setName;
    }

    public IClassItem getSet() {
        return this.m_setItem;
    }

    public IClass getSetType() {
        return this.m_setType;
    }

    public void setSetName(String set) {
        this.m_setName = set;
    }

    public IClass getType() {
        return this.m_type;
    }

    public boolean isImplicit() {
        return this.m_isImplicit;
    }

    public void prevalidate(ValidationContext vctx) {
        String tname;
        if (this.m_usageName != null) {
            this.m_usage = s_usageEnum.getValue(this.m_usageName);
            if (this.m_usage < 0) {
                vctx.addError("Value \"" + this.m_usageName + "\" is not a valid choice for usage");
            }
        } else {
            this.m_usage = vctx.getParentElement().getDefaultStyle();
        }
        ContainerElementBase parent = vctx.getParentContainer();
        IClass cobj = parent.getChildObjectType();
        String dtype = null;
        String gtype = null;
        String stype = null;
        boolean err = false;
        this.m_isImplicit = true;
        if (this.m_fieldName != null) {
            this.m_isImplicit = false;
            this.m_fieldItem = cobj.getField(this.m_fieldName);
            if (this.m_fieldItem == null) {
                vctx.addFatal("Nonstatic field " + this.m_fieldName + " not found in class " + cobj.getName());
                err = true;
            } else {
                gtype = stype = this.m_fieldItem.getTypeName();
                dtype = stype;
            }
        }
        if (this.m_testName != null) {
            if (this.m_usage == 0) {
                vctx.addError("test-method can only be used with optional property");
            } else {
                this.m_testItem = cobj.getMethod(this.m_testName, TEST_METHOD_SIGNATURES);
                if (this.m_testItem == null) {
                    vctx.addError("Nonstatic test-method " + this.m_testName + " not found in class " + cobj.getName());
                }
            }
        }
        if (this.m_getName != null) {
            this.m_isImplicit = false;
            this.m_getItem = cobj.getMethod(this.m_getName, GET_METHOD_SIGNATURES);
            if (this.m_getItem == null) {
                vctx.addFatal("Nonstatic get-method " + this.m_getName + " not found in class " + cobj.getName());
                err = true;
            } else {
                gtype = this.m_getItem.getTypeName();
                if (dtype == null) {
                    dtype = gtype;
                }
            }
            if (vctx.isInBinding() && this.m_fieldName == null && this.m_setName == null) {
                vctx.addError("Need field or set-method for input handling");
            }
        }
        if (this.m_setName != null) {
            String psig;
            this.m_isImplicit = false;
            ArrayList<String> sigs = new ArrayList<String>();
            if (this.m_getItem != null) {
                psig = ClassUtils.getSignature(gtype);
                sigs.add("(" + psig + "Lorg/jibx/runtime/IUnmarshallingContext;" + ")V");
                sigs.add("(" + psig + ")V");
            }
            if (this.m_declaredType != null) {
                psig = ClassUtils.getSignature(this.m_declaredType);
                sigs.add("(" + psig + "Lorg/jibx/runtime/IUnmarshallingContext;" + ")V");
                sigs.add("(" + psig + ")V");
            }
            if (this.m_fieldItem != null) {
                psig = this.m_fieldItem.getSignature();
                sigs.add("(" + psig + "Lorg/jibx/runtime/IUnmarshallingContext;" + ")V");
                sigs.add("(" + psig + ")V");
            }
            sigs.add("(Ljava/lang/Object;Lorg/jibx/runtime/IUnmarshallingContext;)V");
            sigs.add("(Ljava/lang/Object;)V");
            this.m_setItem = cobj.getMethod(this.m_setName, sigs.toArray(new String[0]));
            if (this.m_setItem == null && this.m_declaredType == null) {
                this.m_setItem = cobj.getMethod(this.m_setName, "");
                if (!(this.m_setItem == null || this.m_setItem.getArgumentCount() == 1 && this.m_setItem.getTypeName().equals("void"))) {
                    this.m_setItem = null;
                }
                if (this.m_setItem != null) {
                    String type = this.m_setItem.getArgumentType(0);
                    if (dtype != null && !ClassUtils.isAssignable(type, dtype, vctx)) {
                        this.m_setItem = null;
                    } else if (gtype != null && !ClassUtils.isAssignable(type, gtype, vctx)) {
                        this.m_setItem = null;
                    }
                    if (this.m_setItem != null) {
                        dtype = type;
                    }
                }
            }
            if (this.m_setItem == null) {
                vctx.addFatal("Nonstatic set-method " + this.m_setName + " with argument of appropriate type not found in class " + cobj.getName());
                err = true;
            } else {
                stype = this.m_setItem.getArgumentType(0);
                if (dtype == null) {
                    dtype = stype;
                }
            }
            if (vctx.isOutBinding() && this.m_fieldName == null && this.m_getName == null) {
                vctx.addError("Need field or get-method for output handling");
            }
        }
        if ((tname = this.m_declaredType) == null) {
            tname = dtype;
            if (tname == null) {
                tname = cobj.getName();
            }
        } else if (dtype == null) {
            gtype = stype = tname;
            dtype = stype;
        }
        this.m_type = vctx.getClassInfo(tname);
        if (this.m_type == null) {
            vctx.addFatal("Unable to load class " + tname);
        } else if (vctx.getContextObject() instanceof CollectionElement) {
            if (this.m_fieldName != null || this.m_getName != null || this.m_setName != null) {
                vctx.addWarning("Property access attributes (field, get-method, set-method) ignored for collection item");
            }
        } else if (!err && !this.m_isImplicit) {
            boolean valid = true;
            if (vctx.isInBinding()) {
                if (stype == null) {
                    vctx.addError("No way to set property value");
                    stype = "java.lang.Object";
                } else {
                    valid = ClassUtils.isAssignable(tname, stype, vctx) || ClassUtils.isAssignable(stype, tname, vctx);
                }
                this.m_setType = vctx.getClassInfo(stype);
            }
            if (gtype == null) {
                if (vctx.isOutBinding()) {
                    vctx.addError("No way to get property value");
                    this.m_getType = vctx.getClassInfo("java.lang.Object");
                }
            } else {
                if (valid) {
                    valid = ClassUtils.isAssignable(tname, gtype, vctx) || ClassUtils.isAssignable(gtype, tname, vctx);
                }
                this.m_getType = vctx.getClassInfo(gtype);
            }
            if (!valid) {
                vctx.addError("Incompatible types used in property definition");
            }
        }
        super.prevalidate(vctx);
    }

    public /* synthetic */ void jibx_setSource(String arg1, int arg2, int arg3) {
        this.jibx_sourceDocument = arg1;
        this.jibx_sourceLine = arg2;
        this.jibx_sourceColumn = arg3;
    }

    public /* synthetic */ String jibx_getDocumentName() {
        return this.jibx_sourceDocument;
    }

    public /* synthetic */ int jibx_getLineNumber() {
        return this.jibx_sourceLine;
    }

    public /* synthetic */ int jibx_getColumnNumber() {
        return this.jibx_sourceColumn;
    }

    public static /* synthetic */ PropertyAttributes JiBX_binding_newinstance_2_0(UnmarshallingContext arg1) throws JiBXException {
        return new PropertyAttributes();
    }

    public final /* synthetic */ PropertyAttributes JiBX_binding_unmarshalAttr_2_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushTrackedObject((Object)this);
        PropertyAttributes propertyAttributes = this;
        this.m_fieldName = arg1.attributeText(null, "field", null);
        this.m_declaredType = arg1.attributeText(null, "type", null);
        this.m_testName = arg1.attributeText(null, "test-method", null);
        this.m_getName = arg1.attributeText(null, "get-method", null);
        this.m_setName = arg1.attributeText(null, "set-method", null);
        this.m_usageName = arg1.attributeText(null, "usage", "required");
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ void JiBX_binding_marshalAttr_2_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        if (this.m_fieldName != null) {
            marshallingContext = marshallingContext.attribute(0, "field", this.m_fieldName);
        }
        if (this.m_declaredType != null) {
            marshallingContext = marshallingContext.attribute(0, "type", this.m_declaredType);
        }
        if (this.m_testName != null) {
            marshallingContext = marshallingContext.attribute(0, "test-method", this.m_testName);
        }
        if (this.m_getName != null) {
            marshallingContext = marshallingContext.attribute(0, "get-method", this.m_getName);
        }
        if (this.m_setName != null) {
            marshallingContext = marshallingContext.attribute(0, "set-method", this.m_setName);
        }
        if (this.m_usageName != null) {
            String string = this.m_usageName;
            if (!Utility.isEqual((Object)string, (Object)"required")) {
                marshallingContext = marshallingContext.attribute(0, "usage", string);
            }
        }
        arg1.popObject();
    }
}

