/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.def.BindingBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.MappingBase;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.IncludeElement;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.ValidationContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;

public class Utility {
    private static final int COPY_BUFFER_SIZE = 1024;

    private Utility() {
    }

    private static byte[] getStreamData(InputStream is) throws IOException {
        int count;
        byte[] buff = new byte[1024];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((count = is.read(buff)) >= 0) {
            os.write(buff, 0, count);
        }
        return os.toByteArray();
    }

    private static void recursePathJars(String path, ArrayList paths) {
        try {
            Attributes attrs;
            String cpath;
            JarFile jfile = new JarFile(path, false);
            Manifest mfst = jfile.getManifest();
            if (mfst != null && (cpath = (String)(attrs = mfst.getMainAttributes()).get(Attributes.Name.CLASS_PATH)) != null) {
                int split;
                String base;
                if (File.separatorChar != '/') {
                    path = path.replace('/', File.separatorChar);
                }
                String string = base = (split = path.lastIndexOf(File.separatorChar)) >= 0 ? path.substring(0, split + 1) : "";
                while (cpath != null) {
                    String ipath;
                    String item;
                    split = cpath.indexOf(32);
                    if (split >= 0) {
                        item = cpath.substring(0, split);
                        cpath = cpath.substring(split + 1).trim();
                    } else {
                        item = cpath;
                        cpath = null;
                    }
                    if (paths.contains(ipath = base + item)) continue;
                    paths.add(ipath);
                    split = ipath.lastIndexOf(46);
                    if (split < 0 || !"jar".equalsIgnoreCase(ipath.substring(split + 1))) continue;
                    Utility.recursePathJars(ipath, paths);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String[] getClassPaths() {
        String path = System.getProperty("java.class.path");
        ArrayList<String> paths = new ArrayList<String>();
        int start = 0;
        while (path != null) {
            String item;
            int mark = path.indexOf(File.pathSeparatorChar, start);
            if (mark >= 0) {
                item = path.substring(start, mark);
            } else {
                item = path.substring(start);
                path = null;
            }
            if (!paths.contains(item)) {
                paths.add(item);
                int split = item.lastIndexOf(46);
                if (split >= 0 && "jar".equalsIgnoreCase(item.substring(split + 1))) {
                    Utility.recursePathJars(item, paths);
                }
            }
            start = mark + 1;
        }
        paths.add(".");
        String[] clsspths = new String[paths.size()];
        paths.toArray(clsspths);
        return clsspths;
    }

    public static String convertName(String name) {
        StringBuffer buff = new StringBuffer(name);
        for (int i = 0; i < buff.length(); ++i) {
            if (Character.isJavaIdentifierPart(buff.charAt(i))) continue;
            buff.setCharAt(i, '_');
        }
        return buff.toString();
    }

    public static String fileName(String path) {
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        int split = path.lastIndexOf(File.separatorChar);
        return path.substring(split + 1);
    }

    public static String bindingFromFileName(String fname) {
        String sname = fname;
        int split = sname.indexOf(46);
        if (split > 0) {
            sname = sname.substring(0, split);
        }
        return Utility.convertName(sname);
    }

    public static BindingElement validateBinding(String name, URL url, InputStream is) {
        try {
            ValidationContext vctx = BindingElement.newValidationContext();
            BindingElement root = BindingElement.validateBinding(name, url, is, vctx);
            if (vctx.getErrorCount() == 0 && vctx.getFatalCount() == 0) {
                return root;
            }
        }
        catch (JiBXException ex) {
            System.err.println("Unable to process binding " + name);
            ex.printStackTrace();
        }
        return null;
    }

    public static BindingDefinition loadBinding(String fname, String sname, InputStream istrm, URL url, boolean test) throws JiBXException, IOException {
        byte[] data = Utility.getStreamData(istrm);
        boolean valid = true;
        ClassFile cf = null;
        String tpack = null;
        String bname = null;
        if (test) {
            BindingElement root = Utility.validateBinding(fname, url, new ByteArrayInputStream(data));
            if (root == null) {
                valid = false;
            } else {
                cf = Utility.findMappedClass(root);
                tpack = root.getTargetPackage();
                if (tpack == null && cf != null) {
                    tpack = cf.getPackage();
                }
                bname = root.getName();
            }
        }
        if (valid) {
            try {
                ArrayList maps;
                UnmarshallingContext uctx = new UnmarshallingContext();
                uctx.setDocument((InputStream)new ByteArrayInputStream(data), fname, null);
                if (cf != null) {
                    if (bname == null) {
                        bname = sname;
                    }
                    BoundClass.setModify(cf.getRoot(), tpack, bname);
                }
                BindingDefinition bdef = BindingBuilder.unmarshalBindingDefinition(uctx, sname, url);
                if (!test && (maps = bdef.getDefinitionContext().getMappings()) != null) {
                    for (int i = 0; i < maps.size(); ++i) {
                        Object child = maps.get(i);
                        if (!(child instanceof MappingBase)) continue;
                        MappingBase mapbase = (MappingBase)child;
                        cf = mapbase.getBoundClass().getMungedFile();
                        if (mapbase.getBoundClass().isDirectAccess()) break;
                    }
                }
                File root = null;
                if (tpack == null) {
                    tpack = bdef.getDefaultPackage();
                }
                if (cf == null) {
                    root = ClassCache.getModifiablePath();
                    if (root == null) {
                        throw new IllegalStateException("Need modifiable directory on classpath for storing generated factory class file");
                    }
                    if (tpack == null) {
                        tpack = "";
                    }
                } else {
                    root = cf.getRoot();
                    if (tpack == null) {
                        tpack = cf.getPackage();
                    }
                }
                bdef.setFactoryLocation(tpack, root);
                return bdef;
            }
            catch (JiBXException e) {
                throw new JiBXException("\n*** Error during code generation for file '" + fname + "' - please enter a bug report for this error in Jira if " + "the problem is not listed as fixed on the online status " + "page ***\n", (Throwable)e);
            }
        }
        throw new JiBXException("Binding " + fname + " is unusable because of validation errors");
    }

    private static ClassFile findMappedClass(BindingElement root) {
        ArrayList childs = root.topChildren();
        if (childs != null) {
            for (int i = childs.size() - 1; i >= 0; --i) {
                BindingElement bind;
                MappingElementBase map;
                ClassFile cf;
                Object child = childs.get(i);
                if (!(child instanceof MappingElement ? !(cf = (map = (MappingElementBase)child).getHandledClass().getClassFile()).isInterface() && cf.isModifiable() : child instanceof IncludeElement && (bind = ((IncludeElement)child).getBinding()) != null && (cf = Utility.findMappedClass(bind)) != null)) continue;
                return cf;
            }
        }
        return null;
    }

    public static BindingDefinition loadFileBinding(String path, boolean valid) throws JiBXException, IOException {
        File file = new File(path);
        String fname = Utility.fileName(file.getAbsolutePath());
        String sname = Utility.bindingFromFileName(fname);
        return Utility.loadBinding(fname, sname, new FileInputStream(file), file.toURI().toURL(), valid);
    }
}

