/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.MarshalBuilder;
import org.jibx.binding.classes.UnmarshalBuilder;
import org.jibx.binding.def.BaseMappingWrapper;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.MappingReference;
import org.jibx.binding.def.NestedStructure;
import org.jibx.binding.def.PassThroughComponent;
import org.jibx.runtime.JiBXException;

public class ObjectBinding
extends PassThroughComponent
implements IComponent,
IContextObj {
    private static final String[] MARSHAL_HOOK_SIGNATURES = new String[]{"(Lorg/jibx/runtime/IMarshallingContext;)V", "(Ljava/lang/Object;)V", "()V"};
    private static final String[] FACTORY_HOOK_SIGNATURES = new String[]{"(Lorg/jibx/runtime/IUnmarshallingContext;)", "(Ljava/lang/Object;)", "()"};
    private static final String[] UNMARSHAL_HOOK_SIGNATURES = new String[]{"(Lorg/jibx/runtime/IUnmarshallingContext;)V", "(Ljava/lang/Object;)V", "()V"};
    private static final String UNMARSHAL_GETSTACKTOPMETHOD = "org.jibx.runtime.impl.UnmarshallingContext.getStackTop";
    private static final String MARSHAL_GETSTACKTOPMETHOD = "org.jibx.runtime.impl.MarshallingContext.getStackTop";
    private static final String GETSTACKTOP_SIGNATURE = "()Ljava/lang/Object;";
    private static final String MARSHALLING_CONTEXT = "org.jibx.runtime.impl.MarshallingContext";
    private static final String UNMARSHALLING_CONTEXT = "org.jibx.runtime.impl.UnmarshallingContext";
    private static final String UNMARSHAL_PARAMETER_SIGNATURE = "(Lorg/jibx/runtime/impl/UnmarshallingContext;)";
    private static final String UNMARSHAL_PUSHOBJECTMETHOD = "org.jibx.runtime.impl.UnmarshallingContext.pushObject";
    private static final String UNMARSHAL_PUSHTRACKEDOBJECTMETHOD = "org.jibx.runtime.impl.UnmarshallingContext.pushTrackedObject";
    private static final String MARSHAL_PUSHOBJECTMETHOD = "org.jibx.runtime.impl.MarshallingContext.pushObject";
    private static final String PUSHOBJECT_SIGNATURE = "(Ljava/lang/Object;)V";
    private static final String UNMARSHAL_POPOBJECTMETHOD = "org.jibx.runtime.impl.UnmarshallingContext.popObject";
    private static final String MARSHAL_POPOBJECTMETHOD = "org.jibx.runtime.impl.MarshallingContext.popObject";
    private static final String POPOBJECT_SIGNATURE = "()V";
    private static final String UNMARSHAL_PARAMETER_NORET_SIGNATURE = "(Lorg/jibx/runtime/impl/UnmarshallingContext;)V";
    private static final String MARSHAL_PARAMETER_NORET_SIGNATURE = "(Lorg/jibx/runtime/impl/MarshallingContext;)V";
    private static final String NEWINSTANCE_SUFFIX = "_newinstance";
    private static final String PREPARE_SUFFIX = "_prepare";
    private static final String COMPLETE_SUFFIX = "_complete";
    private static final String ATTR_PRESENCE_SUFFIX = "_attrTest";
    private static final String UNMARSHAL_ATTR_SUFFIX = "_unmarshalAttr";
    private static final String MARSHAL_ATTR_SUFFIX = "_marshalAttr";
    private static final String PRESENCE_SUFFIX = "_test";
    private static final String UNMARSHAL_SUFFIX = "_unmarshal";
    private static final String MARSHAL_SUFFIX = "_marshal";
    private static final Type UNMARSHALCONTEXT_TYPE = new ObjectType("org.jibx.runtime.impl.UnmarshallingContext");
    private static final Type[] UNMARSHALCONTEXT_ARGS = new Type[]{UNMARSHALCONTEXT_TYPE};
    private static final Type MARSHALCONTEXT_TYPE = new ObjectType("org.jibx.runtime.impl.MarshallingContext");
    private static final String SOURCE_TRACKING_INTERFACE = "org.jibx.runtime.impl.ITrackSourceImpl";
    private static final String SETSOURCE_METHODNAME = "jibx_setSource";
    private static final Type[] SETSOURCE_ARGS = new Type[]{Type.STRING, Type.INT, Type.INT};
    private static final String SOURCEDOCUMENT_FIELDNAME = "jibx_sourceDocument";
    private static final String SOURCELINE_FIELDNAME = "jibx_sourceLine";
    private static final String SOURCECOLUMN_FIELDNAME = "jibx_sourceColumn";
    private static final String SOURCENAME_METHODNAME = "jibx_getDocumentName";
    private static final String SOURCELINE_METHODNAME = "jibx_getLineNumber";
    private static final String SOURCECOLUMN_METHODNAME = "jibx_getColumnNumber";
    private static final Type[] EMPTY_ARGS = new Type[0];
    private final IContainer m_container;
    private BoundClass m_class;
    private final ClassItem m_factoryMethod;
    private final ClassItem m_preSetMethod;
    private final ClassItem m_postSetMethod;
    private final ClassItem m_preGetMethod;
    private final ClassFile m_createClass;
    private String m_createName;
    private boolean m_checkedComplete;
    private boolean m_checkedPrepare;
    private String m_completeName;
    private String m_prepareName;
    private ClassItem m_newInstanceMethod;
    private boolean m_lockAttributePresence;
    private boolean m_lockContentPresence;
    private boolean m_lockAttributeUnmarshal;
    private boolean m_lockAttributeMarshal;
    private boolean m_lockContentUnmarshal;
    private boolean m_lockContentMarshal;
    private String m_attributePresenceName;
    private String m_contentPresenceName;
    private String m_unmarshalSignature;
    private String m_unmarshalAttributeName;
    private String m_unmarshalContentName;
    private String m_marshalSignature;
    private String m_marshalAttributeName;
    private String m_marshalContentName;
    private ClassItem m_attributePresenceMethod;
    private ClassItem m_contentPresenceMethod;
    private ClassItem m_unmarshalAttributeMethod;
    private ClassItem m_unmarshalContentMethod;
    private ClassItem m_marshalAttributeMethod;
    private ClassItem m_marshalContentMethod;
    private IComponent m_idChild;
    private boolean m_fakeContent;
    private boolean m_mappingWrapper;

    public ObjectBinding(IContainer contain, IContextObj objc, String type, String fact, String pres, String posts, String pget, String ctype) throws JiBXException {
        this.m_container = contain;
        BoundClass ctxc = objc == null ? null : objc.getBoundClass();
        this.m_class = BoundClass.getInstance(type, ctxc);
        ClassFile cf = this.m_class.getClassFile();
        this.m_createClass = ctype == null ? cf : ClassCache.requireClassFile(ctype);
        if (fact == null) {
            this.m_factoryMethod = null;
        } else {
            int split = fact.lastIndexOf(46);
            if (split >= 0) {
                String cname = fact.substring(0, split);
                String mname = fact.substring(split + 1);
                ClassFile mcf = ClassCache.requireClassFile(cname);
                this.m_factoryMethod = mcf.getMethod(mname, FACTORY_HOOK_SIGNATURES);
                if (this.m_factoryMethod == null) {
                    throw new JiBXException("Factory method " + fact + " not found");
                }
                this.m_factoryMethod.makeAccessible(cf);
            } else {
                this.m_factoryMethod = null;
            }
            if (this.m_factoryMethod == null) {
                throw new JiBXException("Factory method " + fact + " not found.");
            }
        }
        if (pres == null) {
            this.m_preSetMethod = null;
        } else {
            this.m_preSetMethod = cf.getMethod(pres, UNMARSHAL_HOOK_SIGNATURES);
            if (this.m_preSetMethod == null) {
                throw new JiBXException("User method " + pres + " not found.");
            }
        }
        if (posts == null) {
            this.m_postSetMethod = null;
        } else {
            this.m_postSetMethod = cf.getMethod(posts, UNMARSHAL_HOOK_SIGNATURES);
            if (this.m_postSetMethod == null) {
                throw new JiBXException("User method " + posts + " not found.");
            }
        }
        if (pget == null) {
            this.m_preGetMethod = null;
        } else {
            this.m_preGetMethod = cf.getMethod(pget, MARSHAL_HOOK_SIGNATURES);
            if (this.m_preGetMethod == null) {
                throw new JiBXException("User method " + pget + " not found.");
            }
        }
    }

    private void genUserMethodCall(boolean in, ClassItem method, ContextMethodBuilder mb) {
        if (!method.isStatic()) {
            mb.loadObject();
        }
        if (method.getArgumentCount() > 0) {
            mb.loadContext();
            String type = method.getArgumentType(0);
            if ("java.lang.Object".equals(type)) {
                String name = in ? UNMARSHAL_GETSTACKTOPMETHOD : MARSHAL_GETSTACKTOPMETHOD;
                mb.appendCallVirtual(name, GETSTACKTOP_SIGNATURE);
            }
        }
        mb.appendCall(method);
        mb.addMethodExceptions(method);
    }

    private void genCreateMethod() throws JiBXException {
        if (!(this.m_newInstanceMethod != null || this.m_mappingWrapper && this.m_factoryMethod == null && this.m_preSetMethod == null)) {
            String name = this.m_container.getBindingRoot().getPrefix() + NEWINSTANCE_SUFFIX;
            ClassFile cf = this.m_class.getMungedFile();
            Type type = this.m_class.getClassFile().getType();
            ContextMethodBuilder mb = new ContextMethodBuilder(name, type, new Type[]{type, UNMARSHALCONTEXT_TYPE}, cf, 9, 0, this.m_class.getClassName(), 1, UNMARSHALLING_CONTEXT);
            mb.loadObject();
            BranchWrapper haveinst = mb.appendIFNONNULL(this);
            boolean haveobj = true;
            if (this.m_factoryMethod == null) {
                if (this.m_createClass.isArray()) {
                    mb.appendLoadConstant(16);
                    String tname = this.m_createClass.getName();
                    mb.appendCreateArray(tname.substring(0, tname.length() - 2));
                } else if (this.m_createClass.isInterface() || this.m_createClass.isAbstract()) {
                    mb.appendCreateNew("org.jibx.runtime.JiBXException");
                    mb.appendDUP();
                    mb.appendLoadConstant("Cannot create instance of interface or abstract class " + this.m_createClass.getName());
                    mb.appendCallInit("org.jibx.runtime.JiBXException", "(Ljava/lang/String;)V");
                    mb.appendThrow();
                    haveobj = false;
                } else {
                    ClassItem cons = this.m_createClass.getInitializerMethod(POPOBJECT_SIGNATURE);
                    if (cons == null) {
                        if (this.m_container.getBindingRoot().isAddConstructors()) {
                            this.m_createClass.addDefaultConstructor();
                        } else {
                            mb.appendCreateNew("org.jibx.runtime.JiBXException");
                            mb.appendDUP();
                            mb.appendLoadConstant("Cannot create instance of class " + this.m_createClass.getName() + " (no default constructor)");
                            mb.appendCallInit("org.jibx.runtime.JiBXException", "(Ljava/lang/String;)V");
                            mb.appendThrow();
                            haveobj = false;
                        }
                    } else {
                        cons.makeAccessible(this.m_class.getMungedFile());
                    }
                    if (haveobj) {
                        mb.appendCreateNew(this.m_createClass.getName());
                        mb.appendDUP();
                        mb.appendCallInit(this.m_createClass.getName(), POPOBJECT_SIGNATURE);
                    }
                }
            } else {
                this.genUserMethodCall(true, this.m_factoryMethod, mb);
                mb.appendCreateCast(this.m_factoryMethod.getTypeName(), this.m_class.getClassName());
            }
            if (haveobj) {
                mb.storeObject();
            }
            mb.targetNext(haveinst);
            mb.loadObject();
            mb.appendReturn(this.m_class.getClassName());
            this.m_newInstanceMethod = this.m_class.getUniqueMethod(mb).getItem();
        }
    }

    private void genPrepareMethod() throws JiBXException {
        if (!this.m_checkedPrepare) {
            this.m_checkedPrepare = true;
        }
    }

    private void genCompleteMethod() throws JiBXException {
        if (!this.m_checkedComplete) {
            this.m_checkedComplete = true;
        }
    }

    private void genTrackSourceCode() {
        ClassFile cf;
        if (this.m_class.isDirectAccess() && !(cf = this.m_class.getDirectMungedFile()).isAbstract() && cf.addInterface(SOURCE_TRACKING_INTERFACE)) {
            ClassItem srcname = cf.addPrivateField("java.lang.String;", SOURCEDOCUMENT_FIELDNAME);
            ClassItem srcline = cf.addPrivateField("int", SOURCELINE_FIELDNAME);
            ClassItem srccol = cf.addPrivateField("int", SOURCECOLUMN_FIELDNAME);
            ExceptionMethodBuilder mb = new ExceptionMethodBuilder(SETSOURCE_METHODNAME, (Type)Type.VOID, SETSOURCE_ARGS, cf, 1);
            mb.appendLoadLocal(0);
            mb.appendLoadLocal(1);
            mb.appendPutField(srcname);
            mb.appendLoadLocal(0);
            mb.appendLoadLocal(2);
            mb.appendPutField(srcline);
            mb.appendLoadLocal(0);
            mb.appendLoadLocal(3);
            mb.appendPutField(srccol);
            mb.appendReturn();
            mb.codeComplete(false);
            mb.addMethod();
            mb = new ExceptionMethodBuilder(SOURCENAME_METHODNAME, (Type)Type.STRING, EMPTY_ARGS, cf, 1);
            mb.appendLoadLocal(0);
            mb.appendGetField(srcname);
            mb.appendReturn((Type)Type.STRING);
            mb.codeComplete(false);
            mb.addMethod();
            mb = new ExceptionMethodBuilder(SOURCELINE_METHODNAME, (Type)Type.INT, EMPTY_ARGS, cf, 1);
            mb.appendLoadLocal(0);
            mb.appendGetField(srcline);
            mb.appendReturn("int");
            mb.codeComplete(false);
            mb.addMethod();
            mb = new ExceptionMethodBuilder(SOURCECOLUMN_METHODNAME, (Type)Type.INT, EMPTY_ARGS, cf, 1);
            mb.appendLoadLocal(0);
            mb.appendGetField(srccol);
            mb.appendReturn("int");
            mb.codeComplete(false);
            mb.addMethod();
        }
    }

    private void genAttributePresenceMethod() throws JiBXException {
        if (this.m_attributePresenceMethod == null) {
            String name = this.m_container.getBindingRoot().getPrefix() + ATTR_PRESENCE_SUFFIX;
            ContextMethodBuilder meth = new ContextMethodBuilder(name, (Type)Type.BOOLEAN, UNMARSHALCONTEXT_ARGS, this.m_class.getMungedFile(), 9, -1, null, 0, UNMARSHALLING_CONTEXT);
            this.m_attributePresenceName = meth.getFullName();
            this.m_component.genAttrPresentTest(meth);
            meth.appendReturn((Type)Type.BOOLEAN);
            if (this.m_lockAttributePresence) {
                this.m_attributePresenceMethod = this.m_class.getUniqueNamed(meth).getItem();
            } else {
                this.m_attributePresenceMethod = this.m_class.getUniqueMethod(meth).getItem();
                this.m_attributePresenceName = this.m_attributePresenceMethod.getFullName();
            }
        } else {
            this.m_lockAttributePresence = true;
        }
    }

    private void genUnmarshalAttributeMethod() throws JiBXException {
        if (this.m_unmarshalAttributeName == null) {
            String name = this.m_container.getBindingRoot().getPrefix() + UNMARSHAL_ATTR_SUFFIX;
            UnmarshalBuilder meth = new UnmarshalBuilder(name, this.m_class.getClassFile(), this.m_class.getMungedFile());
            this.m_unmarshalAttributeName = meth.getFullName();
            this.m_unmarshalSignature = meth.getSignature();
            if (this.m_preSetMethod != null) {
                meth.loadObject();
                this.genUserMethodCall(true, this.m_preSetMethod, meth);
            }
            meth.loadContext();
            meth.loadObject();
            meth.appendCallVirtual(UNMARSHAL_PUSHTRACKEDOBJECTMETHOD, PUSHOBJECT_SIGNATURE);
            meth.loadObject();
            this.m_component.genAttributeUnmarshal(meth);
            meth.loadContext();
            meth.appendCallVirtual(UNMARSHAL_POPOBJECTMETHOD, POPOBJECT_SIGNATURE);
            if (this.m_postSetMethod != null && !this.hasContent()) {
                this.genUserMethodCall(true, this.m_postSetMethod, meth);
            }
            meth.loadObject();
            meth.appendReturn(this.m_class.getClassFile().getName());
            if (this.m_lockAttributeUnmarshal) {
                this.m_unmarshalAttributeMethod = this.m_class.getUniqueNamed(meth).getItem();
            } else {
                this.m_unmarshalAttributeMethod = this.m_class.getUniqueMethod(meth).getItem();
                this.m_unmarshalAttributeName = this.m_unmarshalAttributeMethod.getFullName();
            }
        } else {
            this.m_lockAttributeUnmarshal = true;
        }
    }

    private void genMarshalAttributeMethod() throws JiBXException {
        if (this.m_marshalAttributeName == null) {
            String name = this.m_container.getBindingRoot().getPrefix() + MARSHAL_ATTR_SUFFIX;
            MarshalBuilder meth = new MarshalBuilder(name, this.m_class.getClassFile(), this.m_class.getMungedFile());
            this.m_marshalAttributeName = meth.getFullName();
            this.m_marshalSignature = meth.getSignature();
            if (this.m_preGetMethod != null) {
                this.genUserMethodCall(false, this.m_preGetMethod, meth);
            }
            meth.loadContext();
            meth.loadObject();
            meth.appendCallVirtual(MARSHAL_PUSHOBJECTMETHOD, PUSHOBJECT_SIGNATURE);
            meth.loadContext();
            this.m_component.genAttributeMarshal(meth);
            meth.loadContext();
            meth.appendCallVirtual(MARSHAL_POPOBJECTMETHOD, POPOBJECT_SIGNATURE);
            meth.appendReturn();
            if (this.m_lockAttributeMarshal) {
                this.m_marshalAttributeMethod = this.m_class.getUniqueNamed(meth).getItem();
            } else {
                this.m_marshalAttributeMethod = this.m_class.getUniqueMethod(meth).getItem();
                this.m_marshalAttributeName = this.m_marshalAttributeMethod.getFullName();
            }
        } else {
            this.m_lockAttributeMarshal = true;
        }
    }

    private void genContentPresenceMethod() throws JiBXException {
        if (this.m_contentPresenceMethod == null) {
            String name = this.m_container.getBindingRoot().getPrefix() + PRESENCE_SUFFIX;
            ContextMethodBuilder meth = new ContextMethodBuilder(name, (Type)Type.BOOLEAN, UNMARSHALCONTEXT_ARGS, this.m_class.getMungedFile(), 9, -1, null, 0, UNMARSHALLING_CONTEXT);
            this.m_contentPresenceName = meth.getFullName();
            if (this.m_fakeContent) {
                meth.appendLoadConstant(1);
            } else {
                this.m_component.genContentPresentTest(meth);
            }
            meth.appendReturn((Type)Type.BOOLEAN);
            if (this.m_lockContentPresence) {
                this.m_contentPresenceMethod = this.m_class.getUniqueNamed(meth).getItem();
            } else {
                this.m_contentPresenceMethod = this.m_class.getUniqueMethod(meth).getItem();
                this.m_contentPresenceName = this.m_contentPresenceMethod.getFullName();
            }
        } else {
            this.m_lockContentPresence = true;
        }
    }

    private void genUnmarshalContentMethod() throws JiBXException {
        if (this.m_unmarshalContentName == null) {
            String name = this.m_container.getBindingRoot().getPrefix() + UNMARSHAL_SUFFIX;
            UnmarshalBuilder meth = new UnmarshalBuilder(name, this.m_class.getClassFile(), this.m_class.getMungedFile());
            this.m_unmarshalContentName = meth.getFullName();
            this.m_unmarshalSignature = meth.getSignature();
            if (!this.hasAttribute() && this.m_preSetMethod != null) {
                meth.loadObject();
                this.genUserMethodCall(true, this.m_preSetMethod, meth);
            }
            meth.loadContext();
            meth.loadObject();
            String mname = this.hasAttribute() ? UNMARSHAL_PUSHOBJECTMETHOD : UNMARSHAL_PUSHTRACKEDOBJECTMETHOD;
            meth.appendCallVirtual(mname, PUSHOBJECT_SIGNATURE);
            meth.loadObject();
            if (!this.m_fakeContent) {
                this.m_component.genContentUnmarshal(meth);
            }
            meth.loadContext();
            meth.appendCallVirtual(UNMARSHAL_POPOBJECTMETHOD, POPOBJECT_SIGNATURE);
            if (this.m_postSetMethod != null) {
                this.genUserMethodCall(true, this.m_postSetMethod, meth);
            }
            meth.loadObject();
            meth.appendReturn(this.m_class.getClassFile().getName());
            if (this.m_lockContentUnmarshal) {
                this.m_unmarshalContentMethod = this.m_class.getUniqueNamed(meth).getItem();
            } else {
                this.m_unmarshalContentMethod = this.m_class.getUniqueMethod(meth).getItem();
                this.m_unmarshalContentName = this.m_unmarshalContentMethod.getFullName();
            }
        } else {
            this.m_lockContentUnmarshal = true;
        }
    }

    private void genMarshalContentMethod() throws JiBXException {
        if (this.m_marshalContentName == null) {
            String name = this.m_container.getBindingRoot().getPrefix() + MARSHAL_SUFFIX;
            MarshalBuilder meth = new MarshalBuilder(name, this.m_class.getClassFile(), this.m_class.getMungedFile());
            this.m_marshalContentName = meth.getFullName();
            this.m_marshalSignature = meth.getSignature();
            if (this.m_preGetMethod != null && !this.hasAttribute()) {
                this.genUserMethodCall(false, this.m_preGetMethod, meth);
            }
            meth.loadContext();
            meth.loadObject();
            meth.appendCallVirtual(MARSHAL_PUSHOBJECTMETHOD, PUSHOBJECT_SIGNATURE);
            meth.loadContext();
            if (!this.m_fakeContent) {
                this.m_component.genContentMarshal(meth);
            }
            meth.loadContext();
            meth.appendCallVirtual(MARSHAL_POPOBJECTMETHOD, POPOBJECT_SIGNATURE);
            meth.appendReturn();
            if (this.m_lockContentMarshal) {
                this.m_marshalContentMethod = this.m_class.getUniqueNamed(meth).getItem();
            } else {
                this.m_marshalContentMethod = this.m_class.getUniqueMethod(meth).getItem();
                this.m_marshalContentName = this.m_marshalContentMethod.getFullName();
            }
        } else {
            this.m_lockContentMarshal = true;
        }
    }

    public BoundClass getBoundClass() {
        return this.m_class;
    }

    public boolean setIdChild(IComponent child) {
        if (this.m_idChild == null) {
            this.m_idChild = child;
            return true;
        }
        return false;
    }

    public boolean isOptional() {
        return false;
    }

    public boolean hasContent() {
        return this.m_fakeContent || super.hasContent();
    }

    public void genAttrPresentTest(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_mappingWrapper) {
            super.genAttrPresentTest(mb);
        } else {
            if (this.m_attributePresenceMethod == null) {
                this.genAttributePresenceMethod();
            }
            mb.loadContext(UNMARSHALLING_CONTEXT);
            mb.appendCall(this.m_attributePresenceMethod);
        }
    }

    public void genContentPresentTest(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_mappingWrapper) {
            super.genContentPresentTest(mb);
        } else {
            if (this.m_contentPresenceMethod == null) {
                this.genContentPresenceMethod();
            }
            mb.loadContext(UNMARSHALLING_CONTEXT);
            mb.appendCall(this.m_contentPresenceMethod);
        }
    }

    public void genAttributeUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_mappingWrapper) {
            super.genAttributeUnmarshal(mb);
        } else {
            if (this.m_unmarshalAttributeMethod == null) {
                this.genUnmarshalAttributeMethod();
            }
            mb.loadContext(UNMARSHALLING_CONTEXT);
            mb.appendCallStatic(this.m_unmarshalAttributeName, this.m_unmarshalSignature);
        }
    }

    public void genAttributeMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_mappingWrapper) {
            super.genAttributeMarshal(mb);
        } else {
            if (this.m_marshalAttributeMethod == null) {
                this.genMarshalAttributeMethod();
            }
            mb.loadContext(MARSHALLING_CONTEXT);
            mb.appendCallStatic(this.m_marshalAttributeName, this.m_marshalSignature);
        }
    }

    public void genContentUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_mappingWrapper) {
            super.genContentUnmarshal(mb);
        } else {
            if (this.m_unmarshalContentMethod == null) {
                this.genUnmarshalContentMethod();
            }
            mb.loadContext(UNMARSHALLING_CONTEXT);
            mb.appendCallStatic(this.m_unmarshalContentName, this.m_unmarshalSignature);
        }
    }

    public void genContentMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_mappingWrapper) {
            super.genContentMarshal(mb);
        } else {
            if (this.m_marshalContentMethod == null) {
                this.genMarshalContentMethod();
            }
            mb.loadContext(MARSHALLING_CONTEXT);
            mb.appendCallStatic(this.m_marshalContentName, this.m_marshalSignature);
        }
    }

    public void genNewInstance(ContextMethodBuilder mb) throws JiBXException {
        this.genCreateMethod();
        if (this.m_newInstanceMethod == null) {
            super.genNewInstance(mb);
        } else {
            mb.loadContext(UNMARSHALLING_CONTEXT);
            mb.appendCall(this.m_newInstanceMethod);
        }
    }

    public String getType() {
        return this.m_class.getClassName();
    }

    public boolean hasId() {
        return this.m_idChild != null;
    }

    public void genLoadId(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_idChild == null) {
            throw new IllegalStateException("Internal error: no id defined");
        }
        this.m_idChild.genLoadId(mb);
    }

    public void setLinkages() throws JiBXException {
        NestedStructure struct;
        IComponent comp = this.m_component;
        MappingReference ref = null;
        if (comp instanceof NestedStructure && (struct = (NestedStructure)comp).isMappingReference()) {
            ref = (MappingReference)struct.getContents().get(0);
        }
        super.setLinkages();
        if (ref == null) {
            this.m_fakeContent = !super.hasAttribute() && !super.hasContent();
        } else {
            IComponent wrapped;
            IMapping mapping = ref.getMapping();
            if (mapping != null && mapping.getBoundType().equals(this.getType()) && (wrapped = ref.m_component) instanceof BaseMappingWrapper) {
                BaseMappingWrapper wrapper = (BaseMappingWrapper)wrapped;
                this.setWrappedComponent(wrapper.m_component);
                this.m_mappingWrapper = true;
            }
        }
        if (this.m_container.getBindingRoot().isTrackSource()) {
            this.genTrackSourceCode();
        }
    }

    public String getAttributeMarshalMethod() throws JiBXException {
        if (this.m_container.getBindingRoot().isOutput() && this.hasAttribute() && !this.m_mappingWrapper) {
            if (this.m_marshalAttributeMethod == null) {
                this.genMarshalAttributeMethod();
            }
            return this.m_marshalAttributeName;
        }
        return null;
    }

    public String getAttributePresentTestMethod() throws JiBXException {
        if (this.m_container.getBindingRoot().isInput() && this.hasAttribute() && !this.m_mappingWrapper) {
            if (this.m_attributePresenceMethod == null) {
                this.genAttributePresenceMethod();
            }
            return this.m_attributePresenceName;
        }
        return null;
    }

    public String getAttributeUnmarshalMethod() throws JiBXException {
        if (this.m_container.getBindingRoot().isInput() && this.hasAttribute() && !this.m_mappingWrapper) {
            if (this.m_unmarshalAttributeMethod == null) {
                this.genUnmarshalAttributeMethod();
            }
            return this.m_unmarshalAttributeName;
        }
        return null;
    }

    public String getCompleteMethod() throws JiBXException {
        this.genCompleteMethod();
        return this.m_completeName;
    }

    public String getContentMarshalMethod() throws JiBXException {
        if (this.m_container.getBindingRoot().isOutput() && this.hasContent() && !this.m_mappingWrapper) {
            if (this.m_marshalContentMethod == null) {
                this.genMarshalContentMethod();
            }
            return this.m_marshalContentName;
        }
        return null;
    }

    public String getContentPresentTestMethod() throws JiBXException {
        if (this.m_container.getBindingRoot().isInput() && this.hasContent() && !this.m_mappingWrapper) {
            if (this.m_contentPresenceMethod == null) {
                this.genContentPresenceMethod();
            }
            return this.m_contentPresenceName;
        }
        return null;
    }

    public String getContentUnmarshalMethod() throws JiBXException {
        if (this.m_container.getBindingRoot().isInput() && this.hasContent() && !this.m_mappingWrapper) {
            if (this.m_unmarshalContentMethod == null) {
                this.genUnmarshalContentMethod();
            }
            return this.m_unmarshalContentName;
        }
        return null;
    }

    public String getCreateMethod() throws JiBXException {
        if (this.m_container.getBindingRoot().isInput() && !this.m_mappingWrapper) {
            this.genCreateMethod();
            return this.m_newInstanceMethod.getFullName();
        }
        return null;
    }

    public String getPrepareMethod() throws JiBXException {
        this.genPrepareMethod();
        return this.m_prepareName;
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("object binding for " + this.m_class.getClassFile().getName());
        if (this.m_createClass != null) {
            System.out.print(" create class " + this.m_createClass.getName());
        }
        if (this.m_factoryMethod != null) {
            System.out.print(" factory=" + this.m_factoryMethod.getName());
        }
        if (this.m_preSetMethod != null) {
            System.out.print(" preset=" + this.m_preSetMethod.getName());
        }
        if (this.m_postSetMethod != null) {
            System.out.print(" postset=" + this.m_postSetMethod.getName());
        }
        if (this.m_preGetMethod != null) {
            System.out.print(" preget=" + this.m_preGetMethod.getName());
        }
        if (this.m_mappingWrapper) {
            System.out.print(" (mapping wrapper)");
        }
        System.out.println();
        this.m_component.print(depth + 1);
    }
}

