/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import org.jibx.runtime.impl.XMLWriterNamespaceBase;

public abstract class XMLWriterBase
extends XMLWriterNamespaceBase {
    protected boolean m_textSeen;
    protected boolean m_contentSeen;

    public XMLWriterBase(String[] stringArray) {
        super(stringArray);
    }

    protected abstract void writeMarkup(String var1) throws IOException;

    protected abstract void writeMarkup(char var1) throws IOException;

    protected abstract void writePrefix(int var1) throws IOException;

    protected abstract void writeAttributeText(String var1) throws IOException;

    protected abstract void indent(int var1) throws IOException;

    public void writeXMLDecl(String string, String string2, String string3) throws IOException {
        this.writeMarkup("<?xml version=\"");
        this.writeAttributeText(string);
        if (string2 != null) {
            this.writeMarkup("\" encoding=\"");
            this.writeAttributeText(string2);
        }
        if (string3 != null) {
            this.writeMarkup("\" standalone=\"");
            this.writeAttributeText(string3);
        }
        this.writeMarkup("\"?>");
    }

    public void startTagOpen(int n, String string) throws IOException {
        this.indent();
        this.writeMarkup('<');
        this.writePrefix(n);
        this.writeMarkup(string);
    }

    public void startTagNamespaces(int n, String string, int[] nArray, String[] stringArray) throws IOException {
        int[] nArray2 = this.openNamespaces(nArray, stringArray);
        this.startTagOpen(n, string);
        for (int i = 0; i < nArray2.length; ++i) {
            int n2 = nArray2[i];
            String string2 = this.getNamespacePrefix(n2);
            if (string2.length() > 0) {
                this.writeMarkup(" xmlns:");
                this.writeMarkup(string2);
                this.writeMarkup("=\"");
            } else {
                this.writeMarkup(" xmlns=\"");
            }
            this.writeAttributeText(this.getNamespaceUri(n2));
            this.writeMarkup('\"');
        }
    }

    public void addAttribute(int n, String string, String string2) throws IOException {
        this.writeMarkup(" ");
        this.writePrefix(n);
        this.writeMarkup(string);
        this.writeMarkup("=\"");
        this.writeAttributeText(string2);
        this.writeMarkup('\"');
    }

    public void closeStartTag() throws IOException {
        this.writeMarkup('>');
        this.incrementNesting();
        this.m_contentSeen = false;
        this.m_textSeen = false;
    }

    public void closeEmptyTag() throws IOException {
        this.writeMarkup("/>");
        this.incrementNesting();
        this.decrementNesting();
        this.m_contentSeen = true;
    }

    public void startTagClosed(int n, String string) throws IOException {
        this.indent();
        this.writeMarkup('<');
        this.writePrefix(n);
        this.writeMarkup(string);
        this.writeMarkup('>');
        this.incrementNesting();
        this.m_contentSeen = false;
        this.m_textSeen = false;
    }

    public void endTag(int n, String string) throws IOException {
        if (this.m_contentSeen && !this.m_textSeen) {
            this.indent(-1);
        }
        this.writeMarkup("</");
        this.writePrefix(n);
        this.writeMarkup(string);
        this.writeMarkup('>');
        this.decrementNesting();
        this.m_textSeen = false;
        this.m_contentSeen = true;
    }

    public void writeComment(String string) throws IOException {
        this.writeMarkup("<!--");
        this.writeMarkup(string);
        this.writeMarkup("-->");
    }

    public void writeEntityRef(String string) throws IOException {
        this.writeMarkup('&');
        this.writeMarkup(string);
        this.writeMarkup(';');
        this.m_contentSeen = true;
    }

    public void writeDocType(String string, String string2, String string3, String string4) throws IOException {
        this.indent();
        this.writeMarkup("<!DOCTYPE ");
        this.writeMarkup(string);
        this.writeMarkup(' ');
        if (string2 != null) {
            if (string3 == null) {
                this.writeMarkup("SYSTEM \"");
                this.writeMarkup(string2);
            } else {
                this.writeMarkup("PUBLIC \"");
                this.writeMarkup(string3);
                this.writeMarkup("\" \"");
                this.writeMarkup(string2);
            }
            this.writeMarkup('\"');
        }
        if (string4 != null) {
            this.writeMarkup('[');
            this.writeMarkup(string4);
            this.writeMarkup(']');
        }
        this.writeMarkup('>');
    }

    public void writePI(String string, String string2) throws IOException {
        this.indent();
        this.writeMarkup("<?");
        this.writeMarkup(string);
        this.writeMarkup(' ');
        this.writeMarkup(string2);
        this.writeMarkup("?>");
        this.m_contentSeen = true;
    }

    public abstract void flush() throws IOException;

    public abstract void close() throws IOException;

    public void reset() {
        this.m_contentSeen = false;
        this.m_textSeen = false;
        super.reset();
    }
}

