/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.elements;

import java.io.IOException;
import org.jibx.runtime.JiBXException;
import org.jibx.schema.ISchemaResolver;
import org.jibx.schema.elements.SchemaElement;
import org.jibx.schema.elements.SchemaLocationBase;
import org.jibx.schema.validation.ValidationContext;

public abstract class SchemaLocationRequiredBase
extends SchemaLocationBase {
    protected SchemaLocationRequiredBase(int type) {
        super(type);
    }

    @Override
    public void prevalidate(ValidationContext vctx) {
        String location = this.getLocation();
        if (location == null) {
            vctx.addFatal("Missing required 'schemaLocation' value", this);
        } else {
            try {
                SchemaElement curschema = vctx.getCurrentSchema();
                ISchemaResolver resolver = curschema.getResolver().resolve(location, null);
                SchemaElement schema = vctx.getSchemaById(resolver.getId());
                if (schema == null) {
                    schema = this.readSchema(vctx, resolver);
                    vctx.setSchema(resolver.getId(), schema);
                    schema.setResolver(resolver);
                }
                this.setReferencedSchema(schema);
                if (schema.getEffectiveNamespace() == null) {
                    schema.setEffectiveNamespace(curschema.getEffectiveNamespace());
                }
            }
            catch (JiBXException e) {
                vctx.addFatal("Error loading schema: " + e.getMessage(), this);
            }
            catch (IOException e) {
                vctx.addFatal("Error loading schema: " + e.getMessage(), this);
            }
        }
        super.prevalidate(vctx);
    }
}

