/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.maven;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.oro.io.GlobFilenameFilter;
import org.jibx.binding.Compile;
import org.jibx.runtime.JiBXException;

public class CompileBindingMojo
extends AbstractMojo {
    private static final String DEFAULT_INCLUDES = "binding.xml";
    private String directory;
    private ArrayList excludes;
    private ArrayList includes;
    private boolean load;
    private HashSet modules;
    private boolean multimodule;
    private MavenProject project;
    private boolean validate;
    private boolean verbose;
    private boolean verify;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] classpaths;
        String[] bindings;
        String mode;
        this.checkConfiguration();
        if (this.isMultiModuleMode()) {
            mode = this.isRestrictedMultiModuleMode() ? "restricted multi-module" : "multi-module";
            bindings = this.getMultiModuleBindings();
            classpaths = this.getMultiModuleClasspaths();
        } else {
            mode = "single-module";
            bindings = this.getSingleModuleBindings();
            classpaths = this.getSingleModuleClasspaths();
        }
        if (bindings.length == 0) {
            this.getLog().info((CharSequence)("Not running JiBX binding compiler (" + mode + " mode) - no binding files"));
        } else {
            this.getLog().info((CharSequence)("Running JiBX binding compiler (" + mode + " mode) on " + bindings.length + " binding file(s)"));
            this.compile(classpaths, bindings);
        }
    }

    private void applyExcludePattern(Set bindingSet, File bindingdir) {
        Set matchedSet = this.matchPattern(bindingdir, this.excludes);
        bindingSet.removeAll(matchedSet);
    }

    private void applyIncludePattern(Set bindingSet, File bindingdir) {
        Set matchedSet = this.matchPattern(bindingdir, this.includes);
        bindingSet.addAll(matchedSet);
    }

    private void checkConfiguration() {
        if (this.includes == null || this.includes.size() == 0) {
            this.includes = new ArrayList();
            this.includes.add(DEFAULT_INCLUDES);
        }
        if (this.excludes == null) {
            this.excludes = new ArrayList();
        }
        if (this.modules != null && this.modules.size() > 0) {
            this.multimodule = true;
        } else {
            this.modules = null;
        }
    }

    private void compile(String[] classpaths, String[] bindings) throws MojoExecutionException {
        try {
            Compile compiler = new Compile();
            compiler.setLoad(this.load);
            compiler.setSkipValidate(!this.validate);
            compiler.setVerbose(this.verbose);
            compiler.setVerify(this.verify);
            compiler.compile(classpaths, bindings);
        }
        catch (JiBXException e) {
            Throwable cause = e.getRootCause() != null ? e.getRootCause() : e;
            throw new MojoExecutionException(cause.getLocalizedMessage(), cause);
        }
    }

    private Set matchPattern(File bindingdir, List wildcards) {
        HashSet<String> matchedSet = new HashSet<String>();
        Iterator iterator = wildcards.iterator();
        while (iterator.hasNext()) {
            String wildcard = (String)iterator.next();
            GlobFilenameFilter filter = new GlobFilenameFilter(wildcard);
            String[] bindings = bindingdir.list((FilenameFilter)filter);
            for (int i = 0; i < bindings.length; ++i) {
                String binding = bindingdir.getAbsolutePath() + File.separator + bindings[i];
                matchedSet.add(binding);
            }
        }
        return matchedSet;
    }

    private String[] normalizeClasspaths(Set classpathSet) {
        String[] classpaths = classpathSet.toArray(new String[classpathSet.size()]);
        for (int i = 0; i < classpaths.length; ++i) {
            classpaths[i] = FilenameUtils.normalize((String)classpaths[i]);
        }
        return classpaths;
    }

    private Set getBindings(String path) throws MojoExecutionException, MojoFailureException {
        HashSet bindingSet = new HashSet();
        File bindingdir = new File(path);
        if (!bindingdir.isDirectory()) {
            return bindingSet;
        }
        this.applyIncludePattern(bindingSet, bindingdir);
        this.applyExcludePattern(bindingSet, bindingdir);
        return bindingSet;
    }

    private String[] getMultiModuleBindings() throws MojoExecutionException, MojoFailureException {
        Set basedirSet = this.getProjectBasedirSet(this.project);
        HashSet bindingSet = new HashSet();
        Iterator iter = basedirSet.iterator();
        while (iter.hasNext()) {
            String basedir = (String)iter.next();
            bindingSet.addAll(this.getBindings(basedir + File.separator + this.directory));
        }
        return bindingSet.toArray(new String[bindingSet.size()]);
    }

    private String[] getMultiModuleClasspaths() throws MojoExecutionException, MojoFailureException {
        Set classpathSet = this.getProjectCompileClasspathElementsSet(this.project);
        return this.normalizeClasspaths(classpathSet);
    }

    private String getProjectBasedir(MavenProject project) {
        return FilenameUtils.normalize((String)project.getBasedir().getAbsolutePath());
    }

    private Set getProjectBasedirSet(MavenProject project) {
        HashSet<String> basedirSet = new HashSet<String>();
        basedirSet.add(this.getProjectBasedir(project));
        Collection projectReferences = project.getProjectReferences().values();
        Iterator iter = projectReferences.iterator();
        while (iter.hasNext()) {
            MavenProject projectReference = (MavenProject)iter.next();
            String projectId = projectReference.getGroupId() + ":" + projectReference.getArtifactId();
            if (this.modules != null && !this.modules.contains(projectId)) continue;
            basedirSet.add(this.getProjectBasedir(projectReference));
        }
        return basedirSet;
    }

    private Set getProjectCompileClasspathElements(MavenProject project) throws MojoExecutionException {
        try {
            return new HashSet(project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private Set getProjectCompileClasspathElementsSet(MavenProject project) throws MojoExecutionException {
        HashSet classpathElements = new HashSet();
        classpathElements.addAll(this.getProjectCompileClasspathElements(project));
        Collection projectReferences = project.getProjectReferences().values();
        Iterator iter = projectReferences.iterator();
        while (iter.hasNext()) {
            MavenProject projectReference = (MavenProject)iter.next();
            classpathElements.addAll(this.getProjectCompileClasspathElements(projectReference));
        }
        return classpathElements;
    }

    private String[] getSingleModuleBindings() throws MojoExecutionException, MojoFailureException {
        String basedir = this.getProjectBasedir(this.project);
        String bindingdir = basedir + File.separator + this.directory;
        Set bindingSet = this.getBindings(bindingdir);
        return bindingSet.toArray(new String[bindingSet.size()]);
    }

    private String[] getSingleModuleClasspaths() throws MojoExecutionException, MojoFailureException {
        Set classpathSet = this.getProjectCompileClasspathElements(this.project);
        return this.normalizeClasspaths(classpathSet);
    }

    private boolean isMultiModuleMode() {
        return this.multimodule;
    }

    private boolean isRestrictedMultiModuleMode() {
        return this.isMultiModuleMode() && this.modules != null;
    }

    private boolean isSingleModuleMode() {
        return !this.isMultiModuleMode();
    }
}

