/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.maven;

import java.io.File;
import java.io.FilenameFilter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.oro.io.GlobFilenameFilter;
import org.jibx.runtime.JiBXException;
import org.jibx.schema.codegen.CodeGen;

public class SchemaCodeGenMojo
extends AbstractMojo {
    private static final String DEFAULT_INCLUDES = "*.xsd";
    private String directory;
    private String targetDirectory;
    private ArrayList excludes;
    private ArrayList includes;
    private boolean verbose;
    private String defaultPackage = null;
    private ArrayList customizations;
    private Map options;
    private MavenProject project;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Throwable cause;
        this.checkConfiguration();
        ArrayList<String> args = new ArrayList<String>();
        Iterator iterator = this.options.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String option = "--" + entry.getKey() + "=" + entry.getValue();
            this.getLog().debug((CharSequence)("Adding option: " + option));
            args.add(option);
        }
        if (this.verbose) {
            args.add("-v");
        }
        if (this.defaultPackage != null) {
            args.add("-n");
            args.add(this.defaultPackage);
        }
        args.add("-t");
        args.add(this.targetDirectory);
        Set schemas = this.getSchemas(this.directory);
        Iterator iterator2 = schemas.iterator();
        while (iterator2.hasNext()) {
            String schema = (String)iterator2.next();
            args.add(new File(schema).toURI().toString());
        }
        if (this.customizations.size() > 0) {
            args.add("-c");
            iterator2 = ((AbstractList)this.customizations).iterator();
            while (iterator2.hasNext()) {
                String customization = (String)iterator2.next();
                args.add(customization);
            }
        }
        try {
            this.getLog().info((CharSequence)("Generating Java sources in " + this.targetDirectory + " from schemas available in " + this.directory + "..."));
            CodeGen.main((String[])args.toArray(new String[args.size()]));
        }
        catch (JiBXException e) {
            cause = e.getRootCause() != null ? e.getRootCause() : e;
            throw new MojoExecutionException(cause.getLocalizedMessage(), cause);
        }
        catch (Exception e) {
            cause = e.getCause() != null ? e.getCause() : e;
            throw new MojoExecutionException(cause.getLocalizedMessage(), cause);
        }
        this.getLog().debug((CharSequence)("Adding " + this.targetDirectory + " as source directory..."));
        this.project.addCompileSourceRoot(this.targetDirectory);
    }

    private void checkConfiguration() {
        if (this.includes == null || this.includes.size() == 0) {
            this.includes = new ArrayList();
            this.includes.add(DEFAULT_INCLUDES);
        }
        if (this.excludes == null) {
            this.excludes = new ArrayList();
        }
        if (this.customizations == null) {
            this.customizations = new ArrayList();
        }
        if (this.options == null) {
            this.options = new HashMap();
        }
    }

    private Set getSchemas(String path) throws MojoExecutionException, MojoFailureException {
        HashSet bindingSet = new HashSet();
        File bindingdir = new File(path);
        if (!bindingdir.isDirectory()) {
            return bindingSet;
        }
        this.applyIncludePattern(bindingSet, bindingdir);
        this.applyExcludePattern(bindingSet, bindingdir);
        return bindingSet;
    }

    private void applyExcludePattern(Set schemaSet, File schemaDir) {
        Set matchedSet = this.matchPattern(schemaDir, this.excludes);
        schemaSet.removeAll(matchedSet);
    }

    private void applyIncludePattern(Set schemaSet, File schemaDir) {
        Set matchedSet = this.matchPattern(schemaDir, this.includes);
        schemaSet.addAll(matchedSet);
    }

    private Set matchPattern(File schemaDir, List wildcards) {
        HashSet<String> matchedSet = new HashSet<String>();
        Iterator iterator = wildcards.iterator();
        while (iterator.hasNext()) {
            String wildcard = (String)iterator.next();
            GlobFilenameFilter filter = new GlobFilenameFilter(wildcard);
            String[] schemas = schemaDir.list((FilenameFilter)filter);
            for (int i = 0; i < schemas.length; ++i) {
                String schema = schemaDir.getAbsolutePath() + File.separator + schemas[i];
                this.getLog().info((CharSequence)("Using schema " + schema));
                matchedSet.add(schema);
            }
        }
        return matchedSet;
    }
}

