/*
 * Decompiled with CFR 0.152.
 */
package org.jipijapa.eclipselink;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.jpa.Archive;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSArchive
implements Archive {
    protected URL rootUrl;
    protected String descriptorLocation;
    protected VirtualFile root;
    protected Map<String, VirtualFile> files;

    public VFSArchive(URL rootUrl, String descriptorLocation) throws URISyntaxException, IOException {
        this.rootUrl = rootUrl;
        this.descriptorLocation = descriptorLocation;
        this.root = VFS.getChild((URI)rootUrl.toURI());
        List children = this.root.getChildrenRecursively(new VirtualFileFilter(){

            public boolean accepts(VirtualFile file) {
                return file.isFile();
            }
        });
        this.files = new HashMap<String, VirtualFile>();
        for (VirtualFile file : children) {
            this.files.put(file.getPathNameRelativeTo(this.root), file);
        }
    }

    public Iterator<String> getEntries() {
        return this.files.keySet().iterator();
    }

    public InputStream getEntry(String entryPath) throws IOException {
        return this.files.containsKey(entryPath) ? this.files.get(entryPath).openStream() : null;
    }

    public URL getEntryAsURL(String entryPath) throws IOException {
        return this.files.containsKey(entryPath) ? this.files.get(entryPath).asFileURL() : null;
    }

    public URL getRootURL() {
        return this.rootUrl;
    }

    public InputStream getDescriptorStream() throws IOException {
        return this.files.get(this.descriptorLocation).openStream();
    }

    public void close() {
    }
}

