/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.ConvertBean;
import jodd.typeconverter.TypeConverter;
import jodd.util.CsvUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanArrayConverter
implements TypeConverter<boolean[]> {
    protected final ConvertBean convertBean;

    public BooleanArrayConverter(ConvertBean convertBean) {
        this.convertBean = convertBean;
    }

    @Override
    public boolean[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (type == String.class) {
                Object[] values = CsvUtil.toStringArray(value.toString());
                return this.convertArray(values);
            }
            return new boolean[]{this.convertBean.toBooleanValue(value)};
        }
        if (type.getComponentType().isPrimitive()) {
            if (type == boolean[].class) {
                return (boolean[])value;
            }
            if (type == int[].class) {
                int[] values = (int[])value;
                boolean[] results = new boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i] != 0;
                }
                return results;
            }
            if (type == long[].class) {
                long[] values = (long[])value;
                boolean[] results = new boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i] != 0L;
                }
                return results;
            }
            if (type == double[].class) {
                double[] values = (double[])value;
                boolean[] results = new boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i] != 0.0;
                }
                return results;
            }
            if (type == float[].class) {
                float[] values = (float[])value;
                boolean[] results = new boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i] != 0.0f;
                }
                return results;
            }
            if (type == byte[].class) {
                byte[] values = (byte[])value;
                boolean[] results = new boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i] != 0;
                }
                return results;
            }
            if (type == short[].class) {
                short[] values = (short[])value;
                boolean[] results = new boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i] != 0;
                }
                return results;
            }
        }
        return this.convertArray((Object[])value);
    }

    private boolean[] convertArray(Object[] values) {
        boolean[] result = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.convertBean.toBooleanValue(values[i]);
        }
        return result;
    }
}

