/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.ConvertBean;
import jodd.typeconverter.TypeConverter;
import jodd.util.CsvUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortArrayConverter
implements TypeConverter<short[]> {
    protected final ConvertBean convertBean;

    public ShortArrayConverter(ConvertBean convertBean) {
        this.convertBean = convertBean;
    }

    @Override
    public short[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (type == String.class) {
                Object[] values = CsvUtil.toStringArray(value.toString());
                return this.convertArray(values);
            }
            return new short[]{this.convertBean.toShortValue(value)};
        }
        if (type.getComponentType().isPrimitive()) {
            if (type == short[].class) {
                return (short[])value;
            }
            if (type == int[].class) {
                int[] values = (int[])value;
                short[] results = new short[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (short)values[i];
                }
                return results;
            }
            if (type == long[].class) {
                long[] values = (long[])value;
                short[] results = new short[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (short)values[i];
                }
                return results;
            }
            if (type == double[].class) {
                double[] values = (double[])value;
                short[] results = new short[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (short)values[i];
                }
                return results;
            }
            if (type == byte[].class) {
                byte[] values = (byte[])value;
                short[] results = new short[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == float[].class) {
                float[] values = (float[])value;
                short[] results = new short[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (short)values[i];
                }
                return results;
            }
            if (type == boolean[].class) {
                boolean[] values = (boolean[])value;
                short[] results = new short[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (short)(values[i] ? 1 : 0);
                }
                return results;
            }
        }
        return this.convertArray((Object[])value);
    }

    protected short[] convertArray(Object[] values) {
        short[] results = new short[values.length];
        for (int i = 0; i < values.length; ++i) {
            results[i] = this.convertBean.toShortValue(values[i]);
        }
        return results;
    }
}

