/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import jodd.lagarto.Tag;
import jodd.lagarto.dom.Attribute;
import jodd.lagarto.dom.Node;

public class Element
extends Node {
    protected final boolean voidElement;
    protected final boolean selfClosed;

    public Element(Tag tag, boolean voidElement, boolean selfClosed, boolean caseSensitive) {
        super(Node.NodeType.ELEMENT, tag.getName(), caseSensitive);
        this.voidElement = voidElement;
        this.selfClosed = selfClosed;
        int attrCount = tag.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            String key = tag.getAttributeName(i);
            String value = tag.getAttributeValue(i);
            this.setAttribute(key, value);
        }
    }

    Element(String name) {
        this(name, false, false, false);
    }

    private Element(String name, boolean voidElement, boolean selfClosed, boolean caseSensitive) {
        super(Node.NodeType.ELEMENT, name, caseSensitive);
        this.voidElement = voidElement;
        this.selfClosed = selfClosed;
    }

    public Element clone() {
        return this.cloneTo(new Element(this.nodeName, this.voidElement, this.selfClosed, this.caseSensitive));
    }

    public boolean isVoidElement() {
        return this.voidElement;
    }

    public boolean isSelfClosed() {
        return this.selfClosed;
    }

    public void toHtml(Appendable appendable) throws IOException {
        appendable.append('<');
        appendable.append(this.nodeName);
        int attrCount = this.getAttributesCount();
        if (attrCount != 0) {
            for (int i = 0; i < attrCount; ++i) {
                Attribute attr = this.getAttribute(i);
                appendable.append(' ');
                attr.toHtml(appendable);
            }
        }
        int childCount = this.getChildNodesCount();
        if (this.selfClosed && childCount == 0) {
            appendable.append("/>");
            return;
        }
        appendable.append('>');
        if (this.voidElement) {
            return;
        }
        if (childCount != 0) {
            this.toInnerHtml(appendable);
        }
        appendable.append("</");
        appendable.append(this.nodeName);
        appendable.append('>');
    }

    public String toString() {
        return '<' + this.nodeName + '>';
    }
}

