/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.util.ArrayList;
import java.util.List;
import jodd.lagarto.dom.LagartoDomBuilderConfig;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Document
extends Node {
    protected long elapsedTime;
    protected final LagartoDomBuilderConfig config;
    protected List<String> errors;

    public Document() {
        this(new LagartoDomBuilderConfig());
    }

    public Document(LagartoDomBuilderConfig config) {
        super(null, Node.NodeType.DOCUMENT, null);
        this.config = config;
        this.elapsedTime = System.currentTimeMillis();
    }

    @Override
    public Document clone() {
        Document document = this.cloneTo(new Document(this.config));
        document.elapsedTime = this.elapsedTime;
        return document;
    }

    protected void end() {
        this.elapsedTime = System.currentTimeMillis() - this.elapsedTime;
    }

    @Override
    protected void visitNode(NodeVisitor nodeVisitor) {
        nodeVisitor.document(this);
    }

    public void addError(String message) {
        if (this.config.collectErrors) {
            if (this.errors == null) {
                this.errors = new ArrayList<String>();
            }
            this.errors.add(message);
        }
    }

    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public void setAttribute(String name, String value) {
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public LagartoDomBuilderConfig getConfig() {
        return this.config;
    }
}

