/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import jodd.lagarto.Doctype;
import jodd.lagarto.Tag;
import jodd.lagarto.TagType;
import jodd.lagarto.TagVisitor;
import jodd.lagarto.dom.CData;
import jodd.lagarto.dom.Comment;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.DocumentType;
import jodd.lagarto.dom.Element;
import jodd.lagarto.dom.HtmlCCommentExpressionMatcher;
import jodd.lagarto.dom.HtmlFosterRules;
import jodd.lagarto.dom.HtmlImplicitClosingRules;
import jodd.lagarto.dom.HtmlVoidRules;
import jodd.lagarto.dom.LagartoDOMBuilder;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.Text;
import jodd.lagarto.dom.XmlDeclaration;
import jodd.util.CharSequenceUtil;
import jodd.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LagartoDOMBuilderTagVisitor
implements TagVisitor {
    private static final Logger log = LoggerFactory.getLogger(LagartoDOMBuilderTagVisitor.class);
    protected final LagartoDOMBuilder domBuilder;
    protected final HtmlImplicitClosingRules implRules = new HtmlImplicitClosingRules();
    protected HtmlVoidRules htmlVoidRules;
    protected Document rootNode;
    protected Node parentNode;
    protected boolean enabled;
    protected HtmlCCommentExpressionMatcher htmlCCommentExpressionMatcher;

    public LagartoDOMBuilderTagVisitor(LagartoDOMBuilder domBuilder) {
        this.domBuilder = domBuilder;
    }

    public Document getDocument() {
        return this.rootNode;
    }

    @Override
    public void start() {
        if (this.rootNode == null) {
            this.rootNode = new Document(this.domBuilder.config);
        }
        this.parentNode = this.rootNode;
        this.enabled = true;
        if (this.domBuilder.config.isEnabledVoidTags()) {
            this.htmlVoidRules = new HtmlVoidRules();
        }
    }

    @Override
    public void end() {
        if (this.parentNode != this.rootNode) {
            Node thisNode = this.parentNode;
            while (thisNode != this.rootNode) {
                if (this.domBuilder.config.isImpliedEndTags() && this.implRules.implicitlyCloseTagOnEOF(thisNode.getNodeName())) {
                    thisNode = thisNode.getParentNode();
                    continue;
                }
                if (this.errorEnabled()) {
                    this.error("Unclosed tag closed: <" + thisNode.getNodeName() + ">");
                }
                thisNode = thisNode.getParentNode();
            }
        }
        if (this.domBuilder.config.isIgnoreWhitespacesBetweenTags()) {
            this.removeLastChildNodeIfEmptyText(this.parentNode, true);
        }
        if (this.domBuilder.config.isUseFosterRules()) {
            HtmlFosterRules fosterRules = new HtmlFosterRules();
            fosterRules.fixFosterElements(this.rootNode);
        }
        this.rootNode.end();
        if (log.isDebugEnabled()) {
            log.debug("LagartoDom tree created in " + this.rootNode.getElapsedTime() + " ms");
        }
    }

    protected Element createElementNode(Tag tag) {
        boolean hasVoidTags = this.htmlVoidRules != null;
        boolean isVoid = false;
        boolean selfClosed = false;
        if (hasVoidTags) {
            isVoid = this.htmlVoidRules.isVoidTag(tag.getName());
            if (isVoid) {
                selfClosed = this.domBuilder.config.isSelfCloseVoidTags();
            }
        } else {
            selfClosed = this.domBuilder.config.isSelfCloseVoidTags();
        }
        return new Element(this.rootNode, tag, isVoid, selfClosed);
    }

    @Override
    public void tag(Tag tag) {
        if (!this.enabled) {
            return;
        }
        TagType tagType = tag.getType();
        switch (tagType) {
            case START: {
                if (this.domBuilder.config.isIgnoreWhitespacesBetweenTags()) {
                    this.removeLastChildNodeIfEmptyText(this.parentNode, false);
                }
                Element node = this.createElementNode(tag);
                if (this.domBuilder.config.isImpliedEndTags()) {
                    String parentNodeName;
                    while (this.implRules.implicitlyCloseParentTagOnNewTag(parentNodeName = this.parentNode.getNodeName(), node.getNodeName())) {
                        this.parentNode = this.parentNode.getParentNode();
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Implicitly closed tag <" + node.getNodeName() + "> ");
                    }
                }
                this.parentNode.addChild((Node)node);
                if (node.isVoidElement()) break;
                this.parentNode = node;
                break;
            }
            case END: {
                String tagName;
                Node matchingParent;
                if (this.domBuilder.config.isIgnoreWhitespacesBetweenTags()) {
                    this.removeLastChildNodeIfEmptyText(this.parentNode, true);
                }
                if ((matchingParent = this.findMatchingParentOpenTag(tagName = tag.getName().toString())) == this.parentNode) {
                    this.parentNode = this.parentNode.getParentNode();
                    break;
                }
                if (matchingParent == null) {
                    if (!this.errorEnabled()) break;
                    this.error("Orphan closed tag ignored: </" + tagName + "> " + tag.getTagPosition());
                    break;
                }
                if (this.domBuilder.config.isImpliedEndTags()) {
                    boolean fixed = false;
                    while (this.implRules.implicitlyCloseParentTagOnTagEnd(this.parentNode.getNodeName(), tagName)) {
                        this.parentNode = this.parentNode.getParentNode();
                        if (log.isDebugEnabled()) {
                            log.debug("Implicitly closed tag <" + tagName + ">");
                        }
                        if (this.parentNode != matchingParent) continue;
                        this.parentNode = matchingParent.parentNode;
                        fixed = true;
                        break;
                    }
                    if (fixed) break;
                }
                this.fixUnclosedTagsUpToMatchingParent(tag, matchingParent);
                break;
            }
            case SELF_CLOSING: {
                if (this.domBuilder.config.isIgnoreWhitespacesBetweenTags()) {
                    this.removeLastChildNodeIfEmptyText(this.parentNode, false);
                }
                Element node = this.createElementNode(tag);
                this.parentNode.addChild((Node)node);
            }
        }
    }

    protected void removeLastChildNodeIfEmptyText(Node parentNode, boolean closedTag) {
        if (parentNode == null) {
            return;
        }
        Node lastChild = parentNode.getLastChild();
        if (lastChild == null) {
            return;
        }
        if (lastChild.getNodeType() != Node.NodeType.TEXT) {
            return;
        }
        if (closedTag && parentNode.getChildNodesCount() == 1) {
            return;
        }
        Text text = (Text)lastChild;
        if (text.isBlank()) {
            lastChild.detachFromParent();
        }
    }

    protected Node findMatchingParentOpenTag(String tagName) {
        Node parent = this.parentNode;
        if (!this.rootNode.config.parserConfig.isCaseSensitive()) {
            tagName = tagName.toLowerCase();
        }
        while (parent != null) {
            String parentNodeName = parent.getNodeName();
            if (parentNodeName != null && !this.rootNode.config.parserConfig.isCaseSensitive()) {
                parentNodeName = parentNodeName.toLowerCase();
            }
            if (tagName.equals(parentNodeName)) {
                return parent;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    protected void fixUnclosedTagsUpToMatchingParent(Tag tag, Node matchingParent) {
        if (this.domBuilder.config.isUnclosedTagAsOrphanCheck()) {
            if (!CharSequenceUtil.equalsIgnoreCase((CharSequence)tag.getName(), (CharSequence)"table")) {
                for (Node thisNode = this.parentNode; thisNode != matchingParent; thisNode = thisNode.getParentNode()) {
                    String thisNodeName = thisNode.getNodeName().toLowerCase();
                    if (!thisNodeName.equals("table") && !thisNodeName.equals("ul") && !thisNodeName.equals("ol")) continue;
                    String positionString = tag.getPosition();
                    if (positionString == null) {
                        positionString = "";
                    }
                    if (this.errorEnabled()) {
                        this.error("Orphan closed tag ignored: </" + tag.getName() + "> " + positionString);
                    }
                    return;
                }
            }
        }
        while (true) {
            if (this.parentNode == matchingParent) break;
            Node parentParentNode = this.parentNode.getParentNode();
            if (this.domBuilder.config.isImpliedEndTags() && this.implRules.implicitlyCloseParentTagOnNewTag(parentParentNode.getNodeName(), this.parentNode.getNodeName())) {
                this.parentNode.detachFromParent();
                parentParentNode.getParentNode().addChild(this.parentNode);
            }
            if (this.errorEnabled()) {
                this.error("Unclosed tag closed: <" + this.parentNode.getNodeName() + ">");
            }
            this.parentNode = parentParentNode;
        }
        this.parentNode = this.parentNode.getParentNode();
    }

    @Override
    public void script(Tag tag, CharSequence body) {
        if (!this.enabled) {
            return;
        }
        Element node = this.createElementNode(tag);
        this.parentNode.addChild((Node)node);
        if (body.length() != 0) {
            Text text = new Text(this.rootNode, body.toString());
            node.addChild((Node)text);
        }
    }

    @Override
    public void comment(CharSequence comment) {
        if (!this.enabled) {
            return;
        }
        if (this.domBuilder.config.isIgnoreWhitespacesBetweenTags()) {
            this.removeLastChildNodeIfEmptyText(this.parentNode, false);
        }
        if (this.domBuilder.config.isIgnoreComments()) {
            return;
        }
        Comment node = new Comment(this.rootNode, comment.toString());
        this.parentNode.addChild((Node)node);
    }

    @Override
    public void text(CharSequence text) {
        if (!this.enabled) {
            return;
        }
        String textValue = text.toString();
        Text node = new Text(this.rootNode, textValue);
        this.parentNode.addChild((Node)node);
    }

    @Override
    public void cdata(CharSequence cdata) {
        if (!this.enabled) {
            return;
        }
        CData cdataNode = new CData(this.rootNode, cdata.toString());
        this.parentNode.addChild((Node)cdataNode);
    }

    @Override
    public void xml(CharSequence version, CharSequence encoding, CharSequence standalone) {
        if (!this.enabled) {
            return;
        }
        XmlDeclaration xmlDeclaration = new XmlDeclaration(this.rootNode, version, encoding, standalone);
        this.parentNode.addChild((Node)xmlDeclaration);
    }

    @Override
    public void doctype(Doctype doctype) {
        if (!this.enabled) {
            return;
        }
        DocumentType documentType = new DocumentType(this.rootNode, Util.toString((Object)doctype.getName()), Util.toString((Object)doctype.getPublicIdentifier()), Util.toString((Object)doctype.getSystemIdentifier()));
        this.parentNode.addChild((Node)documentType);
    }

    @Override
    public void condComment(CharSequence expression, boolean isStartingTag, boolean isHidden, boolean isHiddenEndTag) {
        String expressionString = expression.toString().trim();
        if (expressionString.equals("endif")) {
            this.enabled = true;
            return;
        }
        if (expressionString.equals("if !IE")) {
            this.enabled = false;
            return;
        }
        float ieVersion = this.domBuilder.config.getCondCommentIEVersion();
        if (this.htmlCCommentExpressionMatcher == null) {
            this.htmlCCommentExpressionMatcher = new HtmlCCommentExpressionMatcher();
        }
        this.enabled = this.htmlCCommentExpressionMatcher.match(ieVersion, expressionString);
    }

    protected boolean errorEnabled() {
        return this.domBuilder.config.collectErrors || this.domBuilder.config.errorLogEnabled;
    }

    @Override
    public void error(String message) {
        this.rootNode.addError(message);
        if (this.domBuilder.config.errorLogEnabled) {
            this.domBuilder.config.getErrorLogConsumer().accept(log, message);
        }
    }
}

