/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.scopemapping;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import org.joinfaces.autoconfigure.scopemapping.CustomScopeAnnotationConfigurer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@AutoConfiguration
@ConditionalOnClass(value={RequestScoped.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class CdiScopeAnnotationsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"joinfaces.scope-configurer.cdi.enabled"}, havingValue="true", matchIfMissing=true)
    public static CustomScopeAnnotationConfigurer cdiScopeAnnotationsConfigurer(Environment environment) {
        CustomScopeAnnotationConfigurer scopeAnnotationConfigurer = new CustomScopeAnnotationConfigurer();
        scopeAnnotationConfigurer.setOrder((Integer)environment.getProperty("joinfaces.scope-configurer.cdi.order", Integer.class, (Object)Integer.MAX_VALUE));
        scopeAnnotationConfigurer.addMapping(RequestScoped.class, "request");
        scopeAnnotationConfigurer.addMapping(SessionScoped.class, "session");
        scopeAnnotationConfigurer.addMapping(ConversationScoped.class, "session");
        scopeAnnotationConfigurer.addMapping(ApplicationScoped.class, "application");
        return scopeAnnotationConfigurer;
    }
}

