/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import org.joinfaces.ClasspathScanUtil;
import org.joinfaces.autoconfigure.FacesAnnotationProviderUtil;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.ClassUtils;

public abstract class FacesAnnotationProviderAotProcessor
implements BeanFactoryInitializationAotProcessor {
    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        if (ClassUtils.isPresent((String)this.getSpiClassName(), (ClassLoader)FacesAnnotationProviderAotProcessor.class.getClassLoader())) {
            return new FacesAnnotationProviderAotContrib();
        }
        return null;
    }

    protected abstract String getSpiClassName();

    class FacesAnnotationProviderAotContrib
    implements BeanFactoryInitializationAotContribution {
        FacesAnnotationProviderAotContrib() {
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            String resourceName = "META-INF/joinfaces/" + FacesAnnotationProviderAotProcessor.this.getSpiClassName() + ".classes";
            try (ScanResult scanResult = new ClassGraph().enableAllInfo().enableExternalClasses().scan();){
                Map<Class<? extends Annotation>, Set<Class<?>>> annotatedClasses = FacesAnnotationProviderUtil.findAnnotatedClasses(scanResult);
                ClasspathScanUtil.writeClassMap((GenerationContext)generationContext, (String)resourceName, annotatedClasses);
            }
        }
    }
}

