/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.tomcat;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Enumeration;
import lombok.Generated;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.JarWarResourceSet;
import org.joinfaces.autoconfigure.tomcat.TomcatRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsfTomcatLifecycleListener
implements LifecycleListener {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsfTomcatLifecycleListener.class);
    private final Context context;

    private boolean isJarWarResourceSet(WebResourceSet resourceSet) {
        return resourceSet != null && resourceSet instanceof JarWarResourceSet;
    }

    private boolean isNestedJarResourceSet(WebResourceSet resourceSet) {
        return resourceSet != null && resourceSet.getClass().getSimpleName().equals("NestedJarResourceSet");
    }

    private boolean isDirResourceSetWithoutBootInfFolder(WebResourceSet resourceSet) {
        return resourceSet != null && resourceSet instanceof DirResourceSet && resourceSet.getBaseUrl() != null && resourceSet.getBaseUrl().getFile() != null && !resourceSet.getBaseUrl().getFile().contains("BOOT-INF");
    }

    private WebResourceSet findFirstWebResourceSet(WebResourceRoot resources, WebResourceSetCondition condition) {
        WebResourceSet result = null;
        for (WebResourceSet resourceSet : resources.getJarResources()) {
            if (!condition.check(resourceSet)) continue;
            result = resourceSet;
            break;
        }
        return result;
    }

    private WebResourceSet findFirstJarWarResourceSetOrNestedJarResourceSet(WebResourceRoot resources) {
        return this.findFirstWebResourceSet(resources, r -> this.isJarWarResourceSet(r) || this.isNestedJarResourceSet(r));
    }

    private WebResourceSet findFirstDirResourceSetWithoutBootInfFolder(WebResourceRoot resources) {
        return this.findFirstWebResourceSet(resources, r -> this.isDirResourceSetWithoutBootInfFolder(r));
    }

    private URL mainFile(WebResourceRoot resources) {
        URL result = null;
        WebResourceSet resourceSet = this.findFirstJarWarResourceSetOrNestedJarResourceSet(resources);
        if (resourceSet != null) {
            result = resourceSet.getBaseUrl();
        }
        return result;
    }

    private String base(URL url) throws URISyntaxException {
        String result;
        if (url.getProtocol().equals("nested")) {
            result = Paths.get(url.toURI()).toString();
            result = result.substring(0, result.indexOf("!BOOT-INF") - 1);
        } else if (url.getProtocol().equals("jar")) {
            result = url.getFile();
            result = result.substring("file:".length());
            result = result.substring(0, result.indexOf("!/"));
        } else {
            result = Paths.get(url.toURI()).toString();
        }
        return result;
    }

    private boolean isUberJar(WebResourceRoot resources) {
        return this.isUber(resources, ".jar", "/!BOOT-INF/");
    }

    private boolean isUberWar(WebResourceRoot resources) {
        return this.isUber(resources, ".war", "/!WEB-INF/");
    }

    private boolean isUber(WebResourceRoot resources, String suffix, String infFolder) {
        boolean result;
        WebResourceSet resourceSet = this.findFirstJarWarResourceSetOrNestedJarResourceSet(resources);
        boolean bl = result = resourceSet != null;
        if (result) {
            if (this.isJarWarResourceSet(resourceSet)) {
                result = resourceSet.getBaseUrl().getFile().endsWith(suffix);
            } else if (this.isNestedJarResourceSet(resourceSet)) {
                String file = resourceSet.getBaseUrl().getFile();
                int indexOfInf = file.indexOf(infFolder);
                boolean bl2 = result = indexOfInf != -1;
                if (result) {
                    file = file.substring(0, indexOfInf);
                    result = file.endsWith(suffix);
                }
            }
        }
        return result;
    }

    private boolean containsDirResourceSetWithoutBootInfFolder(WebResourceRoot resources) {
        return !this.isUberJar(resources) && !this.isUberWar(resources) && this.findFirstDirResourceSetWithoutBootInfFolder(resources) != null;
    }

    TomcatRuntime getTomcatRuntime(WebResourceRoot resources) {
        TomcatRuntime result = null;
        result = this.isUberJar(resources) ? TomcatRuntime.UBER_JAR : (this.isUberWar(resources) ? TomcatRuntime.UBER_WAR : TomcatRuntime.UNPACKAGED);
        return result;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        WebResourceRoot resources;
        if (event.getType().equals("configure_start") && (resources = this.context.getResources()) != null && resources.getJarResources() != null) {
            TomcatRuntime tomcatRuntime = this.getTomcatRuntime(resources);
            switch (tomcatRuntime) {
                case UBER_JAR: {
                    try {
                        this.addMainJarResourceSet(resources);
                    }
                    catch (URISyntaxException ex) {
                        log.error(ex.getMessage());
                    }
                    break;
                }
                case UBER_WAR: {
                    break;
                }
                case UNPACKAGED: {
                    if (this.containsDirResourceSetWithoutBootInfFolder(resources)) break;
                    try {
                        this.addClasspathResourceSets(resources);
                    }
                    catch (IOException | URISyntaxException ex) {
                        log.error(ex.getMessage());
                    }
                    break;
                }
            }
        }
    }

    private void addMainJarResourceSet(WebResourceRoot resources) throws URISyntaxException {
        String webAppMount = "/";
        String archivePath = null;
        String internalPath = "/META-INF/resources";
        String bootInfPath = "/BOOT-INF/classes";
        resources.createWebResourceSet(WebResourceRoot.ResourceSetType.POST, webAppMount, this.base(this.mainFile(resources)), archivePath, internalPath);
        resources.createWebResourceSet(WebResourceRoot.ResourceSetType.POST, webAppMount, this.base(this.mainFile(resources)), archivePath, bootInfPath + internalPath);
    }

    private void addClasspathResourceSets(WebResourceRoot resources) throws URISyntaxException, IOException {
        String webAppMount = "/";
        String archivePath = null;
        String internalPath = "/META-INF/resources";
        Enumeration<URL> urlEnumeration = this.getClass().getClassLoader().getResources("META-INF/resources/");
        while (urlEnumeration.hasMoreElements()) {
            URL url = urlEnumeration.nextElement();
            int index = url.toExternalForm().lastIndexOf("META-INF/resources/");
            if (index != -1) {
                url = new URL(url, url.toExternalForm().substring(0, index));
            }
            resources.createWebResourceSet(WebResourceRoot.ResourceSetType.POST, webAppMount, this.base(url), archivePath, internalPath);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsfTomcatLifecycleListener(Context context) {
        this.context = context;
    }

    static interface WebResourceSetCondition {
        public boolean check(WebResourceSet var1);
    }
}

