/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import java.util.regex.Matcher;
import org.jooq.util.GeneratorWriter;

public class JavaWriter
extends GeneratorWriter<JavaWriter> {
    private static final String SERIAL_STATEMENT = "__SERIAL_STATEMENT__";

    public JavaWriter(File file) {
        super(file);
    }

    public JavaWriter print(Class<?> clazz) {
        this.print(clazz.getCanonicalName());
        return this;
    }

    public JavaWriter javadoc(String string, Object ... args) {
        int t = this.tab();
        String escaped = string.replace("*/", "* /");
        ((JavaWriter)this.tab(t)).println();
        ((JavaWriter)this.tab(t)).println("/**");
        ((JavaWriter)this.tab(t)).println(" * " + escaped, args);
        ((JavaWriter)this.tab(t)).println(" */");
        return this;
    }

    public JavaWriter header(String header, Object ... args) {
        int t = this.tab();
        ((JavaWriter)this.tab(t)).println();
        ((JavaWriter)this.tab(t)).println("// -------------------------------------------------------------------------");
        ((JavaWriter)this.tab(t)).println("// " + header, args);
        ((JavaWriter)this.tab(t)).println("// -------------------------------------------------------------------------");
        return this;
    }

    public JavaWriter override() {
        this.println("@Override");
        return this;
    }

    public JavaWriter overrideIf(boolean override) {
        if (override) {
            this.println("@Override");
        }
        return this;
    }

    public JavaWriter overrideInherit() {
        int t = this.tab();
        ((JavaWriter)this.tab(t)).javadoc("{@inheritDoc}", new Object[0]);
        ((JavaWriter)this.tab(t)).println("@Override");
        return this;
    }

    public void printSerial() {
        this.println();
        this.println("\tprivate static final long serialVersionUID = %s;", SERIAL_STATEMENT);
    }

    @Override
    protected String beforeClose(String string) {
        string = string.replaceAll(SERIAL_STATEMENT, Matcher.quoteReplacement(String.valueOf(string.hashCode())));
        return string;
    }
}

