/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.SQLDialect;
import org.jooq.impl.SQLDataType;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.csv.CSVReader;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultEnumDefinition;
import org.jooq.util.DefaultMasterDataTableDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.Definition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.MasterDataTableDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.Relations;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.jaxb.CustomType;
import org.jooq.util.jaxb.EnumType;
import org.jooq.util.jaxb.ForcedType;
import org.jooq.util.jaxb.MasterDataTable;
import org.jooq.util.jaxb.Schema;

public abstract class AbstractDatabase
implements Database {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractDatabase.class);
    private SQLDialect dialect;
    private Connection connection;
    private String[] excludes;
    private String[] includes;
    private boolean supportsUnsignedTypes;
    private boolean dateAsTimestamp;
    private List<Schema> configuredSchemata;
    private List<MasterDataTable> configuredMasterDataTables;
    private List<CustomType> configuredCustomTypes;
    private List<EnumType> configuredEnumTypes;
    private List<ForcedType> configuredForcedTypes;
    private List<SchemaDefinition> schemata;
    private List<SequenceDefinition> sequences;
    private List<TableDefinition> tables;
    private List<MasterDataTableDefinition> masterDataTables;
    private List<EnumDefinition> enums;
    private List<UDTDefinition> udts;
    private List<ArrayDefinition> arrays;
    private List<RoutineDefinition> routines;
    private List<PackageDefinition> packages;
    private Relations relations;

    @Override
    public final SQLDialect getDialect() {
        if (this.dialect == null) {
            this.dialect = this.create().getDialect();
        }
        return this.dialect;
    }

    @Override
    public final void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public final Connection getConnection() {
        return this.connection;
    }

    @Override
    public final List<SchemaDefinition> getSchemata() {
        if (this.schemata == null) {
            this.schemata = new ArrayList<SchemaDefinition>();
            for (String name : this.getInputSchemata()) {
                this.schemata.add(new SchemaDefinition((Database)this, name, null));
            }
        }
        return this.schemata;
    }

    @Override
    public final SchemaDefinition getSchema(String inputName) {
        for (SchemaDefinition schema : this.getSchemata()) {
            if (!schema.getName().equals(inputName)) continue;
            return schema;
        }
        return null;
    }

    @Override
    public final List<String> getInputSchemata() {
        ArrayList<String> result = new ArrayList<String>();
        for (Schema schema : this.configuredSchemata) {
            result.add(schema.getInputSchema());
        }
        return result;
    }

    @Override
    @Deprecated
    public String getOutputSchema(String inputSchema) {
        for (Schema schema : this.configuredSchemata) {
            if (!inputSchema.equals(schema.getInputSchema())) continue;
            return schema.getOutputSchema();
        }
        return inputSchema;
    }

    @Override
    public final void setConfiguredSchemata(List<Schema> schemata) {
        this.configuredSchemata = schemata;
    }

    @Override
    public final void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    @Override
    public final String[] getExcludes() {
        return this.excludes;
    }

    @Override
    public final void setIncludes(String[] includes) {
        this.includes = includes;
    }

    @Override
    public final String[] getIncludes() {
        return this.includes;
    }

    @Override
    public final void setConfiguredMasterDataTables(List<MasterDataTable> configuredMasterDataTables) {
        this.configuredMasterDataTables = configuredMasterDataTables;
    }

    @Override
    public final List<MasterDataTable> getConfiguredMasterDataTables() {
        return this.configuredMasterDataTables;
    }

    @Override
    public final void setConfiguredEnumTypes(List<EnumType> configuredEnumTypes) {
        this.configuredEnumTypes = configuredEnumTypes;
    }

    @Override
    public final List<EnumType> getConfiguredEnumTypes() {
        return this.configuredEnumTypes;
    }

    @Override
    public final void setConfiguredCustomTypes(List<CustomType> configuredCustomTypes) {
        this.configuredCustomTypes = configuredCustomTypes;
    }

    @Override
    public final List<CustomType> getConfiguredCustomTypes() {
        return this.configuredCustomTypes;
    }

    @Override
    public final CustomType getConfiguredCustomType(String name) {
        for (CustomType type : this.configuredCustomTypes) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    @Override
    public final void setConfiguredForcedTypes(List<ForcedType> configuredForcedTypes) {
        this.configuredForcedTypes = configuredForcedTypes;
    }

    @Override
    public final List<ForcedType> getConfiguredForcedTypes() {
        return this.configuredForcedTypes;
    }

    @Override
    public final void setSupportsUnsignedTypes(boolean supportsUnsignedTypes) {
        this.supportsUnsignedTypes = supportsUnsignedTypes;
    }

    @Override
    public final boolean supportsUnsignedTypes() {
        return this.supportsUnsignedTypes;
    }

    @Override
    public final void setDateAsTimestamp(boolean dateAsTimestamp) {
        this.dateAsTimestamp = dateAsTimestamp;
    }

    @Override
    public final boolean dateAsTimestamp() {
        return this.dateAsTimestamp;
    }

    @Override
    public final List<SequenceDefinition> getSequences(SchemaDefinition schema) {
        if (this.sequences == null) {
            this.sequences = new ArrayList<SequenceDefinition>();
            try {
                List<SequenceDefinition> s = this.getSequences0();
                this.sequences = this.filterExcludeInclude(s);
                log.info((Object)"Sequences fetched", (Object)this.fetchedSize(s, this.sequences));
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching sequences", (Throwable)e);
            }
        }
        return this.filterSchema(this.sequences, schema);
    }

    @Override
    public final List<TableDefinition> getTables(SchemaDefinition schema) {
        if (this.tables == null) {
            this.tables = new ArrayList<TableDefinition>();
            try {
                List t = this.filterMasterDataTables(this.getTables0(), false);
                this.tables = this.filterExcludeInclude(t);
                log.info((Object)"Tables fetched", (Object)this.fetchedSize(t, this.tables));
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching tables", (Throwable)e);
            }
        }
        return this.filterSchema(this.tables, schema);
    }

    @Override
    public final TableDefinition getTable(SchemaDefinition schema, String name) {
        return this.getTable(schema, name, false);
    }

    @Override
    public final TableDefinition getTable(SchemaDefinition schema, String name, boolean ignoreCase) {
        TableDefinition result = null;
        result = AbstractDatabase.getDefinition(this.getTables(schema), name, ignoreCase);
        if (result == null) {
            result = AbstractDatabase.getDefinition(this.getMasterDataTables(schema), name, ignoreCase);
        }
        return result;
    }

    @Override
    public final List<MasterDataTableDefinition> getMasterDataTables(SchemaDefinition schema) {
        if (this.masterDataTables == null) {
            this.masterDataTables = new ArrayList<MasterDataTableDefinition>();
            try {
                List t = this.filterMasterDataTables(this.getTables0(), true);
                this.masterDataTables = this.filterExcludeInclude(t);
                log.info((Object)"Masterdata tables fetched", (Object)this.fetchedSize(t, this.masterDataTables));
            }
            catch (Exception e) {
                log.error((Object)"Exception while fetching master data tables", (Throwable)e);
            }
        }
        return this.filterSchema(this.masterDataTables, schema);
    }

    @Override
    public final MasterDataTableDefinition getMasterDataTable(SchemaDefinition schema, String name) {
        return this.getMasterDataTable(schema, name, false);
    }

    @Override
    public final MasterDataTableDefinition getMasterDataTable(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getMasterDataTables(schema), name, ignoreCase);
    }

    @Override
    public final List<EnumDefinition> getEnums(SchemaDefinition schema) {
        if (this.enums == null) {
            this.enums = new ArrayList<EnumDefinition>();
            try {
                List<EnumDefinition> e = this.getEnums0();
                this.enums = this.filterExcludeInclude(e);
                this.enums.addAll(this.getConfiguredEnums());
                log.info((Object)"Enums fetched", (Object)this.fetchedSize(e, this.enums));
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching enums", (Throwable)e);
            }
        }
        return this.enums;
    }

    private final List<EnumDefinition> getConfiguredEnums() {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        for (EnumType enumType : this.configuredEnumTypes) {
            String name = enumType.getName();
            DefaultEnumDefinition e = new DefaultEnumDefinition(this.getSchemata().get(0), name, null, true);
            String literals = enumType.getLiterals();
            try {
                CSVReader reader = new CSVReader((Reader)new StringReader(literals));
                e.addLiterals(reader.readNext());
            }
            catch (IOException ignore) {
                // empty catch block
            }
            result.add(e);
        }
        return result;
    }

    @Override
    public final ForcedType getConfiguredForcedType(Definition definition) {
        for (ForcedType forcedType : this.getConfiguredForcedTypes()) {
            if (!definition.getQualifiedName().matches(forcedType.getExpressions())) continue;
            return forcedType;
        }
        return null;
    }

    @Override
    public final EnumDefinition getEnum(SchemaDefinition schema, String name) {
        return this.getEnum(schema, name, false);
    }

    @Override
    public final EnumDefinition getEnum(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getEnums(schema), name, ignoreCase);
    }

    @Override
    public final List<ArrayDefinition> getArrays(SchemaDefinition schema) {
        if (this.arrays == null) {
            this.arrays = new ArrayList<ArrayDefinition>();
            try {
                List<ArrayDefinition> a = this.getArrays0();
                this.arrays = this.filterExcludeInclude(a);
                log.info((Object)"ARRAYs fetched", (Object)this.fetchedSize(a, this.arrays));
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching ARRAYS", (Throwable)e);
            }
        }
        return this.filterSchema(this.arrays, schema);
    }

    @Override
    public final ArrayDefinition getArray(SchemaDefinition schema, String name) {
        return this.getArray(schema, name, false);
    }

    @Override
    public final ArrayDefinition getArray(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getArrays(schema), name, ignoreCase);
    }

    @Override
    public final List<UDTDefinition> getUDTs(SchemaDefinition schema) {
        if (this.udts == null) {
            this.udts = new ArrayList<UDTDefinition>();
            try {
                List<UDTDefinition> u = this.getUDTs0();
                this.udts = this.filterExcludeInclude(u);
                log.info((Object)"UDTs fetched", (Object)this.fetchedSize(u, this.udts));
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching udts", (Throwable)e);
            }
        }
        return this.filterSchema(this.udts, schema);
    }

    @Override
    public final UDTDefinition getUDT(SchemaDefinition schema, String name) {
        return this.getUDT(schema, name, false);
    }

    @Override
    public final UDTDefinition getUDT(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getUDTs(schema), name, ignoreCase);
    }

    @Override
    public final Relations getRelations() {
        if (this.relations == null) {
            try {
                this.relations = this.getRelations0();
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching relations", (Throwable)e);
                this.relations = new DefaultRelations();
            }
        }
        return this.relations;
    }

    @Override
    public final List<RoutineDefinition> getRoutines(SchemaDefinition schema) {
        if (this.routines == null) {
            this.routines = new ArrayList<RoutineDefinition>();
            try {
                List<RoutineDefinition> r = this.getRoutines0();
                this.routines = this.filterExcludeInclude(r);
                log.info((Object)"Routines fetched", (Object)this.fetchedSize(r, this.routines));
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching functions", (Throwable)e);
            }
        }
        return this.filterSchema(this.routines, schema);
    }

    @Override
    public final List<PackageDefinition> getPackages(SchemaDefinition schema) {
        if (this.packages == null) {
            this.packages = new ArrayList<PackageDefinition>();
            try {
                List<PackageDefinition> p = this.getPackages0();
                this.packages = this.filterExcludeInclude(p);
                log.info((Object)"Packages fetched", (Object)this.fetchedSize(p, this.packages));
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching packages", (Throwable)e);
            }
        }
        return this.filterSchema(this.packages, schema);
    }

    static final <D extends Definition> D getDefinition(List<D> definitions, String name, boolean ignoreCase) {
        for (Definition definition : definitions) {
            if ((!ignoreCase || !definition.getName().equalsIgnoreCase(name)) && (ignoreCase || !definition.getName().equals(name))) continue;
            return (D)definition;
        }
        return null;
    }

    private final <T extends Definition> List<T> filterSchema(List<T> definitions, SchemaDefinition schema) {
        if (schema == null) {
            return definitions;
        }
        ArrayList<Definition> result = new ArrayList<Definition>();
        for (Definition definition : definitions) {
            if (!definition.getSchema().equals(schema)) continue;
            result.add(definition);
        }
        return result;
    }

    private final <T extends Definition> List<T> filterExcludeInclude(List<T> definitions) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        block0: for (Definition definition : definitions) {
            for (String exclude : this.excludes) {
                if (exclude != null && definition.getName().matches(exclude.trim())) continue block0;
            }
            for (String include : this.includes) {
                if (include == null || !definition.getName().matches(include.trim())) continue;
                result.add(definition);
                continue block0;
            }
        }
        return result;
    }

    private final <T extends TableDefinition> List<T> filterMasterDataTables(List<TableDefinition> list, boolean include) {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        block0: for (TableDefinition definition : list) {
            for (MasterDataTable table : this.configuredMasterDataTables) {
                if (!definition.getName().equals(table.getName())) continue;
                if (!include) continue block0;
                result.add(new DefaultMasterDataTableDefinition(definition));
                continue block0;
            }
            if (include) continue;
            result.add(definition);
        }
        return result;
    }

    protected final Relations getRelations0() throws SQLException {
        DefaultRelations result = new DefaultRelations();
        this.loadPrimaryKeys(result);
        this.loadUniqueKeys(result);
        this.loadForeignKeys(result);
        return result;
    }

    @Override
    public final boolean isArrayType(String dataType) {
        switch (this.getDialect()) {
            case POSTGRES: 
            case H2: {
                return "ARRAY".equals(dataType);
            }
            case HSQLDB: {
                return dataType.endsWith("ARRAY");
            }
        }
        return false;
    }

    private final String fetchedSize(List<?> fetched, List<?> included) {
        return fetched.size() + " (" + included.size() + " included, " + (fetched.size() - included.size()) + " excluded)";
    }

    protected abstract void loadPrimaryKeys(DefaultRelations var1) throws SQLException;

    protected abstract void loadUniqueKeys(DefaultRelations var1) throws SQLException;

    protected abstract void loadForeignKeys(DefaultRelations var1) throws SQLException;

    protected abstract List<SequenceDefinition> getSequences0() throws SQLException;

    protected abstract List<TableDefinition> getTables0() throws SQLException;

    protected abstract List<RoutineDefinition> getRoutines0() throws SQLException;

    protected abstract List<PackageDefinition> getPackages0() throws SQLException;

    protected abstract List<EnumDefinition> getEnums0() throws SQLException;

    protected abstract List<UDTDefinition> getUDTs0() throws SQLException;

    protected abstract List<ArrayDefinition> getArrays0() throws SQLException;

    protected final DataTypeDefinition getDataTypeForMAX_VAL(SchemaDefinition schema, BigInteger value) {
        DefaultDataTypeDefinition type = BigInteger.valueOf(127L).compareTo(value) >= 0 ? new DefaultDataTypeDefinition(this, schema, SQLDataType.NUMERIC.getTypeName(), 0, 2, 0) : (BigInteger.valueOf(32767L).compareTo(value) >= 0 ? new DefaultDataTypeDefinition(this, schema, SQLDataType.NUMERIC.getTypeName(), 0, 4, 0) : (BigInteger.valueOf(Integer.MAX_VALUE).compareTo(value) >= 0 ? new DefaultDataTypeDefinition(this, schema, SQLDataType.NUMERIC.getTypeName(), 0, 9, 0) : (BigInteger.valueOf(Long.MAX_VALUE).compareTo(value) >= 0 ? new DefaultDataTypeDefinition(this, schema, SQLDataType.NUMERIC.getTypeName(), 0, 18, 0) : new DefaultDataTypeDefinition(this, schema, SQLDataType.NUMERIC.getTypeName(), 0, 38, 0))));
        return type;
    }
}

