/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractElementContainerDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UniqueKeyDefinition;

public abstract class AbstractTableDefinition
extends AbstractElementContainerDefinition<ColumnDefinition>
implements TableDefinition {
    private List<UniqueKeyDefinition> uniqueKeys;
    private List<ForeignKeyDefinition> foreignKeys;
    private boolean mainUniqueKeyLoaded;
    private UniqueKeyDefinition mainUniqueKey;
    private boolean identityLoaded;
    private ColumnDefinition identity;

    public AbstractTableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    @Override
    public final UniqueKeyDefinition getMainUniqueKey() {
        if (!this.mainUniqueKeyLoaded) {
            this.mainUniqueKeyLoaded = true;
            for (ColumnDefinition column : this.getColumns()) {
                if (column.getPrimaryKey() == null) continue;
                this.mainUniqueKey = column.getPrimaryKey();
                return this.mainUniqueKey;
            }
            for (ColumnDefinition column : this.getColumns()) {
                UniqueKeyDefinition uniqueKey;
                Iterator<UniqueKeyDefinition> i$ = column.getUniqueKeys().iterator();
                if (!i$.hasNext()) continue;
                this.mainUniqueKey = uniqueKey = i$.next();
                return this.mainUniqueKey;
            }
        }
        return this.mainUniqueKey;
    }

    @Override
    public final List<UniqueKeyDefinition> getUniqueKeys() {
        if (this.uniqueKeys == null) {
            this.uniqueKeys = this.getDatabase().getRelations().getUniqueKeys(this);
        }
        return this.uniqueKeys;
    }

    @Override
    public final List<ForeignKeyDefinition> getForeignKeys() {
        if (this.foreignKeys == null) {
            this.foreignKeys = this.getDatabase().getRelations().getForeignKeys(this);
        }
        return this.foreignKeys;
    }

    @Override
    public final ColumnDefinition getIdentity() {
        if (!this.identityLoaded) {
            this.identityLoaded = true;
            for (ColumnDefinition column : this.getColumns()) {
                if (!column.isIdentity()) continue;
                this.identity = column;
                break;
            }
        }
        return this.identity;
    }

    @Override
    public final Table<Record> getTable() {
        return Factory.table((String)this.getQualifiedName());
    }

    @Override
    public final List<ColumnDefinition> getColumns() {
        return this.getElements();
    }

    @Override
    public final ColumnDefinition getColumn(String columnName) {
        return (ColumnDefinition)this.getElement(columnName);
    }

    @Override
    public final ColumnDefinition getColumn(String columnName, boolean ignoreCase) {
        return (ColumnDefinition)this.getElement(columnName, ignoreCase);
    }

    @Override
    protected List<ColumnDefinition> getElements0() throws SQLException {
        return null;
    }

    @Override
    public final ColumnDefinition getColumn(int columnIndex) {
        return (ColumnDefinition)this.getElement(columnIndex);
    }
}

